/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.filters;

import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import moa.streams.filters.AbstractStreamFilter;

public class NormalisationFilter
extends AbstractStreamFilter {
    private static final long serialVersionUID = 1L;
    double[] maximums;
    double[] minimums;

    @Override
    public String getPurposeString() {
        return "Standardise or Normalise instances in a stream.";
    }

    @Override
    protected void restartImpl() {
        this.maximums = null;
        this.minimums = null;
    }

    @Override
    public InstancesHeader getHeader() {
        return this.inputStream.getHeader();
    }

    @Override
    public Instance filterInstance(Instance inst) {
        if (this.maximums == null && this.minimums == null) {
            this.maximums = new double[inst.numAttributes() - 1];
            this.minimums = new double[inst.numAttributes() - 1];
            for (int i = 0; i < inst.numAttributes() - 1; ++i) {
                this.maximums[i] = inst.value(i);
                this.minimums[i] = inst.value(i);
            }
        }
        Instance normalisedInstance = inst.copy();
        for (int i = 0; i < inst.numAttributes() - 1; ++i) {
            if (inst.attribute(i).isNominal()) continue;
            if (this.minimums[i] > inst.value(i)) {
                this.minimums[i] = inst.value(i);
            }
            if (this.maximums[i] < inst.value(i)) {
                this.maximums[i] = inst.value(i);
            }
            if (this.maximums[i] - this.minimums[i] != 0.0) {
                normalisedInstance.setValue(i, (inst.value(i) - this.minimums[i]) / (this.maximums[i] - this.minimums[i]));
                continue;
            }
            normalisedInstance.setValue(i, 0.0);
        }
        return normalisedInstance;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }
}

