/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.filters;

import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Attribute;
import com.yahoo.labs.samoa.instances.DenseInstance;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.Instances;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import java.util.Arrays;
import java.util.Random;
import java.util.stream.IntStream;
import moa.core.FastVector;
import moa.core.InstanceExample;
import moa.streams.InstanceStream;
import moa.streams.filters.AbstractStreamFilter;

public class RandomProjectionFilter
extends AbstractStreamFilter {
    private static final long serialVersionUID = 1L;
    public IntOption dim = new IntOption("OutputFeatureDimension", 'd', "the target feature dimension.", 10);
    protected InstancesHeader streamHeader;
    protected double[][] GaussMatrix;

    @Override
    public String getPurposeString() {
        return "Reduces the number of input features using random projection.";
    }

    @Override
    protected void restartImpl() {
        this.streamHeader = null;
    }

    @Override
    public InstancesHeader getHeader() {
        Instance sparseInstance = (Instance)this.inputStream.nextInstance().getData();
        Random r = new Random(System.currentTimeMillis());
        this.GaussMatrix = new double[this.dim.getValue()][sparseInstance.numAttributes() - 1];
        for (int i = 0; i < this.dim.getValue(); ++i) {
            for (int j = 0; j < sparseInstance.numAttributes() - 1; ++j) {
                this.GaussMatrix[i][j] = r.nextGaussian();
            }
        }
        if (this.streamHeader == null) {
            FastVector<Attribute> attributes = new FastVector<Attribute>();
            for (int i = 0; i < this.dim.getValue(); ++i) {
                attributes.addElement(new Attribute("numeric" + (i + 1)));
            }
            attributes.addElement(sparseInstance.classAttribute());
            this.streamHeader = new InstancesHeader(new Instances(this.getCLICreationString(InstanceStream.class), attributes, 0));
            this.streamHeader.setClassIndex(this.streamHeader.numAttributes() - 1);
        }
        return this.streamHeader;
    }

    @Override
    public InstanceExample nextInstance() {
        Instance sparseInstance = (Instance)this.inputStream.nextInstance().getData();
        return new InstanceExample(this.transformedInstance(sparseInstance, this.randomProjection(sparseInstance, this.GaussMatrix)));
    }

    public DenseInstance transformedInstance(Instance sparseInst, double[] val) {
        InstancesHeader header = this.streamHeader;
        double[] attributeValues = new double[header.numAttributes()];
        System.arraycopy(val, 0, attributeValues, 0, header.numAttributes() - 1);
        attributeValues[attributeValues.length - 1] = sparseInst.classValue();
        DenseInstance newInstance = new DenseInstance(1.0, attributeValues);
        newInstance.setDataset(header);
        return newInstance;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    public double[] randomProjection(Instance instance, double[][] gm) {
        double[] ins = new double[instance.numAttributes() - 1];
        for (int i = 0; i < instance.numAttributes() - 1; ++i) {
            ins[i] = instance.value(i);
        }
        double[] denseValues = RandomProjectionFilter.multiply(gm, ins);
        return denseValues;
    }

    public static double[] multiply(double[][] matrix, double[] vector) {
        return Arrays.stream(matrix).mapToDouble(row -> IntStream.range(0, ((double[])row).length).mapToDouble(col -> row[col] * vector[col]).sum()).toArray();
    }
}

