/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.filters;

import com.github.javacliparser.FloatOption;
import com.github.javacliparser.MultiChoiceOption;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import moa.streams.filters.AbstractStreamFilter;

public class StandardisationFilter
extends AbstractStreamFilter {
    public MultiChoiceOption AlgorithmOption = new MultiChoiceOption("AlgorithmOption", 'a', "Standardisation Algorithm Option", new String[]{"Naive", "Welford", "Two-pass", "Weighted"}, new String[]{"Naive(default)", "Welford", "Two-pass", "Weighted"}, 0);
    public FloatOption WeightedOptionFloat = new FloatOption("WeightedOptionFloat", 'w', "The weight of weighted incremental algorithm", 0.0);
    private static final long serialVersionUID = 1L;
    private static double[] sum;
    private static double[] sumOfSquare;
    private static int count;
    private static double[] delta;
    private static double[] delta2;
    private static double[] M2;
    private static double[] mean;
    private static double[] meanOld;
    protected int AlgorithmIndex = 0;

    @Override
    public String getPurposeString() {
        return "Standardise or Normalise instances in a stream.";
    }

    @Override
    protected void restartImpl() {
        sum = null;
        sumOfSquare = null;
        delta = null;
        delta2 = null;
        count = 0;
        M2 = null;
        mean = null;
        meanOld = null;
    }

    @Override
    public InstancesHeader getHeader() {
        return this.inputStream.getHeader();
    }

    @Override
    public Instance filterInstance(Instance inst) {
        if (sum == null) {
            sum = new double[inst.numAttributes() - 1];
        }
        if (sumOfSquare == null) {
            sumOfSquare = new double[inst.numAttributes() - 1];
        }
        if (delta == null) {
            delta = new double[inst.numAttributes() - 1];
        }
        if (delta2 == null) {
            delta2 = new double[inst.numAttributes() - 1];
        }
        if (M2 == null) {
            M2 = new double[inst.numAttributes() - 1];
        }
        if (mean == null) {
            mean = new double[inst.numAttributes() - 1];
        }
        if (meanOld == null) {
            meanOld = new double[inst.numAttributes() - 1];
        }
        this.AlgorithmIndex = this.AlgorithmOption.getChosenIndex();
        Instance standardisedInstance = inst.copy();
        ++count;
        block5: for (int i = 0; i < inst.numAttributes() - 1; ++i) {
            if (inst.attribute(i).isNominal()) continue;
            switch (this.AlgorithmIndex) {
                case 0: {
                    int n = i;
                    sum[n] = sum[n] + inst.value(i);
                    int n2 = i;
                    sumOfSquare[n2] = sumOfSquare[n2] + inst.value(i) * inst.value(i);
                    if (sumOfSquare[i] / (double)count != 0.0) {
                        standardisedInstance.setValue(i, (inst.value(i) - sum[i] / (double)count) / Math.sqrt((sumOfSquare[i] - sum[i] * sum[i] / (double)count) / (double)(count - 1)));
                        continue block5;
                    }
                    standardisedInstance.setValue(i, 0.0);
                    continue block5;
                }
                case 1: {
                    StandardisationFilter.delta[i] = inst.value(i) - mean[i];
                    int n = i;
                    mean[n] = mean[n] + delta[i] / (double)count;
                    StandardisationFilter.delta2[i] = inst.value(i) - mean[i];
                    int n3 = i;
                    M2[n3] = M2[n3] + delta[i] * delta2[i];
                    if (M2[i] / (double)count != 0.0) {
                        standardisedInstance.setValue(i, (inst.value(i) - mean[i]) / Math.sqrt(M2[i] / (double)(count - 1)));
                        continue block5;
                    }
                    standardisedInstance.setValue(i, 0.0);
                    continue block5;
                }
                case 2: {
                    int n = i;
                    delta[n] = delta[n] + inst.value(i);
                    StandardisationFilter.mean[i] = delta[i] / (double)count;
                    int n4 = i;
                    delta2[n4] = delta2[n4] + (inst.value(i) - mean[i]) * (inst.value(i) - mean[i]);
                    if (delta2[i] / (double)count != 0.0) {
                        standardisedInstance.setValue(i, (inst.value(i) - mean[i]) / Math.sqrt(delta2[i] / (double)(count - 1)));
                        continue block5;
                    }
                    standardisedInstance.setValue(i, 0.0);
                }
            }
        }
        return standardisedInstance;
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    static {
        count = 0;
    }
}

