/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks;

import com.github.javacliparser.FloatOption;
import com.yahoo.labs.samoa.instances.Instances;
import javax.swing.JProgressBar;
import moa.capabilities.CapabilitiesHandler;
import moa.core.ObjectRepository;
import moa.learners.featureanalysis.ClassifierWithFeatureImportance;
import moa.options.ClassOption;
import moa.tasks.ClassificationMainTask;
import moa.tasks.TaskMonitor;

public class FeatureImportanceConfig
extends ClassificationMainTask
implements CapabilitiesHandler {
    private static final long serialVersionUID = 1L;
    protected Instances m_instances;
    protected double[][] scores;
    protected double m_NaNSubstitute = 0.0;
    protected int m_windowSize = 500;
    protected boolean m_doNotNormalizeFeatureScore = false;
    protected JProgressBar progressBar = new JProgressBar();
    public ClassOption learnerOption = new ClassOption("learner", 'l', "Classifier with feature importance Learner to train.", ClassifierWithFeatureImportance.class, "moa.learners.featureanalysis.ClassifierWithFeatureImportance");
    public FloatOption nanSubstitute = new FloatOption("NaNSubstitute", 'u', "When scores of feature importance are NaN, NaN will be replaced by NaNSubstitute shown in line graph.", 0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);

    public double getNaNSubstitute() {
        return this.m_NaNSubstitute;
    }

    public void setNaNSubstitute(double NaNSubstitute) {
        this.m_NaNSubstitute = NaNSubstitute;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public int getWindowSize() {
        return this.m_windowSize;
    }

    public void setWindowSize(int windowSize) {
        this.m_windowSize = windowSize;
    }

    public boolean doNotNormalizeFeatureScore() {
        return this.m_doNotNormalizeFeatureScore;
    }

    public void setDoNotNormalizeFeatureScore(boolean doNotNormalizeFeatureScore) {
        this.m_doNotNormalizeFeatureScore = doNotNormalizeFeatureScore;
    }

    @Override
    protected Object doMainTask(TaskMonitor monitor, ObjectRepository repository) {
        ClassifierWithFeatureImportance cwfi = (ClassifierWithFeatureImportance)this.getPreparedClassOption(this.learnerOption);
        cwfi.resetLearningImpl();
        int windowSize = cwfi.windowSizeOption.getValue();
        this.setWindowSize(windowSize);
        boolean doNotNormalizeFeatureScore = cwfi.doNotNormalizeFeatureScoreOption.isSet();
        this.setDoNotNormalizeFeatureScore(doNotNormalizeFeatureScore);
        double nanSubstitute = this.nanSubstitute.getValue();
        this.setNaNSubstitute(nanSubstitute);
        int row = 0;
        int instanceSeen = 0;
        int numInstances = this.m_instances.numInstances();
        int rows = numInstances / windowSize;
        int columns = this.m_instances.numAttributes() - 1;
        double[][] scores = new double[rows][columns];
        this.progressBar.setValue(0);
        this.progressBar.setMaximum(rows);
        if (this.m_instances != null) {
            for (int i = 0; i < numInstances; ++i) {
                cwfi.trainOnInstance(this.m_instances.get(i));
                if (++instanceSeen % windowSize != 0) continue;
                double[] currentScore = cwfi.getCurrentFeatureImportances();
                for (int j = 0; j < columns; ++j) {
                    scores[row][j] = currentScore[j];
                }
                this.progressBar.setValue(++row);
            }
        }
        return scores;
    }

    @Override
    public Class<?> getTaskResultType() {
        return null;
    }

    @Override
    public String getPurposeString() {
        return "Set parameters for feature importance learner to get scores of feature importance.";
    }

    public void setInstances(Instances instances) {
        this.m_instances = instances;
    }
}

