/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks.ipynb;

import java.util.ArrayList;
import moa.tasks.ipynb.CodeCellBuilder;
import moa.tasks.ipynb.MarkDownCellBuilder;
import moa.tasks.ipynb.NotebookCellBuilder;
import moa.tasks.ipynb.RawCellBuilder;

public class NotebookBuilder {
    private ArrayList<NotebookCellBuilder> notebookCells = new ArrayList();
    private int executionCount = 1;

    public String build() {
        StringBuilder notebook = new StringBuilder();
        notebook.append("{\n\"cells\": [\n");
        for (NotebookCellBuilder cell : this.notebookCells) {
            notebook.append((CharSequence)cell.build()).append(",\n");
        }
        if (this.notebookCells.size() != 0) {
            notebook.deleteCharAt(notebook.length() - 2);
        }
        notebook.append("],\n").append("\"metadata\": {},\n\"nbformat\": 4,\n\"nbformat_minor\": 0\n}\n");
        return notebook.toString();
    }

    public NotebookCellBuilder addCode() {
        CodeCellBuilder cell = new CodeCellBuilder();
        cell.executionCount = this.executionCount++;
        this.notebookCells.add(cell);
        return cell;
    }

    public NotebookCellBuilder addMarkdown() {
        MarkDownCellBuilder cell = new MarkDownCellBuilder();
        this.notebookCells.add(cell);
        return cell;
    }

    public NotebookCellBuilder addRaw() {
        RawCellBuilder cell = new RawCellBuilder();
        this.notebookCells.add(cell);
        return cell;
    }

    public NotebookCellBuilder getLastCell() {
        return this.notebookCells.get(this.notebookCells.size() - 1);
    }

    public NotebookCellBuilder getCellByIndex(int index) {
        return this.notebookCells.get(index);
    }
}

