/*
 * Decompiled with CFR 0.152.
 */
package moa.tasks.ipynb;

import java.util.HashMap;
import java.util.Map;

public abstract class NotebookCellBuilder {
    private StringBuilder source = new StringBuilder();

    NotebookCellBuilder() {
    }

    protected abstract String cellType();

    public final NotebookCellBuilder addSource(String line) {
        if (this.source.length() > 0) {
            this.source.append(",\n");
        }
        this.source.append("\"").append(line.replace("\"", "\\\"")).append("\\n\"");
        return this;
    }

    protected Map<String, String> fields() {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("cell_type", "\"" + this.cellType() + "\"");
        fields.put("metadata", "{}");
        return fields;
    }

    public final StringBuilder build() {
        StringBuilder cell = new StringBuilder();
        cell.append("{\n");
        for (Map.Entry<String, String> fieldEntry : this.fields().entrySet()) {
            String fieldName = fieldEntry.getKey();
            String fieldContents = fieldEntry.getValue();
            cell.append("\"").append(fieldName).append("\": ").append(fieldContents).append(",\n");
        }
        cell.append("\"source\": [\n").append((CharSequence)this.source).append("\n]\n");
        cell.append("}");
        return cell;
    }
}

