/*
 * Decompiled with CFR 0.152.
 */
package opex4j;

import com.google.gson.JsonObject;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import opex4j.Polygon;
import opex4j.core.AbstractJsonHandler;

public class BBox
extends AbstractJsonHandler {
    protected int m_Top;
    protected int m_Left;
    protected int m_Bottom;
    protected int m_Right;

    public BBox(int left, int top, int right, int bottom) {
        if (top >= bottom) {
            throw new IllegalArgumentException("Violation of top < bottom: top=" + top + " and bottom=" + bottom);
        }
        if (left >= right) {
            throw new IllegalArgumentException("Violation of left < right: left=" + left + " and right=" + right);
        }
        this.m_Top = top;
        this.m_Left = left;
        this.m_Bottom = bottom;
        this.m_Right = right;
    }

    public int getLeft() {
        return this.m_Left;
    }

    public int getTop() {
        return this.m_Top;
    }

    public int getRight() {
        return this.m_Right;
    }

    public int getBottom() {
        return this.m_Bottom;
    }

    @Override
    public JsonObject toJson() {
        JsonObject result = new JsonObject();
        result.addProperty("top", (Number)this.m_Top);
        result.addProperty("left", (Number)this.m_Left);
        result.addProperty("bottom", (Number)this.m_Bottom);
        result.addProperty("right", (Number)this.m_Right);
        return result;
    }

    public Rectangle toRectangle() {
        return new Rectangle(this.getLeft(), this.getTop(), this.getRight() - this.getLeft() + 1, this.getBottom() - this.getTop() + 1);
    }

    public Polygon toPolygon() {
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(this.getLeft(), this.getTop()));
        points.add(new Point(this.getRight(), this.getTop()));
        points.add(new Point(this.getRight(), this.getBottom()));
        points.add(new Point(this.getLeft(), this.getBottom()));
        return new Polygon(points);
    }

    public static BBox newInstance(JsonObject obj) {
        return new BBox(obj.get("left").getAsInt(), obj.get("top").getAsInt(), obj.get("right").getAsInt(), obj.get("bottom").getAsInt());
    }

    public static BBox newInstance(Rectangle rect) {
        return new BBox(rect.x, rect.y, rect.x + rect.width - 1, rect.y + rect.height - 1);
    }

    public static BBox newInstance(int x, int y, int width, int height) {
        return new BBox(x, y, x + width - 1, y + height - 1);
    }
}

