/*
 * Decompiled with CFR 0.152.
 */
package opex4j;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import opex4j.BBox;
import opex4j.Polygon;
import opex4j.core.AbstractJsonHandler;

public class ObjectPrediction
extends AbstractJsonHandler {
    protected Double m_Score;
    protected String m_Label;
    protected BBox m_BBox;
    protected Polygon m_Polygon;
    protected Map<String, String> m_Meta;

    public ObjectPrediction(String label, BBox bbox) {
        this(label, bbox, bbox.toPolygon(), null);
    }

    public ObjectPrediction(String label, Polygon polygon) {
        this(label, polygon.toBBox(), polygon, null);
    }

    public ObjectPrediction(String label, BBox bbox, Polygon polygon, Map<String, String> meta) {
        this(label, null, bbox, polygon, meta);
    }

    public ObjectPrediction(String label, Double score, BBox bbox, Polygon polygon, Map<String, String> meta) {
        this.m_Label = label;
        this.m_Score = score;
        this.m_BBox = bbox;
        this.m_Polygon = polygon;
        this.m_Meta = meta == null ? new HashMap<String, String>() : new HashMap<String, String>(meta);
    }

    public String getLabel() {
        return this.m_Label;
    }

    public Double getScore() {
        return this.m_Score;
    }

    public BBox getBBox() {
        return this.m_BBox;
    }

    public Polygon getPolygon() {
        return this.m_Polygon;
    }

    public Map<String, String> getMeta() {
        return this.m_Meta;
    }

    @Override
    public JsonObject toJson() {
        JsonObject result = new JsonObject();
        if (this.m_Score != null) {
            result.addProperty("score", (Number)this.m_Score);
        }
        result.addProperty("label", this.m_Label);
        result.add("bbox", (JsonElement)this.m_BBox.toJson());
        result.add("polygon", (JsonElement)this.m_Polygon.toJson());
        if (this.m_Meta.size() > 0) {
            JsonObject meta = new JsonObject();
            for (String key : this.m_Meta.keySet()) {
                meta.addProperty(key, this.m_Meta.get(key));
            }
            result.add("meta", (JsonElement)meta);
        }
        return result;
    }

    public static ObjectPrediction newInstance(JsonObject obj) {
        Double score = obj.has("score") ? Double.valueOf(obj.get("score").getAsDouble()) : null;
        String label = obj.get("label").getAsString();
        BBox bbox = BBox.newInstance(obj.get("bbox").getAsJsonObject());
        Polygon polygon = Polygon.newInstance(obj.get("polygon").getAsJsonObject());
        HashMap<String, String> meta = null;
        if (obj.has("meta")) {
            JsonObject jmeta = obj.get("meta").getAsJsonObject();
            meta = new HashMap<String, String>();
            for (String key : jmeta.keySet()) {
                meta.put(key, jmeta.get(key).getAsString());
            }
        }
        return new ObjectPrediction(label, score, bbox, polygon, meta);
    }
}

