/*
 * Decompiled with CFR 0.152.
 */
package opex4j;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import opex4j.BBox;
import opex4j.core.AbstractJsonHandler;

public class Polygon
extends AbstractJsonHandler {
    protected List<Point> m_Points;

    public Polygon(List<Point> points) {
        if (points == null) {
            throw new IllegalArgumentException("Points cannot be null!");
        }
        if (points.size() < 3) {
            throw new IllegalArgumentException("At least three points required, provided: " + points.size());
        }
        this.m_Points = new ArrayList<Point>(points);
    }

    public List<Point> getPoints() {
        return this.m_Points;
    }

    public int size() {
        return this.m_Points.size();
    }

    @Override
    public JsonObject toJson() {
        JsonObject result = new JsonObject();
        JsonArray points = new JsonArray();
        result.add("points", (JsonElement)points);
        for (Point p : this.m_Points) {
            JsonArray point = new JsonArray();
            point.add((Number)((int)p.getX()));
            point.add((Number)((int)p.getY()));
            points.add((JsonElement)point);
        }
        return result;
    }

    public java.awt.Polygon toPolygon() {
        int[] x = new int[this.size()];
        int[] y = new int[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            x[i] = (int)this.m_Points.get(i).getX();
            y[i] = (int)this.m_Points.get(i).getY();
        }
        return new java.awt.Polygon(x, y, x.length);
    }

    public BBox toBBox() {
        int minx = Integer.MAX_VALUE;
        int maxx = 0;
        int miny = Integer.MAX_VALUE;
        int maxy = 0;
        for (Point p : this.m_Points) {
            minx = Math.min(minx, (int)p.getX());
            maxx = Math.max(maxx, (int)p.getX());
            miny = Math.min(miny, (int)p.getY());
            maxy = Math.max(maxy, (int)p.getY());
        }
        return new BBox(minx, miny, maxx, maxy);
    }

    public static Polygon newInstance(JsonObject obj) {
        JsonArray jpoints = obj.getAsJsonArray("points");
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < jpoints.size(); ++i) {
            JsonArray jpoint = jpoints.get(i).getAsJsonArray();
            points.add(new Point(jpoint.get(0).getAsInt(), jpoint.get(1).getAsInt()));
        }
        return new Polygon(points);
    }

    public static Polygon newInstance(java.awt.Polygon polygon) {
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < polygon.npoints; ++i) {
            points.add(new Point(polygon.xpoints[i], polygon.ypoints[i]));
        }
        return new Polygon(points);
    }
}

