/*
 * Decompiled with CFR 0.152.
 */
package opex4j;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import opex4j.ObjectPrediction;
import opex4j.core.AbstractJsonHandler;

public class ObjectPredictions
extends AbstractJsonHandler {
    public static final String TIMESTAMP_FORMAT = "yyyyMMdd_HHmmss.SSSSSS";
    public static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss.SSSSSS");
    public static final String TIMESTAMP_FORMAT_ALT = "yyyy-MM-dd HH:mm:ss.SSSSSS";
    public static final DateTimeFormatter TIMESTAMP_FORMATTER_ALT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS");
    protected LocalDateTime m_Timestamp;
    protected String m_ID;
    protected List<ObjectPrediction> m_Objects;
    protected Map<String, String> m_Meta;

    public ObjectPredictions(LocalDateTime timestamp, String id, List<ObjectPrediction> objects) {
        this(timestamp, id, objects, null);
    }

    public ObjectPredictions(LocalDateTime timestamp, String id, List<ObjectPrediction> objects, Map<String, String> meta) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("ID cannot be null or empty!");
        }
        this.m_Timestamp = timestamp;
        this.m_ID = id;
        this.m_Objects = objects == null ? new ArrayList<ObjectPrediction>() : new ArrayList<ObjectPrediction>(objects);
        this.m_Meta = meta == null ? new HashMap<String, String>() : new HashMap<String, String>(meta);
    }

    public LocalDateTime getTimestamp() {
        return this.m_Timestamp;
    }

    public String getTimestampStr() {
        if (this.m_Timestamp != null) {
            return TIMESTAMP_FORMATTER.format(this.m_Timestamp);
        }
        return null;
    }

    public String getID() {
        return this.m_ID;
    }

    public List<ObjectPrediction> getObjects() {
        return this.m_Objects;
    }

    public Map<String, String> getMeta() {
        return this.m_Meta;
    }

    @Override
    public JsonObject toJson() {
        JsonObject result = new JsonObject();
        if (this.m_Timestamp != null) {
            result.addProperty("timestamp", TIMESTAMP_FORMATTER.format(this.m_Timestamp));
        }
        result.addProperty("id", this.m_ID);
        JsonArray objects = new JsonArray();
        for (ObjectPrediction obj : this.m_Objects) {
            objects.add((JsonElement)obj.toJson());
        }
        result.add("objects", (JsonElement)objects);
        if (this.m_Meta.size() > 0) {
            JsonObject meta = new JsonObject();
            for (String key : this.m_Meta.keySet()) {
                meta.addProperty(key, this.m_Meta.get(key));
            }
            result.add("meta", (JsonElement)meta);
        }
        return result;
    }

    public void write(File file) throws IOException {
        this.write(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, boolean prettyPrint) throws IOException {
        FileWriter fwriter = null;
        BufferedWriter bwriter = null;
        try {
            fwriter = new FileWriter(file);
            bwriter = new BufferedWriter(fwriter);
            bwriter.write(this.toString(prettyPrint));
            bwriter.flush();
        }
        finally {
            if (bwriter != null) {
                try {
                    bwriter.close();
                }
                catch (Exception exception) {}
            }
            if (fwriter != null) {
                try {
                    fwriter.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void write(Writer writer) throws IOException {
        this.write(writer, true);
    }

    public void write(Writer writer, boolean prettyPrint) throws IOException {
        writer.write(this.toString(prettyPrint));
    }

    public void write(OutputStream stream) throws IOException {
        this.write(stream, true);
    }

    public void write(OutputStream stream, boolean prettyPrint) throws IOException {
        stream.write(this.toString(prettyPrint).getBytes());
    }

    public void write(StringBuilder builder) {
        this.write(builder, true);
    }

    public void write(StringBuilder builder, boolean prettyPrint) {
        builder.append(this.toString(prettyPrint));
    }

    public static ObjectPredictions newInstance(JsonObject obj) {
        LocalDateTime timestamp = null;
        if (obj.has("timestamp") && !obj.get("timestamp").isJsonNull()) {
            String timestampStr = obj.get("timestamp").getAsString();
            try {
                timestamp = LocalDateTime.parse(timestampStr, TIMESTAMP_FORMATTER);
            }
            catch (Exception e) {
                try {
                    timestamp = LocalDateTime.parse(timestampStr, TIMESTAMP_FORMATTER_ALT);
                }
                catch (Exception e2) {
                    System.err.println("Failed to parse timestamp: " + obj);
                }
            }
        }
        String id = obj.get("id").getAsString();
        JsonArray jobjects = obj.get("objects").getAsJsonArray();
        ArrayList<ObjectPrediction> objects = new ArrayList<ObjectPrediction>();
        for (int i = 0; i < jobjects.size(); ++i) {
            objects.add(ObjectPrediction.newInstance(jobjects.get(i).getAsJsonObject()));
        }
        HashMap<String, String> meta = null;
        if (obj.has("meta") && !obj.get("meta").isJsonNull()) {
            JsonObject jmeta = obj.get("meta").getAsJsonObject();
            meta = new HashMap<String, String>();
            for (String key : jmeta.keySet()) {
                meta.put(key, jmeta.get(key).getAsString());
            }
        }
        return new ObjectPredictions(timestamp, id, objects, meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ObjectPredictions newInstance(File file) throws Exception {
        FileReader freader = null;
        BufferedReader breader = null;
        try {
            freader = new FileReader(file);
            breader = new BufferedReader(freader);
            ObjectPredictions objectPredictions = ObjectPredictions.newInstance((JsonObject)JsonParser.parseReader((Reader)breader));
            return objectPredictions;
        }
        finally {
            if (breader != null) {
                try {
                    breader.close();
                }
                catch (Exception exception) {}
            }
            if (freader != null) {
                try {
                    freader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static ObjectPredictions newInstance(Reader reader) throws Exception {
        return ObjectPredictions.newInstance((JsonObject)JsonParser.parseReader((Reader)reader));
    }

    public static ObjectPredictions newInstance(InputStream stream) throws Exception {
        return ObjectPredictions.newInstance((JsonObject)JsonParser.parseReader((Reader)new InputStreamReader(stream)));
    }

    public static ObjectPredictions newInstance(String s) throws Exception {
        return ObjectPredictions.newInstance((JsonObject)JsonParser.parseReader((Reader)new StringReader(s)));
    }
}

