/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.BatchConverter;
import weka.core.converters.ExcelLoader;

public class ExcelSaver
extends AbstractFileSaver
implements BatchConverter {
    private static final long serialVersionUID = -7446832500561589653L;
    protected String m_MissingValue = "''";
    protected boolean m_UseOOXML;

    public ExcelSaver() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Writes to a destination that is in MS Excel spreadsheet format (97-2007).\nFor instance for spreadsheets that can be read with the Microsoft Office Suite.\n";
    }

    public Enumeration<Option> listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tThe string representing a missing value.\n\t(default is empty cell represented by '')", "M", 1, "-M <str>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption((char)'M', (String[])options);
        if (tmpStr.length() != 0) {
            this.setMissingValue(tmpStr);
        } else {
            this.setMissingValue("''");
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-M");
        result.add(this.getMissingValue());
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public void setMissingValue(String value) {
        this.m_MissingValue = value;
    }

    public String getMissingValue() {
        return this.m_MissingValue;
    }

    public String missingValueTipText() {
        return "The placeholder for missing values, default is empty cell represented by ''.";
    }

    public void resetOptions() {
        super.resetOptions();
        this.setUseOOXML(false);
        this.setFileExtension(ExcelLoader.FILE_EXTENSION);
        this.setMissingValue("''");
    }

    public void setFilePrefix(String prefix) {
        super.setFilePrefix(prefix);
        this.setUseOOXML(prefix.toLowerCase().endsWith(ExcelLoader.FILE_EXTENSION_OOXML));
    }

    public String getFileDescription() {
        return ExcelLoader.FILE_DESCRIPTION;
    }

    public String[] getFileExtensions() {
        return new String[]{ExcelLoader.FILE_EXTENSION, ExcelLoader.FILE_EXTENSION_OOXML};
    }

    public void setUseOOXML(boolean value) {
        this.m_UseOOXML = value;
        if (this.m_UseOOXML) {
            this.setFileExtension(ExcelLoader.FILE_EXTENSION_OOXML);
        } else {
            this.setFileExtension(ExcelLoader.FILE_EXTENSION);
        }
    }

    public boolean retrieveUseOOXML() {
        return this.m_UseOOXML;
    }

    public void setFile(File outputFile) throws IOException {
        super.setFile(outputFile);
        if (outputFile.getName().toLowerCase().endsWith(ExcelLoader.FILE_EXTENSION_OOXML)) {
            this.setUseOOXML(true);
        }
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.STRING_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.STRING_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public void writeBatch() throws IOException {
        if (this.getInstances() == null) {
            throw new IOException("No instances to save");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        this.setRetrieval(1);
        this.setWriteMode(0);
        try {
            Cell cell;
            Instances data = this.getInstances();
            Object workbook = this.retrieveUseOOXML() ? new XSSFWorkbook() : new HSSFWorkbook();
            Sheet sheet = workbook.createSheet();
            workbook.setSheetName(0, data.relationName());
            Row row = sheet.createRow(0);
            for (int i = 0; i < data.numAttributes(); ++i) {
                cell = row.createCell(i);
                cell.setCellValue(data.attribute(i).name());
            }
            for (int n = 0; n < data.numInstances(); ++n) {
                row = sheet.createRow(n + 1);
                Instance inst = data.instance(n);
                block8: for (int i = 0; i < data.numAttributes(); ++i) {
                    cell = row.createCell(i);
                    if (inst.isMissing(i)) {
                        if (!this.m_MissingValue.equals("''")) {
                            cell.setCellValue(this.m_MissingValue);
                            continue;
                        }
                        cell.setCellType(3);
                        continue;
                    }
                    switch (data.attribute(i).type()) {
                        case 0: {
                            cell.setCellValue(inst.value(i));
                            continue block8;
                        }
                        case 1: 
                        case 2: {
                            cell.setCellValue(inst.stringValue(i));
                            continue block8;
                        }
                        default: {
                            throw new IllegalStateException("Unhandled attribute type: " + data.attribute(i).type());
                        }
                    }
                }
            }
            if (this.retrieveFile() == null) {
                workbook.write((OutputStream)System.out);
            } else {
                FileOutputStream out = new FileOutputStream(this.retrieveFile());
                workbook.write((OutputStream)out);
                ((OutputStream)out).close();
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.setWriteMode(1);
        this.resetWriter();
        this.setWriteMode(2);
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 14676 $");
    }

    public static void main(String[] args) {
        ExcelSaver.runFileSaver((AbstractFileSaver)new ExcelSaver(), (String[])args);
    }
}

