/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.dm.kf;

import groovy.lang.GroovyClassLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import org.pentaho.dm.kf.GroovyHelper;
import org.pentaho.dm.kf.KFGroovyScript;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.gui.Logger;
import weka.gui.beans.BatchClassifierEvent;
import weka.gui.beans.BatchClassifierListener;
import weka.gui.beans.BatchClustererEvent;
import weka.gui.beans.BatchClustererListener;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.ChartEvent;
import weka.gui.beans.ChartListener;
import weka.gui.beans.ConfigurationEvent;
import weka.gui.beans.ConfigurationListener;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.GraphEvent;
import weka.gui.beans.GraphListener;
import weka.gui.beans.IncrementalClassifierEvent;
import weka.gui.beans.IncrementalClassifierListener;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.InstanceListener;
import weka.gui.beans.KFStep;
import weka.gui.beans.Startable;
import weka.gui.beans.TestSetEvent;
import weka.gui.beans.TestSetListener;
import weka.gui.beans.TextEvent;
import weka.gui.beans.TextListener;
import weka.gui.beans.ThresholdDataEvent;
import weka.gui.beans.ThresholdDataListener;
import weka.gui.beans.TrainingSetEvent;
import weka.gui.beans.TrainingSetListener;
import weka.gui.beans.UserRequestAcceptor;
import weka.gui.beans.Visible;
import weka.gui.beans.VisualizableErrorEvent;
import weka.gui.beans.VisualizableErrorListener;

@KFStep(category="Scripting", toolTipText="Implement a knowledge flow component using Groovy")
public class GroovyComponent
extends JPanel
implements EnvironmentHandler,
BeanCommon,
Visible,
EventConstraints,
UserRequestAcceptor,
Startable,
TrainingSetListener,
TestSetListener,
InstanceListener,
TextListener,
DataSourceListener,
BatchClassifierListener,
IncrementalClassifierListener,
BatchClustererListener,
GraphListener,
ChartListener,
ThresholdDataListener,
VisualizableErrorListener,
ConfigurationListener,
GroovyHelper,
Serializable {
    protected BeanVisual m_visual = new BeanVisual("GroovyComponent", "org/pentaho/dm/kf/icons/GroovyComponent.gif", "org/pentaho/dm/kf/icons/GroovyComponent.gif");
    protected transient Logger m_log = null;
    protected transient Environment m_env = Environment.getSystemWide();
    protected String m_groovyScript = null;
    protected transient Object m_groovyObject = null;
    protected ArrayList<Object> m_incomingConnections = new ArrayList();
    protected ArrayList<String> m_incomingConnectionNames = new ArrayList();
    protected ArrayList<TrainingSetListener> m_trainingSetListeners = new ArrayList();
    protected ArrayList<TestSetListener> m_testSetListeners = new ArrayList();
    protected ArrayList<DataSourceListener> m_dataSourceListeners = new ArrayList();
    protected ArrayList<InstanceListener> m_instanceListeners = new ArrayList();
    protected ArrayList<TextListener> m_textListeners = new ArrayList();
    protected ArrayList<BatchClassifierListener> m_batchClassifierListeners = new ArrayList();
    protected ArrayList<IncrementalClassifierListener> m_incrementalClassifierListeners = new ArrayList();
    protected ArrayList<BatchClustererListener> m_batchClustererListeners = new ArrayList();
    protected ArrayList<GraphListener> m_graphListeners = new ArrayList();
    protected ArrayList<ChartListener> m_chartListeners = new ArrayList();
    protected ArrayList<ThresholdDataListener> m_thresholdDataListeners = new ArrayList();
    protected ArrayList<VisualizableErrorListener> m_visualizableErrorListeners = new ArrayList();

    public GroovyComponent() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    public void setScript(String script) {
        this.m_groovyScript = script;
        if (this.m_groovyScript.length() > 0) {
            try {
                this.m_groovyObject = this.compileScript(this.m_groovyScript);
                if (this.m_log != null) {
                    this.setLog(this.m_log);
                }
                if (this.m_env != null) {
                    this.setEnvironment(this.m_env);
                }
            }
            catch (Exception ex) {
                String message = this.statusMessagePrefix() + "ERROR: Unable to compile script!";
                if (this.m_log != null) {
                    this.m_log.statusMessage(message);
                    this.m_log.logMessage(message);
                }
                System.err.println(message);
            }
        }
        if (!(this.m_groovyObject instanceof KFGroovyScript)) {
            String message = this.statusMessagePrefix() + "ERROR: Script does not implement" + "KFGroovyScript!";
            if (this.m_log != null) {
                this.m_log.statusMessage(message);
                this.m_log.logMessage(message);
            } else {
                System.err.println(message);
            }
        } else {
            try {
                ((KFGroovyScript)this.m_groovyObject).setManager(this);
                if (this.m_groovyObject instanceof BeanCommon) {
                    for (int i = 0; i < this.m_incomingConnections.size(); ++i) {
                        if (!this.connectionAllowed(this.m_incomingConnectionNames.get(i))) continue;
                        ((BeanCommon)this.m_groovyObject).connectionNotification(this.m_incomingConnectionNames.get(i), this.m_incomingConnections.get(i));
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public String getScript() {
        return this.m_groovyScript;
    }

    protected Object compileScript(String script) throws Exception {
        GroovyClassLoader gcl = new GroovyClassLoader();
        Class scriptClass = gcl.parseClass(script);
        return scriptClass.newInstance();
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|";
    }

    public void setEnvironment(Environment env) {
        this.m_env = env;
        if (this.m_groovyObject instanceof EnvironmentHandler) {
            ((EnvironmentHandler)this.m_groovyObject).setEnvironment(env);
        }
    }

    public boolean connectionAllowed(String eventName) {
        if (this.m_groovyObject instanceof BeanCommon) {
            return ((BeanCommon)this.m_groovyObject).connectionAllowed(eventName);
        }
        return false;
    }

    public boolean connectionAllowed(EventSetDescriptor esd) {
        if (this.m_groovyObject instanceof BeanCommon) {
            return ((BeanCommon)this.m_groovyObject).connectionAllowed(esd.getName());
        }
        return false;
    }

    public void connectionNotification(String eventName, Object source) {
        if (this.m_groovyObject instanceof BeanCommon && this.connectionAllowed(eventName)) {
            this.m_incomingConnections.add(source);
            this.m_incomingConnectionNames.add(eventName);
            ((BeanCommon)this.m_groovyObject).connectionNotification(eventName, source);
        }
    }

    public void disconnectionNotification(String eventName, Object source) {
        if (this.m_groovyObject instanceof BeanCommon) {
            this.m_incomingConnections.remove(source);
            this.m_incomingConnectionNames.remove(eventName);
            ((BeanCommon)this.m_groovyObject).disconnectionNotification(eventName, source);
        }
    }

    public String getCustomName() {
        return this.m_visual.getText();
    }

    public void setCustomName(String name) {
        this.m_visual.setText(name);
        if (this.m_groovyObject instanceof BeanCommon) {
            ((BeanCommon)this.m_groovyObject).setCustomName(name);
        }
    }

    public boolean isBusy() {
        if (this.m_groovyObject instanceof BeanCommon) {
            return ((BeanCommon)this.m_groovyObject).isBusy();
        }
        return false;
    }

    public void setLog(Logger logger) {
        this.m_log = logger;
        if (this.m_groovyObject instanceof BeanCommon) {
            ((BeanCommon)this.m_groovyObject).setLog(logger);
        }
    }

    public void stop() {
        if (this.m_groovyObject instanceof BeanCommon) {
            ((BeanCommon)this.m_groovyObject).stop();
        }
    }

    public BeanVisual getVisual() {
        return this.m_visual;
    }

    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    public void useDefaultVisual() {
        this.m_visual.loadIcons("org/pentaho/dm/kf/icons/GroovyComponent.gif", "org/pentaho/dm/kf/icons/GroovyComponent.gif");
    }

    public boolean eventGeneratable(String eventName) {
        if (this.m_groovyObject instanceof EventConstraints) {
            return ((EventConstraints)this.m_groovyObject).eventGeneratable(eventName);
        }
        return false;
    }

    public Enumeration enumerateRequests() {
        if (this.m_groovyObject instanceof UserRequestAcceptor) {
            return ((UserRequestAcceptor)this.m_groovyObject).enumerateRequests();
        }
        return new Vector().elements();
    }

    public void performRequest(String requestName) {
        if (this.m_groovyObject instanceof UserRequestAcceptor) {
            ((UserRequestAcceptor)this.m_groovyObject).performRequest(requestName);
        }
    }

    public String getStartMessage() {
        String message = "$Start";
        if (this.m_groovyObject instanceof Startable) {
            message = ((Startable)this.m_groovyObject).getStartMessage();
        }
        return message;
    }

    public void start() throws Exception {
        if (this.getStartMessage().charAt(0) == '$') {
            return;
        }
        if (this.m_groovyObject instanceof Startable) {
            ((Startable)this.m_groovyObject).start();
        }
    }

    public void acceptTrainingSet(TrainingSetEvent e) {
        if (this.m_groovyObject instanceof TrainingSetListener) {
            ((TrainingSetListener)this.m_groovyObject).acceptTrainingSet(e);
        }
    }

    public void acceptTestSet(TestSetEvent e) {
        if (this.m_groovyObject instanceof TestSetListener) {
            ((TestSetListener)this.m_groovyObject).acceptTestSet(e);
        }
    }

    public void acceptDataSet(DataSetEvent e) {
        if (this.m_groovyObject instanceof DataSourceListener) {
            ((DataSourceListener)this.m_groovyObject).acceptDataSet(e);
        }
    }

    public void acceptInstance(InstanceEvent e) {
        if (this.m_groovyObject instanceof InstanceListener) {
            ((InstanceListener)this.m_groovyObject).acceptInstance(e);
        }
    }

    public void acceptText(TextEvent e) {
        if (this.m_groovyObject instanceof TextListener) {
            ((TextListener)this.m_groovyObject).acceptText(e);
        }
    }

    public void acceptClassifier(BatchClassifierEvent e) {
        if (this.m_groovyObject instanceof BatchClassifierListener) {
            ((BatchClassifierListener)this.m_groovyObject).acceptClassifier(e);
        }
    }

    public void acceptClassifier(IncrementalClassifierEvent e) {
        if (this.m_groovyObject instanceof IncrementalClassifierListener) {
            ((IncrementalClassifierListener)this.m_groovyObject).acceptClassifier(e);
        }
    }

    public void acceptClusterer(BatchClustererEvent e) {
        if (this.m_groovyObject instanceof BatchClustererListener) {
            ((BatchClustererListener)this.m_groovyObject).acceptClusterer(e);
        }
    }

    public void acceptGraph(GraphEvent e) {
        if (this.m_groovyObject instanceof GraphListener) {
            ((GraphListener)this.m_groovyObject).acceptGraph(e);
        }
    }

    public void acceptDataPoint(ChartEvent e) {
        if (this.m_groovyObject instanceof ChartListener) {
            ((ChartListener)this.m_groovyObject).acceptDataPoint(e);
        }
    }

    public void acceptDataSet(ThresholdDataEvent e) {
        if (this.m_groovyObject instanceof ThresholdDataListener) {
            ((ThresholdDataListener)this.m_groovyObject).acceptDataSet(e);
        }
    }

    public void acceptDataSet(VisualizableErrorEvent e) {
        if (this.m_groovyObject instanceof VisualizableErrorListener) {
            ((VisualizableErrorListener)this.m_groovyObject).acceptDataSet(e);
        }
    }

    public void acceptConfiguration(ConfigurationEvent e) {
    }

    public synchronized void addTrainingSetListener(TrainingSetListener t) {
        this.m_trainingSetListeners.add(t);
    }

    public synchronized void removeTrainingSetListener(TrainingSetListener t) {
        this.m_trainingSetListeners.remove(t);
    }

    public synchronized void addTestSetListener(TestSetListener t) {
        this.m_testSetListeners.add(t);
    }

    public synchronized void removeTestSetListener(TestSetListener t) {
        this.m_testSetListeners.remove(t);
    }

    public synchronized void addInstanceListener(InstanceListener t) {
        this.m_instanceListeners.add(t);
    }

    public synchronized void addDataSourceListener(DataSourceListener t) {
        this.m_dataSourceListeners.add(t);
    }

    public synchronized void removeDataSourceListener(DataSourceListener t) {
        this.m_dataSourceListeners.remove(t);
    }

    public synchronized void removeInstanceListener(InstanceListener t) {
        this.m_instanceListeners.remove(t);
    }

    public synchronized void addTextListener(TextListener t) {
        this.m_textListeners.add(t);
    }

    public synchronized void removeTextListener(TextListener t) {
        this.m_textListeners.remove(t);
    }

    public synchronized void addBatchClassifierListener(BatchClassifierListener t) {
        this.m_batchClassifierListeners.add(t);
    }

    public synchronized void removeBatchClassifierListener(BatchClassifierListener t) {
        this.m_batchClassifierListeners.remove(t);
    }

    public synchronized void addIncrementalClassifierListener(IncrementalClassifierListener t) {
        this.m_incrementalClassifierListeners.add(t);
    }

    public synchronized void removeIncrementalClassifierListener(IncrementalClassifierListener t) {
        this.m_incrementalClassifierListeners.remove(t);
    }

    public synchronized void addBatchClustererListener(BatchClustererListener t) {
        this.m_batchClustererListeners.add(t);
    }

    public synchronized void removeBatchClustererListener(BatchClustererListener t) {
        this.m_batchClustererListeners.remove(t);
    }

    public synchronized void addGraphListener(GraphListener t) {
        this.m_graphListeners.add(t);
    }

    public synchronized void removeGraphListener(GraphListener t) {
        this.m_graphListeners.remove(t);
    }

    public synchronized void addChartListener(ChartListener t) {
        this.m_chartListeners.add(t);
    }

    public synchronized void removeChartListener(ChartListener t) {
        this.m_chartListeners.remove(t);
    }

    public synchronized void addThresholdDataListener(ThresholdDataListener t) {
        this.m_thresholdDataListeners.add(t);
    }

    public synchronized void removeThresholdDataListener(ThresholdDataListener t) {
        this.m_thresholdDataListeners.remove(t);
    }

    public synchronized void addVisualizableErrorListener(VisualizableErrorListener t) {
        this.m_visualizableErrorListeners.add(t);
    }

    public synchronized void removeVisualizableErrorListener(VisualizableErrorListener t) {
        this.m_visualizableErrorListeners.remove(t);
    }

    @Override
    public void notifyListenerType(Object event) {
        if (event instanceof TrainingSetEvent) {
            this.notifyTrainingSetListeners((TrainingSetEvent)event);
        } else if (event instanceof TestSetEvent) {
            this.notifyTestSetListeners((TestSetEvent)event);
        } else if (event instanceof DataSetEvent) {
            this.notifyDataSourceListeners((DataSetEvent)event);
        } else if (event instanceof InstanceEvent) {
            this.notifyInstanceListeners((InstanceEvent)event);
        } else if (event instanceof TextEvent) {
            this.notifyTextListeners((TextEvent)event);
        } else if (event instanceof BatchClassifierEvent) {
            this.notifyBatchClassifierListeners((BatchClassifierEvent)event);
        } else if (event instanceof IncrementalClassifierEvent) {
            this.notifyIncrementalClassifierListeners((IncrementalClassifierEvent)event);
        } else if (event instanceof BatchClustererEvent) {
            this.notifyBatchClustererListeners((BatchClustererEvent)event);
        } else if (event instanceof GraphEvent) {
            this.notifyGraphListeners((GraphEvent)event);
        } else if (event instanceof ChartEvent) {
            this.notifyChartListeners((ChartEvent)event);
        } else if (event instanceof ThresholdDataEvent) {
            this.notifyThresholdDataListeners((ThresholdDataEvent)event);
        } else if (event instanceof VisualizableErrorEvent) {
            this.notifyVisualizableErrorListeners((VisualizableErrorEvent)event);
        }
    }

    @Override
    public ArrayList<TrainingSetListener> getTrainingSetListeners() {
        return this.m_trainingSetListeners;
    }

    @Override
    public ArrayList<TestSetListener> getTestSetListeners() {
        return this.m_testSetListeners;
    }

    @Override
    public ArrayList<DataSourceListener> getDataSourceListeners() {
        return this.m_dataSourceListeners;
    }

    @Override
    public ArrayList<InstanceListener> getInstanceListeners() {
        return this.m_instanceListeners;
    }

    @Override
    public ArrayList<TextListener> getTextListeners() {
        return this.m_textListeners;
    }

    @Override
    public ArrayList<BatchClassifierListener> getBatchClassifierListeners() {
        return this.m_batchClassifierListeners;
    }

    @Override
    public ArrayList<IncrementalClassifierListener> getIncrementalClassifierListeners() {
        return this.m_incrementalClassifierListeners;
    }

    @Override
    public ArrayList<BatchClustererListener> getBatchClustererListeners() {
        return this.m_batchClustererListeners;
    }

    @Override
    public ArrayList<GraphListener> getGraphListeners() {
        return this.m_graphListeners;
    }

    @Override
    public ArrayList<ChartListener> getChartListeners() {
        return this.m_chartListeners;
    }

    @Override
    public ArrayList<ThresholdDataListener> getThresholdDataListeners() {
        return this.m_thresholdDataListeners;
    }

    @Override
    public ArrayList<VisualizableErrorListener> getVisualizableErrorListeners() {
        return this.m_visualizableErrorListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTrainingSetListeners(TrainingSetEvent t) {
        ArrayList<TrainingSetListener> arrayList = this.m_trainingSetListeners;
        synchronized (arrayList) {
            for (TrainingSetListener l : this.m_trainingSetListeners) {
                l.acceptTrainingSet(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTestSetListeners(TestSetEvent t) {
        ArrayList<TestSetListener> arrayList = this.m_testSetListeners;
        synchronized (arrayList) {
            for (TestSetListener l : this.m_testSetListeners) {
                l.acceptTestSet(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyDataSourceListeners(DataSetEvent t) {
        ArrayList<DataSourceListener> arrayList = this.m_dataSourceListeners;
        synchronized (arrayList) {
            for (DataSourceListener l : this.m_dataSourceListeners) {
                l.acceptDataSet(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyInstanceListeners(InstanceEvent t) {
        ArrayList<InstanceListener> arrayList = this.m_instanceListeners;
        synchronized (arrayList) {
            for (InstanceListener l : this.m_instanceListeners) {
                l.acceptInstance(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTextListeners(TextEvent t) {
        ArrayList<TextListener> arrayList = this.m_textListeners;
        synchronized (arrayList) {
            for (TextListener l : this.m_textListeners) {
                l.acceptText(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyBatchClassifierListeners(BatchClassifierEvent t) {
        ArrayList<BatchClassifierListener> arrayList = this.m_batchClassifierListeners;
        synchronized (arrayList) {
            for (BatchClassifierListener l : this.m_batchClassifierListeners) {
                l.acceptClassifier(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyIncrementalClassifierListeners(IncrementalClassifierEvent t) {
        ArrayList<IncrementalClassifierListener> arrayList = this.m_incrementalClassifierListeners;
        synchronized (arrayList) {
            for (IncrementalClassifierListener l : this.m_incrementalClassifierListeners) {
                l.acceptClassifier(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyBatchClustererListeners(BatchClustererEvent t) {
        ArrayList<BatchClustererListener> arrayList = this.m_batchClustererListeners;
        synchronized (arrayList) {
            for (BatchClustererListener l : this.m_batchClustererListeners) {
                l.acceptClusterer(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyGraphListeners(GraphEvent t) {
        ArrayList<GraphListener> arrayList = this.m_graphListeners;
        synchronized (arrayList) {
            for (GraphListener l : this.m_graphListeners) {
                l.acceptGraph(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyChartListeners(ChartEvent t) {
        ArrayList<ChartListener> arrayList = this.m_chartListeners;
        synchronized (arrayList) {
            for (ChartListener l : this.m_chartListeners) {
                l.acceptDataPoint(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyThresholdDataListeners(ThresholdDataEvent t) {
        ArrayList<ThresholdDataListener> arrayList = this.m_thresholdDataListeners;
        synchronized (arrayList) {
            for (ThresholdDataListener l : this.m_thresholdDataListeners) {
                l.acceptDataSet(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyVisualizableErrorListeners(VisualizableErrorEvent t) {
        ArrayList<VisualizableErrorListener> arrayList = this.m_visualizableErrorListeners;
        synchronized (arrayList) {
            for (VisualizableErrorListener l : this.m_visualizableErrorListeners) {
                l.acceptDataSet(t);
            }
        }
    }
}

