/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.dm.kf;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultStyledDocument;
import org.pentaho.dm.kf.GroovyComponent;
import weka.core.Utils;
import weka.gui.beans.BeanCustomizer;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.scripting.GroovyScript;
import weka.gui.visualize.VisualizeUtils;

public class GroovyComponentCustomizer
extends JPanel
implements BeanCustomizer,
CustomizerCloseRequester {
    protected GroovyComponent m_groovyP;
    protected GroovyScript m_script;
    protected JTextPane m_textPane = new JTextPane();
    protected Window m_parentWindow;
    protected String m_newScript;
    protected JMenuBar m_menuBar;
    protected BeanCustomizer.ModifyListener m_modifyListener;
    public static final String PROPERTIES_FILE = "weka/gui/scripting/Groovy.props";

    public void setObject(Object object) {
        this.m_groovyP = (GroovyComponent)object;
        this.m_script = new GroovyScript(this.m_textPane.getDocument());
        String script = this.m_groovyP.getScript();
        if (script != null && script.length() > 0) {
            this.m_script.setContent(script);
        }
    }

    public GroovyComponentCustomizer() {
        Properties props;
        try {
            props = Utils.readProperties((String)PROPERTIES_FILE);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            props = new Properties();
        }
        boolean syntaxDocAvailable = true;
        try {
            Class.forName("weka.gui.scripting.SyntaxDocument");
        }
        catch (Exception ex) {
            syntaxDocAvailable = false;
        }
        if (props.getProperty("Syntax", "false").equals("true") && syntaxDocAvailable) {
            try {
                Class<?> syntaxClass = Class.forName("weka.gui.scripting.SyntaxDocument");
                Constructor<?> constructor = syntaxClass.getConstructor(Properties.class);
                Object doc = constructor.newInstance(props);
                this.m_textPane.setDocument((DefaultStyledDocument)doc);
                this.m_textPane.setBackground(VisualizeUtils.processColour((String)props.getProperty("BackgroundColor", "white"), (Color)Color.WHITE));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            this.m_textPane.setForeground(VisualizeUtils.processColour((String)props.getProperty("ForegroundColor", "black"), (Color)Color.BLACK));
            this.m_textPane.setBackground(VisualizeUtils.processColour((String)props.getProperty("BackgroundColor", "white"), (Color)Color.WHITE));
            this.m_textPane.setFont(new Font(props.getProperty("FontName", "monospaced"), 0, Integer.parseInt(props.getProperty("FontSize", "12"))));
        }
        final JFileChooser fileChooser = new JFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setMultiSelectionEnabled(false);
        this.setUpNewScript();
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.m_textPane), "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BorderLayout());
        JPanel newCompile = new JPanel();
        newCompile.setLayout(new BorderLayout());
        JButton newBut = new JButton("New");
        JButton compileBut = new JButton("Compile");
        JButton okBut = new JButton("OK");
        JButton cancelBut = new JButton("Cancel");
        newCompile.add((Component)newBut, "West");
        newCompile.add((Component)compileBut, "East");
        buttonPanel.add((Component)newCompile, "West");
        buttonPanel.add((Component)okBut, "Center");
        buttonPanel.add((Component)cancelBut, "East");
        this.add((Component)buttonPanel, "South");
        newBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroovyComponentCustomizer.this.newScript(fileChooser);
            }
        });
        compileBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroovyComponentCustomizer.this.doCompile();
            }
        });
        okBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GroovyComponentCustomizer.this.m_groovyP != null) {
                    GroovyComponentCustomizer.this.m_groovyP.setScript(GroovyComponentCustomizer.this.m_script.getContent());
                    if (GroovyComponentCustomizer.this.m_modifyListener != null) {
                        GroovyComponentCustomizer.this.m_modifyListener.setModifiedStatus((Object)GroovyComponentCustomizer.this, true);
                    }
                    GroovyComponentCustomizer.this.m_parentWindow.dispose();
                }
            }
        });
        cancelBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GroovyComponentCustomizer.this.m_modifyListener != null) {
                    GroovyComponentCustomizer.this.m_modifyListener.setModifiedStatus((Object)GroovyComponentCustomizer.this, false);
                }
                GroovyComponentCustomizer.this.m_parentWindow.dispose();
            }
        });
        this.m_menuBar = new JMenuBar();
        JMenu fileM = new JMenu();
        this.m_menuBar.add(fileM);
        fileM.setText("File");
        fileM.setMnemonic('F');
        JMenuItem newItem = new JMenuItem();
        fileM.add(newItem);
        newItem.setText("New");
        newItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        newItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroovyComponentCustomizer.this.newScript(fileChooser);
            }
        });
        JMenuItem loadItem = new JMenuItem();
        fileM.add(loadItem);
        loadItem.setText("Open File...");
        loadItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        loadItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean ok;
                int retVal = fileChooser.showOpenDialog(GroovyComponentCustomizer.this);
                if (retVal == 0 && !(ok = GroovyComponentCustomizer.this.m_script.open(fileChooser.getSelectedFile()))) {
                    JOptionPane.showMessageDialog(GroovyComponentCustomizer.this, "Couldn't open file '" + fileChooser.getSelectedFile() + "'!");
                }
            }
        });
        JMenuItem saveItem = new JMenuItem();
        fileM.add(saveItem);
        saveItem.setText("Save");
        saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        saveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GroovyComponentCustomizer.this.m_script.getFilename() != null) {
                    GroovyComponentCustomizer.this.save(null);
                } else {
                    GroovyComponentCustomizer.this.save(fileChooser);
                }
            }
        });
        JMenuItem saveAsItem = new JMenuItem();
        fileM.add(saveAsItem);
        saveAsItem.setText("Save As...");
        saveAsItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        saveAsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroovyComponentCustomizer.this.save(fileChooser);
            }
        });
        JMenu scriptM = new JMenu();
        this.m_menuBar.add(scriptM);
        scriptM.setText("Script");
        scriptM.setMnemonic('S');
        JMenuItem compileItem = new JMenuItem();
        scriptM.add(compileItem);
        compileItem.setText("Compile");
        compileItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        compileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroovyComponentCustomizer.this.doCompile();
            }
        });
        Dimension d = new Dimension(600, 800);
        this.m_textPane.setMinimumSize(d);
        this.m_textPane.setPreferredSize(d);
    }

    private void save(JFileChooser fileChooser) {
        boolean ok = false;
        if (this.m_script.getFilename() == null || fileChooser != null) {
            int retVal = fileChooser.showSaveDialog(this);
            if (retVal == 0) {
                ok = this.m_script.saveAs(fileChooser.getSelectedFile());
            }
        } else {
            ok = this.m_script.save();
        }
        if (!ok) {
            if (this.m_script.getFilename() != null) {
                JOptionPane.showMessageDialog(this, "Failed to save file '" + fileChooser.getSelectedFile() + "'!");
            } else {
                JOptionPane.showMessageDialog(this, "Failed to save file!");
            }
        }
    }

    private void doCompile() {
        String script;
        if (this.m_groovyP != null && (script = this.m_script.getContent()) != null && script.length() > 0) {
            try {
                this.m_groovyP.compileScript(script);
                JOptionPane.showMessageDialog(this, "Script compiled OK.", "Script Status", 1);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this, "Problem compiling script:\n" + ex.getMessage(), "Script Status", 1);
            }
        }
    }

    private void newScript(JFileChooser fileChooser) {
        if (this.m_groovyP != null) {
            int retVal;
            if (this.m_script.isModified() && (retVal = JOptionPane.showConfirmDialog(this, "Save changes" + (this.m_script.getFilename() != null ? " to " + this.m_script.getFilename() + "?" : " first?"))) == 0) {
                if (this.m_script.getFilename() != null) {
                    this.save(null);
                } else {
                    this.save(fileChooser);
                }
            }
            this.m_script.empty();
            this.m_script.setContent(this.m_newScript);
        }
    }

    public void setParentWindow(Window parent) {
        this.m_parentWindow = parent;
        if (parent instanceof JDialog) {
            ((JDialog)this.m_parentWindow).setJMenuBar(this.m_menuBar);
            ((JDialog)this.m_parentWindow).setTitle("Groovy Script Editor");
        }
    }

    protected void setUpNewScript() {
        StringBuffer temp = new StringBuffer();
        temp.append("import java.beans.*\n");
        temp.append("import java.io.Serializable\n");
        temp.append("import java.util.Vector\n");
        temp.append("import java.util.Enumeration\n");
        temp.append("import org.pentaho.dm.kf.KFGroovyScript\n");
        temp.append("import org.pentaho.dm.kf.GroovyHelper\n");
        temp.append("import weka.core.*\n");
        temp.append("import weka.gui.Logger\n");
        temp.append("import weka.gui.beans.*\n");
        temp.append("// add further imports here if necessary\n\n");
        temp.append("class MyScript\n");
        temp.append("\timplements\n");
        temp.append("\t\tKFGroovyScript,\n");
        temp.append("\t\tEnvironmentHandler,\n");
        temp.append("\t\tBeanCommon,\n");
        temp.append("\t\tEventConstraints,\n");
        temp.append("\t\tUserRequestAcceptor,\n");
        temp.append("\t\tTrainingSetListener,\n");
        temp.append("\t\tTestSetListener,\n");
        temp.append("\t\tDataSourceListener,\n");
        temp.append("\t\tInstanceListener,\n");
        temp.append("\t\tTextListener,\n");
        temp.append("\t\tBatchClassifierListener,\n");
        temp.append("\t\tIncrementalClassifierListener,\n");
        temp.append("\t\tBatchClustererListener,\n");
        temp.append("\t\tGraphListener,\n");
        temp.append("\t\tChartListener,\n");
        temp.append("\t\tThresholdDataListener,\n");
        temp.append("\t\tVisualizableErrorListener,\n");
        temp.append("\t\tSerializable {\n\n");
        temp.append("\t/** Don't delete!!\n");
        temp.append("\t *  GroovyHelper has the following useful methods:\n");
        temp.append("\t *\n");
        temp.append("\t *  notifyListenerType(Object event) - GroovyHelper will pass on event\n");
        temp.append("\t *    appropriate listener type for you\n");
        temp.append("\t *  ArrayList<TrainingSetListener> getTrainingSetListeners() - get\n");
        temp.append("\t *    a list of any directly connected components that are listening\n");
        temp.append("\t *    for TrainingSetEvents from us\n");
        temp.append("\t *  ArrayList<TestSetListener> getTestSetListeners()\n");
        temp.append("\t *  ArrayList<InstanceListener> getInstanceListeners()\n");
        temp.append("\t *  ArrayList<TextListener> getTextListeners()\n");
        temp.append("\t *  ArrayList<DataSourceListener> getDataSourceListeners()\n");
        temp.append("\t *  ArrayList<BatchClassifierListener> getBatchClassifierListeners()\n");
        temp.append("\t *  ArrayList<IncrementalClassifierListener> getIncrementalClassifierListeners()\n");
        temp.append("\t *  ArrayList<BatchClustererListener> getBatchClustererListeners()\n");
        temp.append("\t *  ArrayList<GraphListenerListener> getGraphListeners()\n");
        temp.append("\t *  ArrayList<ChartListener> getChartListeners()\n");
        temp.append("\t *  ArrayList<ThresholdDataListener> getThresholdDataListeners()\n");
        temp.append("\t *  ArrayList<VisualizableErrorListener> getVisualizableErrorListeners()\n");
        temp.append("\t */\n");
        temp.append("\tGroovyHelper m_helper\n\n");
        temp.append("\t/** Don't delete!! */\n");
        temp.append("\tvoid setManager(GroovyHelper manager) { m_helper = manager }\n\n");
        temp.append("\t/** Alter or add to in order to tell the KnowlegeFlow\n");
        temp.append("\t *  environment whether a certain incoming connection type is allowed\n");
        temp.append("\t */\n");
        temp.append("\tboolean connectionAllowed(String eventName) {\n");
        temp.append("\t\tif (eventName.equals(\"trainingSet\")) { return false }\n");
        temp.append("\t\treturn false\n");
        temp.append("\t}\n\n");
        temp.append("\t/** Alter or add to in order to tell the KnowlegeFlow\n");
        temp.append("\t *  environment whether a certain incoming connection type is allowed\n");
        temp.append("\t */\n");
        temp.append("\tboolean connectionAllowed(EventSetDescriptor esd) {\n");
        temp.append("\t\treturn connectionAllowed(esd.getName())\n");
        temp.append("\t}\n\n");
        temp.append("\t/** Add (optional) code to do something when you have been\n");
        temp.append("\t *  registered as a listener with a source for the named event\n");
        temp.append("\t */\n");
        temp.append("\tvoid connectionNotification(String eventName, Object source) { }\n\n");
        temp.append("\t/** Add (optional) code to do something when you have been\n");
        temp.append("\t *  deregistered as a listener with a source for the named event\n");
        temp.append("\t */\n");
        temp.append("\tvoid disconnectionNotification(String eventName, Object source) { }\n\n");
        temp.append("\t/** Custom name of this component. Do something with it if you\n");
        temp.append("\t *  like. GroovyHelper already stores it and alters the icon text\n");
        temp.append("\t *  for you");
        temp.append("\t */\n");
        temp.append("\tvoid setCustomName(String name) { }\n\n");
        temp.append("\t/** Custom name of this component. No need to return anything\n");
        temp.append("\t *  GroovyHelper already stores it and alters the icon text\n");
        temp.append("\t *  for you");
        temp.append("\t */\n");
        temp.append("\tString getCustomName() { return null }\n\n");
        temp.append("\t/** Add code to return true when you are busy doing something\n");
        temp.append("\t */\n");
        temp.append("\tboolean isBusy() { return false }\n\n");
        temp.append("\t/** Store and use this logging object in order to post messages\n\t *  to the log\n");
        temp.append("\t */\n");
        temp.append("\tvoid setLog(Logger logger) { }\n\n");
        temp.append("\t/** Store and use this Environment object in order to lookup and\n\t *  use the values of environment variables\n");
        temp.append("\t */\n");
        temp.append("\tvoid setEnvironment(Environment env) { }\n\n");
        temp.append("\t/** Stop any processing (if possible)\n");
        temp.append("\t */\n");
        temp.append("\tvoid stop() { }\n\n");
        temp.append("\t/** Alter or add to in order to tell the KnowlegeFlow\n");
        temp.append("\t *  whether, at the current time, the named event could\n");
        temp.append("\t *  be generated.\n");
        temp.append("\t */\n");
        temp.append("\tboolean eventGeneratable(String eventName) {\n");
        temp.append("\t\tif (eventName.equals(\"trainingSet\")) { return false }\n");
        temp.append("\t\treturn false\n");
        temp.append("\t}\n\n");
        temp.append("\t/** Implement this to tell KnowledgeFlow about any methods\n");
        temp.append("\t *  that the user could invoke (i.e. to show a popup visualization\n");
        temp.append("\t *  or something).\n");
        temp.append("\t */\n");
        temp.append("\tEnumeration enumerateRequests() { return (new Vector(0)).elements()}\n\n");
        temp.append("\t/** Make the user-requested action happen here.\n");
        temp.append("\t */\n");
        temp.append("\tvoid performRequest(String requestName) { }\n\n");
        temp.append("\t//--------------- Incoming events ------------------\n");
        temp.append("\t//--------------- Implement as necessary -----------\n\n");
        temp.append("\tvoid acceptTrainingSet(TrainingSetEvent e) { }\n\n");
        temp.append("\tvoid acceptTestSet(TestSetEvent e) { }\n\n");
        temp.append("\tvoid acceptDataSet(DataSetEvent e) { }\n\n");
        temp.append("\tvoid acceptInstance(InstanceEvent e) { }\n\n");
        temp.append("\tvoid acceptText(TextEvent e) { }\n\n");
        temp.append("\tvoid acceptClassifier(BatchClassifierEvent e) { }\n\n");
        temp.append("\tvoid acceptClassifier(IncrementalClassifierEvent e) { }\n\n");
        temp.append("\tvoid acceptClusterer(BatchClustererEvent e) { }\n\n");
        temp.append("\tvoid acceptGraph(GraphEvent e) { }\n\n");
        temp.append("\tvoid acceptDataPoint(ChartEvent e) { }\n\n");
        temp.append("\tvoid acceptDataSet(ThresholdDataEvent e) { }\n\n");
        temp.append("\tvoid acceptDataSet(VisualizableErrorEvent e) { }\n\n");
        temp.append("}\n");
        this.m_newScript = temp.toString();
    }

    public void setModifiedListener(BeanCustomizer.ModifyListener l) {
        this.m_modifyListener = l;
    }
}

