/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.knowledgeflow.steps;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultStyledDocument;
import weka.core.Utils;
import weka.gui.knowledgeflow.StepEditorDialog;
import weka.gui.scripting.GroovyScript;
import weka.gui.visualize.VisualizeUtils;
import weka.knowledgeflow.steps.GroovyStep;

public class GroovyStepEditorDialog
extends StepEditorDialog {
    private static final long serialVersionUID = -5303157822778214991L;
    protected GroovyScript m_script;
    protected JTextPane m_textPane = new JTextPane();
    protected String m_newScript;
    protected JMenuBar m_menuBar;
    protected JFileChooser m_fileChooser = new JFileChooser();
    public static final String PROPERTIES_FILE = "weka/gui/scripting/Groovy.props";

    protected void initialize() throws Exception {
        Properties props = Utils.readProperties((String)PROPERTIES_FILE);
        boolean syntaxDocAvailable = true;
        try {
            Class.forName("weka.gui.scripting.SyntaxDocument");
        }
        catch (Exception ex) {
            syntaxDocAvailable = false;
        }
        if (props.getProperty("Syntax", "false").equals("true") && syntaxDocAvailable) {
            try {
                Class<?> syntaxClass = Class.forName("weka.gui.scripting.SyntaxDocument");
                Constructor<?> constructor = syntaxClass.getConstructor(Properties.class);
                Object doc = constructor.newInstance(props);
                this.m_textPane.setDocument((DefaultStyledDocument)doc);
                this.m_textPane.setBackground(VisualizeUtils.processColour((String)props.getProperty("BackgroundColor", "white"), (Color)Color.WHITE));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            this.m_textPane.setForeground(VisualizeUtils.processColour((String)props.getProperty("ForegroundColor", "black"), (Color)Color.BLACK));
            this.m_textPane.setBackground(VisualizeUtils.processColour((String)props.getProperty("BackgroundColor", "white"), (Color)Color.WHITE));
            this.m_textPane.setFont(new Font(props.getProperty("FontName", "monospaced"), 0, Integer.parseInt(props.getProperty("FontSize", "12"))));
        }
        this.m_script = new GroovyScript(this.m_textPane.getDocument());
        String script = ((GroovyStep)this.getStepToEdit()).getScript();
        if (script != null && script.length() > 0) {
            this.m_script.setContent(script);
        }
        Dimension d = new Dimension(600, 800);
        this.m_textPane.setMinimumSize(d);
        this.m_textPane.setPreferredSize(d);
    }

    protected void layoutEditor() {
        try {
            this.initialize();
        }
        catch (Exception ex) {
            this.showErrorDialog(ex);
        }
        JPanel mainHolder = new JPanel(new BorderLayout());
        this.m_fileChooser.setAcceptAllFileFilterUsed(true);
        this.m_fileChooser.setMultiSelectionEnabled(false);
        this.setupNewScript();
        mainHolder.add((Component)new JScrollPane(this.m_textPane), "Center");
        JButton newBut = new JButton("New script");
        JButton compileBut = new JButton("Compile script");
        this.m_buttonHolder.add(newBut);
        this.m_buttonHolder.add(compileBut);
        newBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroovyStepEditorDialog.this.newScript(GroovyStepEditorDialog.this.m_fileChooser);
            }
        });
        compileBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroovyStepEditorDialog.this.doCompile();
            }
        });
        this.m_menuBar = new JMenuBar();
        JMenu fileM = new JMenu();
        this.m_menuBar.add(fileM);
        fileM.setText("File");
        fileM.setMnemonic('F');
        JMenuItem newItem = new JMenuItem();
        fileM.add(newItem);
        newItem.setText("New");
        newItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        newItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroovyStepEditorDialog.this.newScript(GroovyStepEditorDialog.this.m_fileChooser);
            }
        });
        JMenuItem loadItem = new JMenuItem();
        fileM.add(loadItem);
        loadItem.setText("Open File...");
        loadItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        loadItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean ok;
                int retVal = GroovyStepEditorDialog.this.m_fileChooser.showOpenDialog((Component)((Object)GroovyStepEditorDialog.this));
                if (retVal == 0 && !(ok = GroovyStepEditorDialog.this.m_script.open(GroovyStepEditorDialog.this.m_fileChooser.getSelectedFile()))) {
                    JOptionPane.showMessageDialog((Component)((Object)GroovyStepEditorDialog.this), "Couldn't open file '" + GroovyStepEditorDialog.this.m_fileChooser.getSelectedFile() + "'!");
                }
            }
        });
        JMenuItem saveItem = new JMenuItem();
        fileM.add(saveItem);
        saveItem.setText("Save");
        saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        saveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GroovyStepEditorDialog.this.m_script.getFilename() != null) {
                    GroovyStepEditorDialog.this.save(null);
                } else {
                    GroovyStepEditorDialog.this.save(GroovyStepEditorDialog.this.m_fileChooser);
                }
            }
        });
        JMenuItem saveAsItem = new JMenuItem();
        fileM.add(saveAsItem);
        saveAsItem.setText("Save As...");
        saveAsItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        saveAsItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroovyStepEditorDialog.this.save(GroovyStepEditorDialog.this.m_fileChooser);
            }
        });
        JMenu scriptM = new JMenu();
        this.m_menuBar.add(scriptM);
        scriptM.setText("Script");
        scriptM.setMnemonic('S');
        JMenuItem compileItem = new JMenuItem();
        scriptM.add(compileItem);
        compileItem.setText("Compile");
        compileItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        compileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroovyStepEditorDialog.this.doCompile();
            }
        });
        this.add(mainHolder, "Center");
        if (this.m_parent instanceof JDialog) {
            ((JDialog)this.m_parent).setJMenuBar(this.m_menuBar);
            ((JDialog)this.m_parent).setTitle("Groovy Script Editor");
        }
    }

    private void newScript(JFileChooser fileChooser) {
        int retVal;
        if (this.m_script.isModified() && (retVal = JOptionPane.showConfirmDialog((Component)((Object)this), "Save changes" + (this.m_script.getFilename() != null ? " to " + this.m_script.getFilename() + "?" : " first?"))) == 0) {
            if (this.m_script.getFilename() != null) {
                this.save(null);
            } else {
                this.save(fileChooser);
            }
        }
        this.m_script.empty();
        this.m_script.setContent(this.m_newScript);
    }

    private void doCompile() {
        String script = this.m_script.getContent();
        if (script != null && script.length() > 0) {
            try {
                GroovyStep.compileScript(script);
                JOptionPane.showMessageDialog((Component)((Object)this), "Script compiled OK.", "Script Status", 1);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog((Component)((Object)this), "Problem compiling script:\n" + ex.getMessage(), "Script Status", 1);
            }
        }
    }

    private void save(JFileChooser fileChooser) {
        boolean ok = false;
        if (this.m_script.getFilename() == null || fileChooser != null) {
            int retVal = fileChooser.showSaveDialog((Component)((Object)this));
            if (retVal == 0) {
                ok = this.m_script.saveAs(fileChooser.getSelectedFile());
            }
        } else {
            ok = this.m_script.save();
        }
        if (!ok) {
            if (this.m_script.getFilename() != null) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Failed to save file '" + this.m_script.getFilename().toString() + "'!");
            } else {
                JOptionPane.showMessageDialog((Component)((Object)this), "Failed to save file!");
            }
        }
    }

    protected void okPressed() {
        ((GroovyStep)this.getStepToEdit()).setScript(this.m_script.getContent());
    }

    protected void cancelPressed() {
        int retVal;
        if (this.m_script.isModified() && (retVal = JOptionPane.showConfirmDialog((Component)((Object)this), "Save changes" + (this.m_script.getFilename() != null ? " to " + this.m_script.getFilename() + "?" : " first?"))) == 0) {
            if (this.m_script.getFilename() != null) {
                this.save(null);
            } else {
                this.save(this.m_fileChooser);
            }
        }
    }

    protected void setupNewScript() {
        StringBuilder temp = new StringBuilder();
        temp.append("import java.util.List\n");
        temp.append("import java.util.ArrayList\n");
        temp.append("import weka.core.*\n");
        temp.append("import weka.knowledgeflow.Data\n");
        temp.append("import weka.knowledgeflow.StepManager\n");
        temp.append("import weka.knowledgeflow.StepTask\n");
        temp.append("import weka.knowledgeflow.StepTaskCallback\n");
        temp.append("import weka.knowledgeflow.steps.Step\n");
        temp.append("import weka.knowledgeflow.steps.BaseStep\n\n");
        temp.append("// add further imports as necessary\n\n");
        temp.append("class MyScript extends BaseStep {\n\n");
        temp.append("\t/** Implement initialization stuff here */\n");
        temp.append("\tvoid stepInit() { }\n\n");
        temp.append("\t/** Main processing logic here for start points */\n");
        temp.append("\tvoid start() throws WekaException { }\n\n");
        temp.append("\t/** Main processing logic here for incoming connections */\n");
        temp.append("\tvoid processIncoming(Data data) throws WekaException { }\n\n");
        temp.append("\t/** Return a list of connection types that this step can\n\t *  accept. See constants defined in weka.knowledgeflow.StepManager\n\t * (or define your own connection types). */\n");
        temp.append("\tList<String> getIncomingConnectionTypes() { return null }\n\n");
        temp.append("\t/** Return a list of connection types that this step can\n\t *  produce as output. See constants defined in\n \t * weka.knowledgeflow.StepManager (or define your own connection\n\t * types). */\n");
        temp.append("\tList<String> getOutgoingConnectionTypes() { return null }\n\n");
        temp.append("}\n");
        this.m_newScript = temp.toString();
    }
}

