/*
 * Decompiled with CFR 0.152.
 */
package weka.knowledgeflow.steps;

import groovy.lang.GroovyClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import weka.core.WekaException;
import weka.gui.ProgrammaticProperty;
import weka.gui.knowledgeflow.StepInteractiveViewer;
import weka.knowledgeflow.Data;
import weka.knowledgeflow.steps.BaseStep;
import weka.knowledgeflow.steps.KFStep;
import weka.knowledgeflow.steps.Step;

@KFStep(name="GroovyStep", category="Scripting", toolTipText="Implement a Knowledge Flow step using Groovy", iconPath="weka/gui/knowledgeflow/icons/GroovyStep.gif")
public class GroovyStep
extends BaseStep {
    private static final long serialVersionUID = -8984243132321480487L;
    protected transient Step m_groovyObject;
    protected String m_groovyScript = "";

    @ProgrammaticProperty
    public void setScript(String script) {
        this.m_groovyScript = script;
        this.m_groovyObject = null;
    }

    public String getScript() {
        return this.m_groovyScript;
    }

    public Step getWrappedGroovyStep() {
        return this.m_groovyObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stepInit() throws WekaException {
        if (this.m_groovyScript.length() <= 0) throw new WekaException("No Groovy script to execute!");
        try {
            if (this.m_groovyObject == null) {
                this.m_groovyObject = GroovyStep.compileScript(this.m_groovyScript);
            }
        }
        catch (Exception ex) {
            throw new WekaException((Throwable)ex);
        }
        this.m_groovyObject.setStepManager(this.getStepManager());
        this.m_groovyObject.stepInit();
    }

    public List<String> getIncomingConnectionTypes() {
        if (this.m_groovyScript.length() > 0) {
            if (this.m_groovyObject == null) {
                try {
                    this.m_groovyObject = GroovyStep.compileScript(this.m_groovyScript);
                }
                catch (Exception ex) {
                    return new ArrayList<String>();
                }
            }
            this.m_groovyObject.setStepManager(this.getStepManager());
            return this.m_groovyObject.getIncomingConnectionTypes();
        }
        return new ArrayList<String>();
    }

    public List<String> getOutgoingConnectionTypes() {
        if (this.m_groovyScript.length() > 0) {
            if (this.m_groovyObject == null) {
                try {
                    this.m_groovyObject = GroovyStep.compileScript(this.m_groovyScript);
                }
                catch (Exception ex) {
                    return new ArrayList<String>();
                }
            }
            this.m_groovyObject.setStepManager(this.getStepManager());
            return this.m_groovyObject.getOutgoingConnectionTypes();
        }
        return new ArrayList<String>();
    }

    public void processIncoming(Data data) throws WekaException {
        this.m_groovyObject.processIncoming(data);
    }

    public String getCustomEditorForStep() {
        return "weka.gui.knowledgeflow.steps.GroovyStepEditorDialog";
    }

    public Map<String, StepInteractiveViewer> getInteractiveViewersImpls() {
        if (this.m_groovyScript.length() > 0) {
            if (this.m_groovyObject == null) {
                try {
                    this.m_groovyObject = GroovyStep.compileScript(this.m_groovyScript);
                }
                catch (Exception ex) {
                    return null;
                }
            }
            return this.m_groovyObject.getInteractiveViewersImpls();
        }
        return null;
    }

    public static Step compileScript(String script) throws Exception {
        GroovyClassLoader gcl = new GroovyClassLoader();
        Class scriptClass = gcl.parseClass(script);
        return (Step)scriptClass.newInstance();
    }
}

