/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Optimization;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;
import weka.filters.unsupervised.attribute.Standardize;

public class MIDD
extends AbstractClassifier
implements OptionHandler,
MultiInstanceCapabilitiesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = 4263507733600536168L;
    protected int m_ClassIndex;
    protected double[] m_Par;
    protected int m_NumClasses;
    protected int[] m_Classes;
    protected double[][][] m_Data;
    protected Instances m_Attributes;
    protected Filter m_Filter = null;
    protected int m_filterType = 1;
    public static final int FILTER_NORMALIZE = 0;
    public static final int FILTER_STANDARDIZE = 1;
    public static final int FILTER_NONE = 2;
    public static final Tag[] TAGS_FILTER = new Tag[]{new Tag(0, "Normalize training data"), new Tag(1, "Standardize training data"), new Tag(2, "No normalization/standardization")};
    protected ReplaceMissingValues m_Missing = new ReplaceMissingValues();

    public String globalInfo() {
        return "Re-implement the Diverse Density algorithm, changes the testing procedure.\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.PHDTHESIS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Oded Maron");
        result.setValue(TechnicalInformation.Field.YEAR, "1998");
        result.setValue(TechnicalInformation.Field.TITLE, "Learning from ambiguity");
        result.setValue(TechnicalInformation.Field.SCHOOL, "Massachusetts Institute of Technology");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.ARTICLE);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "O. Maron and T. Lozano-Perez");
        additional.setValue(TechnicalInformation.Field.YEAR, "1998");
        additional.setValue(TechnicalInformation.Field.TITLE, "A Framework for Multiple Instance Learning");
        additional.setValue(TechnicalInformation.Field.JOURNAL, "Neural Information Processing Systems");
        additional.setValue(TechnicalInformation.Field.VOLUME, "10");
        return result;
    }

    public Enumeration<Option> listOptions() {
        Vector<Object> result = new Vector<Object>(2);
        result.addElement(new Option("\tWhether to 0=normalize/1=standardize/2=neither.\n\t(default 1=standardize)", "N", 1, "-N <num>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String nString = Utils.getOption((char)'N', (String[])options);
        if (nString.length() != 0) {
            this.setFilterType(new SelectedTag(Integer.parseInt(nString), TAGS_FILTER));
        } else {
            this.setFilterType(new SelectedTag(1, TAGS_FILTER));
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-N");
        result.add("" + this.m_filterType);
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public String filterTypeTipText() {
        return "The filter type for transforming the training data.";
    }

    public SelectedTag getFilterType() {
        return new SelectedTag(this.m_filterType, TAGS_FILTER);
    }

    public void setFilterType(SelectedTag newType) {
        if (newType.getTags() == TAGS_FILTER) {
            this.m_filterType = newType.getSelectedTag().getID();
        }
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.BINARY_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.ONLY_MULTIINSTANCE);
        return result;
    }

    public Capabilities getMultiInstanceCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.disableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public void buildClassifier(Instances train) throws Exception {
        int i;
        this.getCapabilities().testWithFail(train);
        train = new Instances(train);
        train.deleteWithMissingClass();
        this.m_ClassIndex = train.classIndex();
        this.m_NumClasses = train.numClasses();
        int nR = train.attribute(1).relation().numAttributes();
        int nC = train.numInstances();
        ArrayList<Integer> maxSzIdx = new ArrayList<Integer>();
        int maxSz = 0;
        int[] bagSize = new int[nC];
        Instances datasets = new Instances(train.attribute(1).relation(), 0);
        this.m_Data = new double[nC][nR][];
        this.m_Classes = new int[nC];
        this.m_Attributes = datasets.stringFreeStructure();
        if (this.m_Debug) {
            System.out.println("Extracting data...");
        }
        for (int h = 0; h < nC; ++h) {
            int nI;
            Instance current = train.instance(h);
            this.m_Classes[h] = (int)current.classValue();
            Instances currInsts = current.relationalValue(1);
            for (i = 0; i < currInsts.numInstances(); ++i) {
                Instance inst = currInsts.instance(i);
                datasets.add(inst);
            }
            bagSize[h] = nI = currInsts.numInstances();
            if (this.m_Classes[h] != 1) continue;
            if (nI > maxSz) {
                maxSz = nI;
                maxSzIdx = new ArrayList(1);
                maxSzIdx.add(new Integer(h));
                continue;
            }
            if (nI != maxSz) continue;
            maxSzIdx.add(new Integer(h));
        }
        this.m_Filter = this.m_filterType == 1 ? new Standardize() : (this.m_filterType == 0 ? new Normalize() : null);
        if (this.m_Filter != null) {
            this.m_Filter.setInputFormat(datasets);
            datasets = Filter.useFilter((Instances)datasets, (Filter)this.m_Filter);
        }
        this.m_Missing.setInputFormat(datasets);
        datasets = Filter.useFilter((Instances)datasets, (Filter)this.m_Missing);
        int instIndex = 0;
        int start = 0;
        for (int h = 0; h < nC; ++h) {
            for (i = 0; i < datasets.numAttributes(); ++i) {
                this.m_Data[h][i] = new double[bagSize[h]];
                instIndex = start;
                for (int k = 0; k < bagSize[h]; ++k) {
                    this.m_Data[h][i][k] = datasets.instance(instIndex).value(i);
                    ++instIndex;
                }
            }
            start = instIndex;
        }
        if (this.m_Debug) {
            System.out.println("\nIteration History...");
        }
        double[] x = new double[nR * 2];
        double[] tmp = new double[x.length];
        double[][] b = new double[2][x.length];
        double bestnll = Double.MAX_VALUE;
        for (int t = 0; t < x.length; ++t) {
            b[0][t] = Double.NaN;
            b[1][t] = Double.NaN;
        }
        for (int s = 0; s < maxSzIdx.size(); ++s) {
            int exIdx = (Integer)maxSzIdx.get(s);
            for (int p = 0; p < this.m_Data[exIdx][0].length; ++p) {
                for (int q = 0; q < nR; ++q) {
                    x[2 * q] = this.m_Data[exIdx][q][p];
                    x[2 * q + 1] = 1.0;
                }
                OptEng opt = new OptEng();
                tmp = opt.findArgmin(x, b);
                while (tmp == null) {
                    tmp = opt.getVarbValues();
                    if (this.m_Debug) {
                        System.out.println("200 iterations finished, not enough!");
                    }
                    tmp = opt.findArgmin(tmp, b);
                }
                double nll = opt.getMinFunction();
                if (nll < bestnll) {
                    bestnll = nll;
                    this.m_Par = tmp;
                    tmp = new double[x.length];
                    if (this.m_Debug) {
                        System.out.println("!!!!!!!!!!!!!!!!Smaller NLL found: " + nll);
                    }
                }
                if (!this.m_Debug) continue;
                System.out.println(exIdx + ":  -------------<Converged>--------------");
            }
        }
    }

    public double[] distributionForInstance(Instance exmp) throws Exception {
        Instances ins = exmp.relationalValue(1);
        if (this.m_Filter != null) {
            ins = Filter.useFilter((Instances)ins, (Filter)this.m_Filter);
        }
        ins = Filter.useFilter((Instances)ins, (Filter)this.m_Missing);
        int nI = ins.numInstances();
        int nA = ins.numAttributes();
        double[][] dat = new double[nI][nA];
        for (int j = 0; j < nI; ++j) {
            for (int k = 0; k < nA; ++k) {
                dat[j][k] = ins.instance(j).value(k);
            }
        }
        double[] distribution = new double[2];
        distribution[0] = 0.0;
        for (int i = 0; i < nI; ++i) {
            double exp = 0.0;
            for (int r = 0; r < nA; ++r) {
                exp += (this.m_Par[r * 2] - dat[i][r]) * (this.m_Par[r * 2] - dat[i][r]) * this.m_Par[r * 2 + 1] * this.m_Par[r * 2 + 1];
            }
            exp = Math.exp(-exp);
            distribution[0] = distribution[0] + Math.log(1.0 - exp);
        }
        distribution[0] = Math.exp(distribution[0]);
        distribution[1] = 1.0 - distribution[0];
        return distribution;
    }

    public String toString() {
        String result = "Diverse Density";
        if (this.m_Par == null) {
            return result + ": No model built yet.";
        }
        result = result + "\nCoefficients...\nVariable       Point       Scale\n";
        int j = 0;
        int idx = 0;
        while (j < this.m_Par.length / 2) {
            result = result + this.m_Attributes.attribute(idx).name();
            result = result + " " + Utils.doubleToString((double)this.m_Par[j * 2], (int)12, (int)4);
            result = result + " " + Utils.doubleToString((double)this.m_Par[j * 2 + 1], (int)12, (int)4) + "\n";
            ++j;
            ++idx;
        }
        return result;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 10369 $");
    }

    public static void main(String[] argv) {
        MIDD.runClassifier((Classifier)new MIDD(), (String[])argv);
    }

    private class OptEng
    extends Optimization {
        private OptEng() {
        }

        protected double objectiveFunction(double[] x) {
            double nll = 0.0;
            for (int i = 0; i < MIDD.this.m_Classes.length; ++i) {
                int nI = MIDD.this.m_Data[i][0].length;
                double bag = 0.0;
                for (int j = 0; j < nI; ++j) {
                    double ins = 0.0;
                    for (int k = 0; k < MIDD.this.m_Data[i].length; ++k) {
                        ins += (MIDD.this.m_Data[i][k][j] - x[k * 2]) * (MIDD.this.m_Data[i][k][j] - x[k * 2]) * x[k * 2 + 1] * x[k * 2 + 1];
                    }
                    ins = Math.exp(-ins);
                    ins = 1.0 - ins;
                    if (MIDD.this.m_Classes[i] == 1) {
                        bag += Math.log(ins);
                        continue;
                    }
                    if (ins <= m_Zero) {
                        ins = m_Zero;
                    }
                    nll -= Math.log(ins);
                }
                if (MIDD.this.m_Classes[i] != 1) continue;
                if ((bag = 1.0 - Math.exp(bag)) <= m_Zero) {
                    bag = m_Zero;
                }
                nll -= Math.log(bag);
            }
            return nll;
        }

        protected double[] evaluateGradient(double[] x) {
            double[] grad = new double[x.length];
            for (int i = 0; i < MIDD.this.m_Classes.length; ++i) {
                int nI = MIDD.this.m_Data[i][0].length;
                double denom = 0.0;
                double[] numrt = new double[x.length];
                for (int j = 0; j < nI; ++j) {
                    double exp = 0.0;
                    for (int k = 0; k < MIDD.this.m_Data[i].length; ++k) {
                        exp += (MIDD.this.m_Data[i][k][j] - x[k * 2]) * (MIDD.this.m_Data[i][k][j] - x[k * 2]) * x[k * 2 + 1] * x[k * 2 + 1];
                    }
                    exp = Math.exp(-exp);
                    exp = 1.0 - exp;
                    if (MIDD.this.m_Classes[i] == 1) {
                        denom += Math.log(exp);
                    }
                    if (exp <= m_Zero) {
                        exp = m_Zero;
                    }
                    for (int p = 0; p < MIDD.this.m_Data[i].length; ++p) {
                        int n = 2 * p;
                        numrt[n] = numrt[n] + (1.0 - exp) * 2.0 * (x[2 * p] - MIDD.this.m_Data[i][p][j]) * x[p * 2 + 1] * x[p * 2 + 1] / exp;
                        int n2 = 2 * p + 1;
                        numrt[n2] = numrt[n2] + 2.0 * (1.0 - exp) * (x[2 * p] - MIDD.this.m_Data[i][p][j]) * (x[2 * p] - MIDD.this.m_Data[i][p][j]) * x[p * 2 + 1] / exp;
                    }
                }
                if ((denom = 1.0 - Math.exp(denom)) <= m_Zero) {
                    denom = m_Zero;
                }
                for (int q = 0; q < MIDD.this.m_Data[i].length; ++q) {
                    if (MIDD.this.m_Classes[i] == 1) {
                        int n = 2 * q;
                        grad[n] = grad[n] + numrt[2 * q] * (1.0 - denom) / denom;
                        int n3 = 2 * q + 1;
                        grad[n3] = grad[n3] + numrt[2 * q + 1] * (1.0 - denom) / denom;
                        continue;
                    }
                    int n = 2 * q;
                    grad[n] = grad[n] - numrt[2 * q];
                    int n4 = 2 * q + 1;
                    grad[n4] = grad[n4] - numrt[2 * q + 1];
                }
            }
            return grad;
        }

        public String getRevision() {
            return RevisionUtils.extract((String)"$Revision: 10369 $");
        }
    }
}

