/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.mi.MITI;
import weka.classifiers.mi.miti.Bag;
import weka.core.AdditionalMeasureProducer;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;

public class MIRI
extends MITI
implements OptionHandler,
AdditionalMeasureProducer {
    static final long serialVersionUID = -218835168397644255L;
    private ArrayList<MITI.MultiInstanceDecisionTree> rules;

    @Override
    public String globalInfo() {
        return "MIRI (Multi Instance Rule Inducer): multi-instance classifier that utilizes partial MITI trees witha single positive leaf to learn and represent rules. For more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    public Enumeration enumerateMeasures() {
        Vector<String> newVector = new Vector<String>(3);
        newVector.addElement("measureNumRules");
        newVector.addElement("measureNumPositiveRules");
        newVector.addElement("measureNumConditionsInPositiveRules");
        return newVector.elements();
    }

    @Override
    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.equalsIgnoreCase("measureNumRules")) {
            return (double)this.rules.size() + 1.0;
        }
        if (additionalMeasureName.equalsIgnoreCase("measureNumPositiveRules")) {
            int total = 0;
            for (MITI.MultiInstanceDecisionTree rule : this.rules) {
                total += rule.numPosRulesAndNumPosConditions()[0];
            }
            return total;
        }
        if (additionalMeasureName.equalsIgnoreCase("measureNumConditionsInPositiveRules")) {
            int total = 0;
            for (MITI.MultiInstanceDecisionTree rule : this.rules) {
                total += rule.numPosRulesAndNumPosConditions()[1];
            }
            return total;
        }
        throw new IllegalArgumentException(additionalMeasureName + " not supported (MultiInstanceTreeRuleLearner)");
    }

    @Override
    public void buildClassifier(Instances trainingData) throws Exception {
        this.getCapabilities().testWithFail(trainingData);
        this.rules = new ArrayList();
        HashMap<Instance, Bag> instanceBags = new HashMap<Instance, Bag>();
        ArrayList<Instance> all = new ArrayList<Instance>();
        double totalInstances = 0.0;
        double totalBags = 0.0;
        for (Instance i : trainingData) {
            Bag bag = new Bag(i);
            for (Instance bagged : bag.instances()) {
                instanceBags.put(bagged, bag);
                all.add(bagged);
            }
            totalBags += 1.0;
            totalInstances += (double)trainingData.numInstances();
        }
        double b_multiplier = totalInstances / totalBags;
        if (this.m_scaleK) {
            for (Bag bag : instanceBags.values()) {
                bag.setBagWeightMultiplier(b_multiplier);
            }
        }
        while (all.size() > 0) {
            MITI.MultiInstanceDecisionTree tree = new MITI.MultiInstanceDecisionTree(this, instanceBags, all, true);
            if (this.m_Debug) {
                System.out.println(tree.render());
            }
            if (!tree.trimNegativeBranches()) break;
            if (this.m_Debug) {
                System.out.println(tree.render());
            }
            this.rules.add(tree);
            boolean atLeast1Positive = false;
            ArrayList<Instance> stillEnabled = new ArrayList<Instance>();
            for (Instance i : all) {
                Bag bag = instanceBags.get(i);
                if (!bag.isEnabled()) continue;
                stillEnabled.add(i);
                if (!bag.isPositive()) continue;
                atLeast1Positive = true;
            }
            all = stillEnabled;
            if (atLeast1Positive) continue;
            break;
        }
    }

    @Override
    public double[] distributionForInstance(Instance newBag) throws Exception {
        double[] distribution = new double[2];
        Instances contents = newBag.relationalValue(1);
        boolean positive = false;
        block0: for (Instance i : contents) {
            for (MITI.MultiInstanceDecisionTree tree : this.rules) {
                if (!tree.isPositive(i)) continue;
                positive = true;
                continue block0;
            }
        }
        distribution[1] = positive ? 1.0 : 0.0;
        distribution[0] = 1.0 - distribution[1];
        return distribution;
    }

    @Override
    public String toString() {
        if (this.rules != null) {
            String s = this.rules.size() + " rules\n";
            for (MITI.MultiInstanceDecisionTree tree : this.rules) {
                s = s + tree.render() + "\n";
            }
            s = s + "\nNumber of positive rules: " + this.getMeasure("measureNumPositiveRules") + "\n";
            s = s + "Number of conditions in positive rules: " + this.getMeasure("measureNumConditionsInPositiveRules") + "\n";
            return s;
        }
        return "No model built yet!";
    }

    public static void main(String[] options) {
        MIRI.runClassifier((Classifier)new MIRI(), (String[])options);
    }
}

