/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.RandomizableClassifier;
import weka.classifiers.mi.miti.AlgorithmConfiguration;
import weka.classifiers.mi.miti.Bag;
import weka.classifiers.mi.miti.NextSplitHeuristic;
import weka.classifiers.mi.miti.TreeNode;
import weka.core.AdditionalMeasureProducer;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class MITI
extends RandomizableClassifier
implements OptionHandler,
AdditionalMeasureProducer,
TechnicalInformationHandler,
MultiInstanceCapabilitiesHandler {
    static final long serialVersionUID = -217735168397644244L;
    protected MultiInstanceDecisionTree tree;
    public static final int SPLITMETHOD_GINI = 1;
    public static final int SPLITMETHOD_MAXBEPP = 2;
    public static final int SPLITMETHOD_SSBEPP = 3;
    public static final Tag[] TAGS_SPLITMETHOD = new Tag[]{new Tag(1, "Gini: E * (1 - E)"), new Tag(2, "MaxBEPP: E"), new Tag(3, "Sum Squared BEPP: E * E")};
    protected int m_SplitMethod = 2;
    protected boolean m_scaleK = false;
    protected boolean m_useBagCount = false;
    protected boolean m_unbiasedEstimate = false;
    protected int m_kBEPPConstant = 5;
    protected int m_AttributesToSplit = -1;
    protected int m_AttributeSplitChoices = 1;
    protected double m_bagInstanceMultiplier = 0.5;

    public String globalInfo() {
        return "MITI (Multi Instance Tree Inducer): multi-instance classification  based a decision tree learned using Blockeel et al.'s algorithm. For more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Hendrik Blockeel and David Page and Ashwin Srinivasan");
        result.setValue(TechnicalInformation.Field.TITLE, "Multi-instance Tree Learning");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Proceedings of the International Conference on Machine Learning");
        result.setValue(TechnicalInformation.Field.YEAR, "2005");
        result.setValue(TechnicalInformation.Field.PAGES, "57-64");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "ACM");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.INPROCEEDINGS);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Luke Bjerring and Eibe Frank");
        additional.setValue(TechnicalInformation.Field.TITLE, "Beyond Trees: Adopting MITI to Learn Rules and Ensemble Classifiers for Multi-instance Data");
        additional.setValue(TechnicalInformation.Field.BOOKTITLE, "Proceedings of the Australasian Joint Conference on Artificial Intelligence");
        additional.setValue(TechnicalInformation.Field.YEAR, "2011");
        additional.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        return result;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.disable(Capabilities.Capability.MISSING_VALUES);
        result.disableAllClasses();
        result.disableAllClassDependencies();
        result.enable(Capabilities.Capability.BINARY_CLASS);
        result.enable(Capabilities.Capability.ONLY_MULTIINSTANCE);
        return result;
    }

    public Capabilities getMultiInstanceCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public void buildClassifier(Instances trainingData) throws Exception {
        this.getCapabilities().testWithFail(trainingData);
        this.tree = new MultiInstanceDecisionTree(trainingData);
    }

    public Enumeration<String> enumerateMeasures() {
        Vector<String> newVector = new Vector<String>(3);
        newVector.addElement("measureNumRules");
        newVector.addElement("measureNumPositiveRules");
        newVector.addElement("measureNumConditionsInPositiveRules");
        return newVector.elements();
    }

    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.equalsIgnoreCase("measureNumRules")) {
            return this.tree.getNumLeaves();
        }
        if (additionalMeasureName.equalsIgnoreCase("measureNumPositiveRules")) {
            return this.tree.numPosRulesAndNumPosConditions()[0];
        }
        if (additionalMeasureName.equalsIgnoreCase("measureNumConditionsInPositiveRules")) {
            return this.tree.numPosRulesAndNumPosConditions()[1];
        }
        throw new IllegalArgumentException(additionalMeasureName + " not supported (MultiInstanceRuleLearner)");
    }

    public double[] distributionForInstance(Instance newBag) throws Exception {
        double[] distribution = new double[2];
        Instances contents = newBag.relationalValue(1);
        boolean positive = false;
        for (Instance i : contents) {
            if (!this.tree.isPositive(i)) continue;
            positive = true;
            break;
        }
        distribution[1] = positive ? 1.0 : 0.0;
        distribution[0] = 1.0 - distribution[1];
        return distribution;
    }

    protected AlgorithmConfiguration getSettings() {
        return new AlgorithmConfiguration(this.m_SplitMethod, this.m_unbiasedEstimate, this.m_kBEPPConstant, this.m_useBagCount, this.m_bagInstanceMultiplier, this.m_AttributesToSplit, this.m_AttributeSplitChoices);
    }

    public Enumeration<Option> listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tThe method used to determine best split:\n\t1. Gini; 2. MaxBEPP; 3. SSBEPP", "M", 1, "-M [1|2|3]"));
        result.addElement(new Option("\tThe constant used in the tozero() hueristic", "K", 1, "-K [kBEPPConstant]"));
        result.addElement(new Option("\tScales the value of K to the size of the bags", "L", 0, "-L"));
        result.addElement(new Option("\tUse unbiased estimate rather than BEPP, i.e. UEPP.", "U", 0, "-U"));
        result.addElement(new Option("\tUses the instances present for the bag counts at each node when splitting,\n\tweighted according to 1 - Ba ^ n, where n is the number of instances\n\tpresent which belong to the bag, and Ba is another parameter (default 0.5)", "B", 0, "-B"));
        result.addElement(new Option("\tMultiplier for count influence of a bag based on the number of its instances", "Ba", 1, "-Ba [multiplier]"));
        result.addElement(new Option("\tThe number of randomly selected attributes to split\n\t-1: All attributes\n\t-2: square root of the total number of attributes", "A", 1, "-A [number of attributes]"));
        result.addElement(new Option("\tThe number of top scoring attribute splits to randomly pick from\n\t-1: All splits (completely random selection)\n\t-2: square root of the number of splits", "An", 1, "-An [number of splits]"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String methodString = Utils.getOption((char)'M', (String[])options);
        if (methodString.length() != 0) {
            this.setSplitMethod(new SelectedTag(Integer.parseInt(methodString), TAGS_SPLITMETHOD));
        } else {
            this.setSplitMethod(new SelectedTag(2, TAGS_SPLITMETHOD));
        }
        methodString = Utils.getOption((char)'K', (String[])options);
        if (methodString.length() != 0) {
            this.setK(Integer.parseInt(methodString));
        } else {
            this.setK(5);
        }
        this.setL(Utils.getFlag((char)'L', (String[])options));
        this.setUnbiasedEstimate(Utils.getFlag((char)'U', (String[])options));
        methodString = Utils.getOption((char)'A', (String[])options);
        if (methodString.length() != 0) {
            this.setAttributesToSplit(Integer.parseInt(methodString));
        } else {
            this.setAttributesToSplit(-1);
        }
        methodString = Utils.getOption((String)"An", (String[])options);
        if (methodString.length() != 0) {
            this.setTopNAttributesToSplit(Integer.parseInt(methodString));
        } else {
            this.setTopNAttributesToSplit(1);
        }
        this.setB(Utils.getFlag((char)'B', (String[])options));
        methodString = Utils.getOption((String)"Ba", (String[])options);
        if (methodString.length() != 0) {
            this.setBa(Double.parseDouble(methodString));
        } else {
            this.setBa(0.5);
        }
        super.setOptions(options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-K");
        result.add("" + this.m_kBEPPConstant);
        if (this.getL()) {
            result.add("-L");
        }
        if (this.getUnbiasedEstimate()) {
            result.add("-U");
        }
        if (this.getB()) {
            result.add("-B");
        }
        result.add("-Ba");
        result.add("" + this.m_bagInstanceMultiplier);
        result.add("-M");
        result.add("" + this.m_SplitMethod);
        result.add("-A");
        result.add("" + this.m_AttributesToSplit);
        result.add("-An");
        result.add("" + this.m_AttributeSplitChoices);
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public String kTipText() {
        return "The value used in the tozero() method.";
    }

    public int getK() {
        return this.m_kBEPPConstant;
    }

    public void setK(int newValue) {
        this.m_kBEPPConstant = newValue;
    }

    public String lTipText() {
        return "Whether to scale based on the number of instances.";
    }

    public boolean getL() {
        return this.m_scaleK;
    }

    public void setL(boolean newValue) {
        this.m_scaleK = newValue;
    }

    public String unbiasedEstimateTipText() {
        return "Whether to used unbiased estimate (EPP instead of BEPP).";
    }

    public boolean getUnbiasedEstimate() {
        return this.m_unbiasedEstimate;
    }

    public void setUnbiasedEstimate(boolean newValue) {
        this.m_unbiasedEstimate = newValue;
    }

    public String bTipText() {
        return "Whether to use bag-based statistics for estimates of proportion.";
    }

    public boolean getB() {
        return this.m_useBagCount;
    }

    public void setB(boolean newValue) {
        this.m_useBagCount = newValue;
    }

    public String baTipText() {
        return "Multiplier for count influence of a bag based on the number of its instances.";
    }

    public double getBa() {
        return this.m_bagInstanceMultiplier;
    }

    public void setBa(double newValue) {
        this.m_bagInstanceMultiplier = newValue;
    }

    public String attributesToSplitTipText() {
        return "The number of randomly chosen attributes to consider for splitting.";
    }

    public int getAttributesToSplit() {
        return this.m_AttributesToSplit;
    }

    public void setAttributesToSplit(int newValue) {
        this.m_AttributesToSplit = newValue;
    }

    public String topNAttributesToSplitTipText() {
        return "Value of N to use for top-N attributes to choose randomly from.";
    }

    public int getTopNAttributesToSplit() {
        return this.m_AttributeSplitChoices;
    }

    public void setTopNAttributesToSplit(int newValue) {
        this.m_AttributeSplitChoices = newValue;
    }

    public String splitMethodTipText() {
        return "The method used to determine best split: 1. Gini; 2. MaxBEPP; 3. SSBEPP";
    }

    public void setSplitMethod(SelectedTag newMethod) {
        if (newMethod.getTags() == TAGS_SPLITMETHOD) {
            this.m_SplitMethod = newMethod.getSelectedTag().getID();
        }
    }

    public SelectedTag getSplitMethod() {
        return new SelectedTag(this.m_SplitMethod, TAGS_SPLITMETHOD);
    }

    public String toString() {
        if (this.tree != null) {
            String s = this.tree.render();
            s = s + "\n\nNumber of positive rules: " + this.getMeasure("measureNumPositiveRules") + "\n";
            s = s + "Number of conditions in positive rules: " + this.getMeasure("measureNumConditionsInPositiveRules") + "\n";
            return s;
        }
        return "No model built yet!";
    }

    public static void main(String[] options) {
        MITI.runClassifier((Classifier)new MITI(), (String[])options);
    }

    protected class MultiInstanceDecisionTree
    implements Serializable {
        private static final long serialVersionUID = 4037700809781784985L;
        private TreeNode root;
        private final HashMap<Instance, Bag> m_instanceBags;
        private int numLeaves = 0;

        public int getNumLeaves() {
            return this.numLeaves;
        }

        protected MultiInstanceDecisionTree(Instances instances) {
            this.m_instanceBags = new HashMap();
            ArrayList<Instance> all = new ArrayList<Instance>();
            double totalInstances = 0.0;
            double totalBags = 0.0;
            for (Instance i : instances) {
                Bag bag = new Bag(i);
                for (Instance bagged : bag.instances()) {
                    this.m_instanceBags.put(bagged, bag);
                    all.add(bagged);
                }
                totalBags += 1.0;
                totalInstances += (double)bag.instances().numInstances();
            }
            double b_multiplier = totalInstances / totalBags;
            if (MITI.this.m_scaleK) {
                for (Bag bag : this.m_instanceBags.values()) {
                    bag.setBagWeightMultiplier(b_multiplier);
                }
            }
            this.makeTree(this.m_instanceBags, all, false);
        }

        public MultiInstanceDecisionTree(HashMap<Instance, Bag> instanceBags, ArrayList<Instance> all, boolean stopOnFirstPositiveLeaf) {
            this.m_instanceBags = instanceBags;
            this.makeTree(instanceBags, all, stopOnFirstPositiveLeaf);
        }

        private void makeTree(HashMap<Instance, Bag> instanceBags, ArrayList<Instance> all, boolean stopOnFirstPositiveLeaf) {
            Random r = new Random(MITI.this.getSeed());
            AlgorithmConfiguration settings = MITI.this.getSettings();
            ArrayList<TreeNode> toSplit = new ArrayList<TreeNode>();
            this.root = new TreeNode(null, all);
            toSplit.add(this.root);
            this.numLeaves = 0;
            while (toSplit.size() > 0) {
                int nextIndex = Math.min(1, toSplit.size());
                TreeNode next = (TreeNode)toSplit.remove(nextIndex = r.nextInt(nextIndex));
                if (next == null) continue;
                if (next.isPurePositive(instanceBags)) {
                    next.makeLeafNode(true);
                    ArrayList<String> deactivated = new ArrayList<String>();
                    next.deactivateRelatedInstances(instanceBags, deactivated);
                    if (MITI.this.m_Debug && deactivated.size() > 0) {
                        Bag.printDeactivatedInstances(deactivated);
                    }
                    for (TreeNode n : toSplit) {
                        n.removeDeactivatedInstances(instanceBags);
                        n.calculateNodeScore(instanceBags, MITI.this.m_unbiasedEstimate, MITI.this.m_kBEPPConstant, MITI.this.m_useBagCount, MITI.this.m_bagInstanceMultiplier);
                    }
                    if (stopOnFirstPositiveLeaf && deactivated.size() > 0) {
                        return;
                    }
                } else if (next.isPureNegative(instanceBags)) {
                    next.makeLeafNode(false);
                } else {
                    next.splitInstances(instanceBags, settings, r, MITI.this.m_Debug);
                    if (!next.isLeafNode()) {
                        if (next.split.isNominal) {
                            TreeNode[] nominals;
                            for (TreeNode nominal : nominals = next.nominals()) {
                                nominal.calculateNodeScore(instanceBags, MITI.this.m_unbiasedEstimate, MITI.this.m_kBEPPConstant, MITI.this.m_useBagCount, MITI.this.m_bagInstanceMultiplier);
                                toSplit.add(nominal);
                            }
                        } else {
                            next.left().calculateNodeScore(instanceBags, MITI.this.m_unbiasedEstimate, MITI.this.m_kBEPPConstant, MITI.this.m_useBagCount, MITI.this.m_bagInstanceMultiplier);
                            toSplit.add(next.left());
                            next.right().calculateNodeScore(instanceBags, MITI.this.m_unbiasedEstimate, MITI.this.m_kBEPPConstant, MITI.this.m_useBagCount, MITI.this.m_bagInstanceMultiplier);
                            toSplit.add(next.right());
                        }
                    } else if (next.isPositiveLeaf()) {
                        for (TreeNode n : toSplit) {
                            n.removeDeactivatedInstances(instanceBags);
                            n.calculateNodeScore(instanceBags, MITI.this.m_unbiasedEstimate, MITI.this.m_kBEPPConstant, MITI.this.m_useBagCount, MITI.this.m_bagInstanceMultiplier);
                        }
                        if (stopOnFirstPositiveLeaf) {
                            return;
                        }
                    }
                }
                if (next.isLeafNode()) {
                    ++this.numLeaves;
                }
                Comparator<TreeNode> sh = Collections.reverseOrder(new NextSplitHeuristic());
                Collections.sort(toSplit, sh);
            }
            if (MITI.this.m_Debug) {
                System.out.println(this.root.render(1, instanceBags));
            }
        }

        protected boolean isPositive(Instance i) {
            TreeNode leaf = this.traverseTree(i);
            return leaf != null && leaf.isPositiveLeaf();
        }

        private TreeNode traverseTree(Instance i) {
            TreeNode next = this.root;
            while (next != null && !next.isLeafNode()) {
                Attribute a = next.split.attribute;
                if (a.isNominal()) {
                    next = next.nominals()[(int)i.value(a)];
                    continue;
                }
                if (i.value(a) < next.split.splitPoint) {
                    next = next.left();
                    continue;
                }
                next = next.right();
            }
            return next;
        }

        public String render() {
            return this.root.render(0, this.m_instanceBags);
        }

        public boolean trimNegativeBranches() {
            return this.root.trimNegativeBranches();
        }

        public int[] numPosRulesAndNumPosConditions() {
            return this.numPosRulesAndNumPosConditions(this.root);
        }

        private int[] numPosRulesAndNumPosConditions(TreeNode next) {
            int[] numPosRulesAndNumPosConditions = new int[2];
            if (next != null && next.isLeafNode()) {
                if (next.isPositiveLeaf()) {
                    numPosRulesAndNumPosConditions[0] = 1;
                }
            } else if (next != null) {
                Attribute a = next.split.attribute;
                int[] fromBelow = null;
                if (a.isNominal()) {
                    for (TreeNode child : next.nominals()) {
                        fromBelow = this.numPosRulesAndNumPosConditions(child);
                        numPosRulesAndNumPosConditions[0] = numPosRulesAndNumPosConditions[0] + fromBelow[0];
                        numPosRulesAndNumPosConditions[1] = numPosRulesAndNumPosConditions[1] + (fromBelow[1] + fromBelow[0]);
                    }
                } else {
                    fromBelow = this.numPosRulesAndNumPosConditions(next.left());
                    numPosRulesAndNumPosConditions[0] = numPosRulesAndNumPosConditions[0] + fromBelow[0];
                    numPosRulesAndNumPosConditions[1] = numPosRulesAndNumPosConditions[1] + (fromBelow[1] + fromBelow[0]);
                    fromBelow = this.numPosRulesAndNumPosConditions(next.right());
                    numPosRulesAndNumPosConditions[0] = numPosRulesAndNumPosConditions[0] + fromBelow[0];
                    numPosRulesAndNumPosConditions[1] = numPosRulesAndNumPosConditions[1] + (fromBelow[1] + fromBelow[0]);
                }
            }
            return numPosRulesAndNumPosConditions;
        }
    }
}

