/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Optimization;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;
import weka.filters.unsupervised.attribute.Standardize;

public class QuickDDIterative
extends AbstractClassifier
implements OptionHandler,
MultiInstanceCapabilitiesHandler,
TechnicalInformationHandler,
WeightedInstancesHandler {
    static final long serialVersionUID = 4263507733600536170L;
    protected int m_ClassIndex;
    protected double[] m_Par;
    protected double[] m_CurrentCandidate;
    protected int m_NumClasses;
    protected double[] m_BagWeights;
    protected int[] m_Classes;
    protected double[][][] m_Data;
    protected Instances m_Attributes;
    protected Filter m_Filter = null;
    protected int m_filterType = 1;
    protected double m_scaleFactor = 1.0;
    protected int m_maxIterations = 1;
    protected double m_maxProbNegativeClass = 1.0;
    protected boolean m_considerBothClasses = false;
    protected byte m_posClass = 1;
    public static final int FILTER_NORMALIZE = 0;
    public static final int FILTER_STANDARDIZE = 1;
    public static final int FILTER_NONE = 2;
    public static final Tag[] TAGS_FILTER = new Tag[]{new Tag(0, "Normalize training data"), new Tag(1, "Standardize training data"), new Tag(2, "No normalization/standardization")};
    protected static double m_Epsilon = 1.0;
    protected static double m_Zero;
    protected ReplaceMissingValues m_Missing = new ReplaceMissingValues();

    public String globalInfo() {
        return "Modified, faster, iterative version of the basic diverse density algorithm. Uses only instances from positive bags as candidate diverse density maxima. Picks best instance based on current scaling vector, then optimizes scaling vector. Once vector has been found, picks new best point based on new scaling vector (if the number of desired iterations is greater than one). Performs one iteration by default (Scaling Once). For good results, try boosting it with RealAdaBoost, setting the maximum probability of the negative class to 0.5 and enabling consideration of both classes as the positive class. Note that standardization of attributes is default, but normalization can work better.\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "James R. Foulds and Eibe Frank");
        result.setValue(TechnicalInformation.Field.TITLE, "Speeding up and boosting diverse density learning");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Proc 13th International Conference on Discovery Science");
        result.setValue(TechnicalInformation.Field.YEAR, "2010");
        result.setValue(TechnicalInformation.Field.PAGES, "102-116");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        return result;
    }

    public Enumeration<Option> listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tWhether to 0=normalize/1=standardize/2=neither.\n\t(default 1=standardize)", "N", 1, "-N <num>"));
        result.addElement(new Option("\tThe initial scaling factor (constant for all attributes).", "S", 1, "-S <num>"));
        result.addElement(new Option("\tMaximum probability of negative class (default 1).", "M", 1, "-M <num>"));
        result.addElement(new Option("\tThe maximum number of iterations to perform (default 1).", "I", 1, "-I <num>"));
        result.addElement(new Option("\tConsider both classes as positive classes. (default: only last class).", "C", 0, "-C"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String nString = Utils.getOption((char)'N', (String[])options);
        if (nString.length() != 0) {
            this.setFilterType(new SelectedTag(Integer.parseInt(nString), TAGS_FILTER));
        } else {
            this.setFilterType(new SelectedTag(1, TAGS_FILTER));
        }
        String sString = Utils.getOption((char)'S', (String[])options);
        if (sString.length() != 0) {
            this.setScalingFactor(Double.parseDouble(sString));
        } else {
            this.setScalingFactor(1.0);
        }
        String rString = Utils.getOption((char)'M', (String[])options);
        if (rString.length() != 0) {
            this.setMaxProbNegativeClass(Double.parseDouble(rString));
        } else {
            this.setMaxProbNegativeClass(1.0);
        }
        String iString = Utils.getOption((char)'I', (String[])options);
        if (iString.length() != 0) {
            this.setMaxIterations(Integer.parseInt(iString));
        } else {
            this.setMaxIterations(1);
        }
        this.setConsiderBothClasses(Utils.getFlag((char)'C', (String[])options));
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-N");
        result.add("" + this.m_filterType);
        result.add("-S");
        result.add("" + this.m_scaleFactor);
        result.add("-M");
        result.add("" + this.m_maxProbNegativeClass);
        result.add("-I");
        result.add("" + this.m_maxIterations);
        if (this.getConsiderBothClasses()) {
            result.add("-C");
        }
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public String filterTypeTipText() {
        return "The filter type for transforming the training data.";
    }

    public SelectedTag getFilterType() {
        return new SelectedTag(this.m_filterType, TAGS_FILTER);
    }

    public void setFilterType(SelectedTag newType) {
        if (newType.getTags() == TAGS_FILTER) {
            this.m_filterType = newType.getSelectedTag().getID();
        }
    }

    public String scalingFactorTipText() {
        return "The initial value of the scaling factor for all attributes.";
    }

    public void setScalingFactor(double scale) {
        this.m_scaleFactor = scale;
    }

    public double getScalingFactor() {
        return this.m_scaleFactor;
    }

    public String maxProbNegativeClassTipText() {
        return "The maximum probability for the negative class.";
    }

    public void setMaxProbNegativeClass(double r) {
        this.m_maxProbNegativeClass = r;
    }

    public double getMaxProbNegativeClass() {
        return this.m_maxProbNegativeClass;
    }

    public String considerBothClassesTipText() {
        return "Whether to run the algorithm once for each class.";
    }

    public void setConsiderBothClasses(boolean b) {
        this.m_considerBothClasses = b;
    }

    public boolean getConsiderBothClasses() {
        return this.m_considerBothClasses;
    }

    public String maxIterationsTipText() {
        return "The maximum number of iterations to perform.";
    }

    public void setMaxIterations(int maxIterations) {
        this.m_maxIterations = maxIterations;
    }

    public int getMaxIterations() {
        return this.m_maxIterations;
    }

    protected double computeNegativeLogLikelihood(double[] x) {
        double nll = 0.0;
        for (int i = 0; i < this.m_Classes.length; ++i) {
            int nI = this.m_Data[i][0].length;
            double bag = 0.0;
            for (int j = 0; j < nI; ++j) {
                double ins = 0.0;
                for (int k = 0; k < this.m_Data[i].length; ++k) {
                    double temp = (this.m_Data[i][k][j] - this.m_CurrentCandidate[k]) * x[k];
                    ins += temp * temp;
                }
                ins = Math.exp(-ins);
                ins = 1.0 - ins;
                if (this.m_Classes[i] == this.m_posClass) {
                    bag += Math.log(ins);
                    continue;
                }
                if (ins <= m_Zero) {
                    ins = m_Zero;
                }
                bag += Math.log(ins);
            }
            if (this.m_Classes[i] == this.m_posClass) {
                if ((bag = 1.0 - this.m_maxProbNegativeClass * Math.exp(bag)) <= m_Zero) {
                    bag = m_Zero;
                }
                nll -= this.m_BagWeights[i] * Math.log(bag);
                continue;
            }
            if ((bag = this.m_maxProbNegativeClass * Math.exp(bag)) <= m_Zero) {
                bag = m_Zero;
            }
            nll -= this.m_BagWeights[i] * Math.log(bag);
        }
        return nll;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.BINARY_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.ONLY_MULTIINSTANCE);
        return result;
    }

    public Capabilities getMultiInstanceCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.disableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public void buildClassifier(Instances train) throws Exception {
        int i;
        this.getCapabilities().testWithFail(train);
        train = new Instances(train);
        train.deleteWithMissingClass();
        this.m_ClassIndex = train.classIndex();
        this.m_NumClasses = train.numClasses();
        int nR = train.attribute(1).relation().numAttributes();
        int nC = train.numInstances();
        int[] bagSize = new int[nC];
        Instances datasets = new Instances(train.attribute(1).relation(), 0);
        this.m_Data = new double[nC][nR][];
        this.m_Classes = new int[nC];
        this.m_BagWeights = new double[nC];
        this.m_Attributes = datasets.stringFreeStructure();
        if (this.m_Debug) {
            System.out.println("Extracting data...");
        }
        for (int h = 0; h < nC; ++h) {
            int nI;
            Instance current = train.instance(h);
            this.m_Classes[h] = (int)current.classValue();
            this.m_BagWeights[h] = current.weight();
            Instances currInsts = current.relationalValue(1);
            for (i = 0; i < currInsts.numInstances(); ++i) {
                Instance inst = currInsts.instance(i);
                datasets.add(inst);
            }
            bagSize[h] = nI = currInsts.numInstances();
        }
        this.m_Filter = this.m_filterType == 1 ? new Standardize() : (this.m_filterType == 0 ? new Normalize() : null);
        if (this.m_Filter != null) {
            this.m_Filter.setInputFormat(datasets);
            datasets = Filter.useFilter((Instances)datasets, (Filter)this.m_Filter);
        }
        this.m_Missing.setInputFormat(datasets);
        datasets = Filter.useFilter((Instances)datasets, (Filter)this.m_Missing);
        int instIndex = 0;
        int start = 0;
        for (int h = 0; h < nC; ++h) {
            for (i = 0; i < datasets.numAttributes(); ++i) {
                this.m_Data[h][i] = new double[bagSize[h]];
                instIndex = start;
                for (int k = 0; k < bagSize[h]; ++k) {
                    this.m_Data[h][i][k] = datasets.instance(instIndex).value(i);
                    ++instIndex;
                }
            }
            start = instIndex;
        }
        if (this.m_Debug) {
            System.out.println("\nIteration History...");
        }
        double bestOverall = Double.MAX_VALUE;
        double[] bestPar = new double[2 * nR];
        byte bestPosClass = 1;
        this.m_posClass = 1;
        while (this.m_posClass >= 0 && this.m_considerBothClasses || this.m_posClass == 1) {
            double lastnll;
            double[] tmp = new double[nR];
            this.m_CurrentCandidate = new double[nR];
            double[][] b = new double[2][nR];
            double bestnll = Double.MAX_VALUE;
            for (int t = 0; t < nR; ++t) {
                b[0][t] = Double.NaN;
                b[1][t] = Double.NaN;
            }
            double[] scalingVector = new double[nR];
            for (int i2 = 0; i2 < scalingVector.length; ++i2) {
                scalingVector[i2] = this.m_scaleFactor;
            }
            int numIterations = 0;
            do {
                int i3;
                double nll;
                ++numIterations;
                if (this.m_Debug) {
                    System.err.println("iteration " + numIterations);
                }
                lastnll = bestnll;
                for (int exIdx = 0; exIdx < this.m_Data.length; ++exIdx) {
                    if (this.m_Classes[exIdx] != this.m_posClass) {
                        if (!this.m_Debug) continue;
                        System.err.println(exIdx + " " + this.m_BagWeights[exIdx]);
                        continue;
                    }
                    for (int p = 0; p < this.m_Data[exIdx][0].length; ++p) {
                        int i4;
                        for (int q = 0; q < nR; ++q) {
                            this.m_CurrentCandidate[q] = this.m_Data[exIdx][q][p];
                        }
                        nll = this.computeNegativeLogLikelihood(scalingVector);
                        if (this.m_Debug) {
                            System.err.print(exIdx + " " + p + " " + this.m_BagWeights[exIdx] + " " + nll + " ");
                            for (i4 = 0; i4 < nR; ++i4) {
                                System.err.print(this.m_Data[exIdx][i4][p] + ", ");
                            }
                            System.err.println();
                        }
                        if (!(nll < bestnll)) continue;
                        bestnll = nll;
                        this.m_Par = new double[this.m_CurrentCandidate.length * 2];
                        for (i4 = 0; i4 < this.m_CurrentCandidate.length; ++i4) {
                            this.m_Par[2 * i4] = this.m_CurrentCandidate[i4];
                            this.m_Par[2 * i4 + 1] = scalingVector[i4];
                        }
                    }
                }
                for (i3 = 0; i3 < nR; ++i3) {
                    this.m_CurrentCandidate[i3] = this.m_Par[2 * i3];
                }
                if (this.m_Debug) {
                    System.err.println("********* Finding best scaling vector");
                }
                OptEng opt = new OptEng();
                tmp = opt.findArgmin(scalingVector, b);
                while (tmp == null) {
                    tmp = opt.getVarbValues();
                    if (this.m_Debug) {
                        System.out.println("200 iterations finished, not enough!");
                    }
                    tmp = opt.findArgmin(tmp, b);
                }
                nll = opt.getMinFunction();
                scalingVector = tmp;
                if (nll < bestnll) {
                    bestnll = nll;
                    this.m_Par = new double[this.m_CurrentCandidate.length * 2];
                    for (i3 = 0; i3 < this.m_CurrentCandidate.length; ++i3) {
                        this.m_Par[2 * i3] = this.m_CurrentCandidate[i3];
                        this.m_Par[2 * i3 + 1] = scalingVector[i3];
                    }
                }
                if (!this.m_Debug) continue;
                System.err.println("---------------     " + bestnll);
            } while (bestnll < lastnll && numIterations < this.m_maxIterations);
            if (bestnll < bestOverall) {
                bestPosClass = this.m_posClass;
                bestOverall = bestnll;
                System.arraycopy(this.m_Par, 0, bestPar, 0, bestPar.length);
                if (this.m_Debug) {
                    System.err.println("New best class: " + bestPosClass);
                    System.err.println("New best nll: " + bestnll);
                    for (double element : bestPar) {
                        System.err.print(element + ",");
                    }
                    System.err.println();
                }
            }
            this.m_posClass = (byte)(this.m_posClass - 1);
        }
        this.m_Par = bestPar;
        this.m_posClass = bestPosClass;
        this.m_Data = null;
        this.m_Classes = null;
        this.m_CurrentCandidate = null;
        this.m_BagWeights = null;
    }

    public double[] distributionForInstance(Instance exmp) throws Exception {
        Instances ins = exmp.relationalValue(1);
        if (this.m_Filter != null) {
            ins = Filter.useFilter((Instances)ins, (Filter)this.m_Filter);
        }
        ins = Filter.useFilter((Instances)ins, (Filter)this.m_Missing);
        int nI = ins.numInstances();
        int nA = ins.numAttributes();
        double[][] dat = new double[nI][nA];
        for (int j = 0; j < nI; ++j) {
            for (int k = 0; k < nA; ++k) {
                dat[j][k] = ins.instance(j).value(k);
            }
        }
        double[] distribution = new double[2];
        distribution[1 - this.m_posClass] = 0.0;
        for (int i = 0; i < nI; ++i) {
            double exp = 0.0;
            for (int r = 0; r < nA; ++r) {
                exp += (this.m_Par[r * 2] - dat[i][r]) * (this.m_Par[r * 2] - dat[i][r]) * this.m_Par[r * 2 + 1] * this.m_Par[r * 2 + 1];
            }
            exp = Math.exp(-exp);
            int n = 1 - this.m_posClass;
            distribution[n] = distribution[n] + Math.log(1.0 - exp);
        }
        distribution[1 - this.m_posClass] = this.m_maxProbNegativeClass * Math.exp(distribution[1 - this.m_posClass]);
        distribution[this.m_posClass] = 1.0 - distribution[1 - this.m_posClass];
        return distribution;
    }

    public String toString() {
        String result = "Diverse Density";
        if (this.m_Par == null) {
            return result + ": No model built yet.";
        }
        result = result + "\nPositive Class:" + this.m_posClass + "\n";
        result = result + "\nCoefficients...\nVariable       Point       Scale\n";
        int j = 0;
        int idx = 0;
        while (j < this.m_Par.length / 2) {
            result = result + this.m_Attributes.attribute(idx).name();
            result = result + " " + Utils.doubleToString((double)this.m_Par[j * 2], (int)12, (int)4);
            result = result + " " + Utils.doubleToString((double)this.m_Par[j * 2 + 1], (int)12, (int)4) + "\n";
            ++j;
            ++idx;
        }
        return result;
    }

    public static void main(String[] argv) {
        QuickDDIterative.runClassifier((Classifier)new QuickDDIterative(), (String[])argv);
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 10369 $");
    }

    static {
        while (1.0 + m_Epsilon > 1.0) {
            m_Epsilon /= 2.0;
        }
        m_Zero = Math.sqrt(m_Epsilon *= 2.0);
    }

    private class OptEng
    extends Optimization {
        private OptEng() {
        }

        protected double objectiveFunction(double[] x) {
            return QuickDDIterative.this.computeNegativeLogLikelihood(x);
        }

        protected double[] evaluateGradient(double[] x) {
            double[] grad = new double[x.length];
            for (int i = 0; i < QuickDDIterative.this.m_Classes.length; ++i) {
                int nI = QuickDDIterative.this.m_Data[i][0].length;
                double denom = 0.0;
                double[] numrt = new double[x.length];
                for (int j = 0; j < nI; ++j) {
                    double exp = 0.0;
                    for (int k = 0; k < QuickDDIterative.this.m_Data[i].length; ++k) {
                        double temp = (QuickDDIterative.this.m_Data[i][k][j] - QuickDDIterative.this.m_CurrentCandidate[k]) * x[k];
                        exp += temp * temp;
                    }
                    exp = Math.exp(-exp);
                    exp = 1.0 - exp;
                    if (QuickDDIterative.this.m_Classes[i] == QuickDDIterative.this.m_posClass) {
                        denom += Math.log(exp);
                    }
                    if (exp <= m_Zero) {
                        exp = m_Zero;
                    }
                    double fact = 2.0 * (1.0 - exp) / exp;
                    for (int p = 0; p < QuickDDIterative.this.m_Data[i].length; ++p) {
                        double temp = QuickDDIterative.this.m_CurrentCandidate[p] - QuickDDIterative.this.m_Data[i][p][j];
                        int n = p;
                        numrt[n] = numrt[n] + fact * temp * temp * x[p];
                    }
                }
                if ((denom = 1.0 - QuickDDIterative.this.m_maxProbNegativeClass * Math.exp(denom)) <= m_Zero) {
                    denom = m_Zero;
                }
                for (int q = 0; q < QuickDDIterative.this.m_Data[i].length; ++q) {
                    if (QuickDDIterative.this.m_Classes[i] == QuickDDIterative.this.m_posClass) {
                        int n = q;
                        grad[n] = grad[n] + QuickDDIterative.this.m_BagWeights[i] * numrt[q] * (1.0 - denom) / denom;
                        continue;
                    }
                    int n = q;
                    grad[n] = grad[n] - QuickDDIterative.this.m_BagWeights[i] * numrt[q];
                }
            }
            return grad;
        }

        public String getRevision() {
            return RevisionUtils.extract((String)"$Revision: 10369 $");
        }
    }
}

