/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.SingleClassifierEnhancer;
import weka.classifiers.meta.LogitBoost;
import weka.classifiers.trees.J48;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.PartitionGenerator;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.MultiFilter;
import weka.filters.supervised.attribute.PartitionMembership;
import weka.filters.unsupervised.attribute.MultiInstanceWrapper;
import weka.filters.unsupervised.attribute.Remove;

public class TLC
extends SingleClassifierEnhancer
implements TechnicalInformationHandler,
MultiInstanceCapabilitiesHandler {
    private static final long serialVersionUID = -4444591375578585231L;
    protected PartitionGenerator m_partitionGenerator = new J48();
    protected MultiFilter m_Filter = null;

    public String globalInfo() {
        return "Implements basic two-level classification method for multi-instance data, without attribute selection.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Nils Weidmann and Eibe Frank and Bernhard Pfahringer");
        result.setValue(TechnicalInformation.Field.TITLE, "A two-level learning method for generalized multi-instance problems");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Fourteenth European Conference on Machine Learning");
        result.setValue(TechnicalInformation.Field.YEAR, "2003");
        result.setValue(TechnicalInformation.Field.PAGES, "468-479");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.INPROCEEDINGS);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Eibe Frank and Bernhard Pfahringer");
        additional.setValue(TechnicalInformation.Field.TITLE, "Propositionalisation of Multi-instance Data Using Random Forests");
        additional.setValue(TechnicalInformation.Field.BOOKTITLE, "AI 2013: Advances in Artificial Intelligence");
        additional.setValue(TechnicalInformation.Field.YEAR, "2013");
        additional.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        additional.setValue(TechnicalInformation.Field.PAGES, "362-373");
        return result;
    }

    public TLC() {
        this.m_Classifier = new LogitBoost();
    }

    protected String defaultClassifierString() {
        return "weka.classifiers.meta.LogitBoost";
    }

    public String partitionGeneratorTipText() {
        return "The partition generator that will generate membership values for the instances.";
    }

    public void setPartitionGenerator(PartitionGenerator newPartitionGenerator) {
        this.m_partitionGenerator = newPartitionGenerator;
    }

    public PartitionGenerator getPartitionGenerator() {
        return this.m_partitionGenerator;
    }

    protected String getPartitionGeneratorSpec() {
        PartitionGenerator c = this.getPartitionGenerator();
        if (c instanceof OptionHandler) {
            return c.getClass().getName() + " " + Utils.joinOptions((String[])((OptionHandler)c).getOptions());
        }
        return c.getClass().getName();
    }

    public Enumeration<Option> listOptions() {
        Vector<Object> newVector = new Vector<Object>(1);
        newVector.addElement(new Option("\tPartition generator to use, including options.\n\tQuotes are needed when options are specified.\n\t(default: weka.classifiers.trees.J48)", "P", 1, "-P \"<name and options of partition generator>\""));
        newVector.addAll(Collections.list(super.listOptions()));
        newVector.addElement(new Option("", "", 0, "\nOptions specific to partition generator " + this.getPartitionGenerator().getClass().getName() + ":"));
        newVector.addAll(Collections.list(((OptionHandler)this.getPartitionGenerator()).listOptions()));
        return newVector.elements();
    }

    public void setOptions(String[] options) throws Exception {
        String partitionGeneratorString = Utils.getOption((char)'P', (String[])options);
        if (partitionGeneratorString.length() > 0) {
            String[] partitionGeneratorSpec = Utils.splitOptions((String)partitionGeneratorString);
            if (partitionGeneratorSpec.length == 0) {
                throw new IllegalArgumentException("Invalid partition generator specification string");
            }
            String partitionGeneratorName = partitionGeneratorSpec[0];
            partitionGeneratorSpec[0] = "";
            this.setPartitionGenerator((PartitionGenerator)Utils.forName(PartitionGenerator.class, (String)partitionGeneratorName, (String[])partitionGeneratorSpec));
        } else {
            this.setPartitionGenerator((PartitionGenerator)new J48());
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-P");
        options.add("" + this.getPartitionGeneratorSpec());
        Collections.addAll(options, super.getOptions());
        return options.toArray(new String[0]);
    }

    public void buildClassifier(Instances data) throws Exception {
        data = new Instances(data);
        data.deleteWithMissingClass();
        this.getCapabilities().testWithFail(data);
        this.m_Filter = new MultiFilter();
        Filter[] twoFilters = new Filter[2];
        PartitionMembership pm = new PartitionMembership();
        pm.setPartitionGenerator(this.getPartitionGenerator());
        MultiInstanceWrapper miw = new MultiInstanceWrapper();
        miw.setFilter((Filter)pm);
        twoFilters[0] = miw;
        twoFilters[1] = new Remove();
        ((Remove)twoFilters[1]).setAttributeIndices("1");
        this.m_Filter.setFilters(twoFilters);
        this.m_Filter.setInputFormat(data);
        Instances propositionalData = Filter.useFilter((Instances)data, (Filter)this.m_Filter);
        this.getClassifier().getCapabilities().testWithFail(propositionalData);
        this.m_Classifier.buildClassifier(propositionalData);
    }

    public String toString() {
        if (this.m_Classifier == null) {
            return "Classifier not built yet.";
        }
        return "Partition Generator:\n\n" + this.getPartitionGenerator().toString() + "\n\nClassifier:\n\n" + this.getClassifier().toString();
    }

    public double[] distributionForInstance(Instance inst) throws Exception {
        inst = (Instance)inst.copy();
        this.m_Filter.input(inst);
        this.m_Filter.batchFinished();
        return this.m_Classifier.distributionForInstance(this.m_Filter.output());
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 14016 $");
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.disableAllAttributes();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.disableAllClasses();
        result.disableAllClassDependencies();
        if (super.getCapabilities().handles(Capabilities.Capability.NOMINAL_CLASS)) {
            result.enable(Capabilities.Capability.NOMINAL_CLASS);
        }
        if (super.getCapabilities().handles(Capabilities.Capability.BINARY_CLASS)) {
            result.enable(Capabilities.Capability.BINARY_CLASS);
        }
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.ONLY_MULTIINSTANCE);
        return result;
    }

    public Capabilities getMultiInstanceCapabilities() {
        Capabilities result = this.m_partitionGenerator.getCapabilities();
        result.enable(Capabilities.Capability.NO_CLASS);
        result.setMinimumNumberInstances(0);
        return result;
    }

    public static void main(String[] options) {
        TLC.runClassifier((Classifier)new TLC(), (String[])options);
    }
}

