/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.RandomizableClassifier;
import weka.classifiers.mi.TLD_Optm;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class TLD
extends RandomizableClassifier
implements OptionHandler,
MultiInstanceCapabilitiesHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = 6657315525171152210L;
    protected double[][] m_MeanP = null;
    protected double[][] m_VarianceP = null;
    protected double[][] m_MeanN = null;
    protected double[][] m_VarianceN = null;
    protected double[][] m_SumP = null;
    protected double[][] m_SumN = null;
    protected double[] m_ParamsP = null;
    protected double[] m_ParamsN = null;
    protected int m_Dimension = 0;
    protected double[] m_Class = null;
    protected int m_NumClasses = 2;
    public static double ZERO = 1.0E-6;
    protected int m_Run = 1;
    protected double m_Cutoff;
    protected boolean m_UseEmpiricalCutOff = false;

    public String globalInfo() {
        return "Two-Level Distribution approach, changes the starting value of the searching algorithm, supplement the cut-off modification and check missing values.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MASTERSTHESIS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Xin Xu");
        result.setValue(TechnicalInformation.Field.YEAR, "2003");
        result.setValue(TechnicalInformation.Field.TITLE, "Statistical learning in multiple instance problem");
        result.setValue(TechnicalInformation.Field.SCHOOL, "University of Waikato");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Hamilton, NZ");
        result.setValue(TechnicalInformation.Field.NOTE, "0657.594");
        return result;
    }

    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.RELATIONAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.BINARY_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.ONLY_MULTIINSTANCE);
        return result;
    }

    public Capabilities getMultiInstanceCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.disableAllClasses();
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public void buildClassifier(Instances exs) throws Exception {
        double m;
        double w;
        int x;
        int u;
        int t;
        int w2;
        int k;
        int v;
        this.getCapabilities().testWithFail(exs);
        exs = new Instances(exs);
        exs.deleteWithMissingClass();
        int numegs = exs.numInstances();
        this.m_Dimension = exs.attribute(1).relation().numAttributes();
        Instances pos = new Instances(exs, 0);
        Instances neg = new Instances(exs, 0);
        for (int u2 = 0; u2 < numegs; ++u2) {
            Instance example = exs.instance(u2);
            if (example.classValue() == 1.0) {
                pos.add(example);
                continue;
            }
            neg.add(example);
        }
        int pnum = pos.numInstances();
        int nnum = neg.numInstances();
        this.m_MeanP = new double[pnum][this.m_Dimension];
        this.m_VarianceP = new double[pnum][this.m_Dimension];
        this.m_SumP = new double[pnum][this.m_Dimension];
        this.m_MeanN = new double[nnum][this.m_Dimension];
        this.m_VarianceN = new double[nnum][this.m_Dimension];
        this.m_SumN = new double[nnum][this.m_Dimension];
        this.m_ParamsP = new double[4 * this.m_Dimension];
        this.m_ParamsN = new double[4 * this.m_Dimension];
        double[] pSumVal = new double[this.m_Dimension];
        double[] nSumVal = new double[this.m_Dimension];
        double[] maxVarsP = new double[this.m_Dimension];
        double[] maxVarsN = new double[this.m_Dimension];
        double[] varMeanP = new double[this.m_Dimension];
        double[] varMeanN = new double[this.m_Dimension];
        double[] meanVarP = new double[this.m_Dimension];
        double[] meanVarN = new double[this.m_Dimension];
        double[] numExsP = new double[this.m_Dimension];
        double[] numExsN = new double[this.m_Dimension];
        for (v = 0; v < pnum; ++v) {
            Instances pxi = pos.instance(v).relationalValue(1);
            for (k = 0; k < pxi.numAttributes(); ++k) {
                this.m_MeanP[v][k] = pxi.meanOrMode(k);
                this.m_VarianceP[v][k] = pxi.variance(k);
            }
            w2 = 0;
            t = 0;
            while (w2 < this.m_Dimension) {
                if (!Double.isNaN(this.m_MeanP[v][w2])) {
                    for (u = 0; u < pxi.numInstances(); ++u) {
                        Instance ins = pxi.instance(u);
                        if (ins.isMissing(t)) continue;
                        double[] dArray = this.m_SumP[v];
                        int n = w2;
                        dArray[n] = dArray[n] + ins.weight();
                    }
                    int n = w2;
                    numExsP[n] = numExsP[n] + 1.0;
                    int n2 = w2;
                    pSumVal[n2] = pSumVal[n2] + this.m_MeanP[v][w2];
                    int n3 = w2;
                    meanVarP[n3] = meanVarP[n3] + this.m_MeanP[v][w2] * this.m_MeanP[v][w2];
                    if (maxVarsP[w2] < this.m_VarianceP[v][w2]) {
                        maxVarsP[w2] = this.m_VarianceP[v][w2];
                    }
                    int n4 = w2;
                    varMeanP[n4] = varMeanP[n4] + this.m_VarianceP[v][w2];
                    double[] dArray = this.m_VarianceP[v];
                    int n5 = w2;
                    dArray[n5] = dArray[n5] * (this.m_SumP[v][w2] - 1.0);
                    if (this.m_VarianceP[v][w2] < 0.0) {
                        this.m_VarianceP[v][w2] = 0.0;
                    }
                }
                ++w2;
                ++t;
            }
        }
        for (v = 0; v < nnum; ++v) {
            Instances nxi = neg.instance(v).relationalValue(1);
            for (k = 0; k < nxi.numAttributes(); ++k) {
                this.m_MeanN[v][k] = nxi.meanOrMode(k);
                this.m_VarianceN[v][k] = nxi.variance(k);
            }
            w2 = 0;
            t = 0;
            while (w2 < this.m_Dimension) {
                if (!Double.isNaN(this.m_MeanN[v][w2])) {
                    for (u = 0; u < nxi.numInstances(); ++u) {
                        if (nxi.instance(u).isMissing(t)) continue;
                        double[] dArray = this.m_SumN[v];
                        int n = w2;
                        dArray[n] = dArray[n] + nxi.instance(u).weight();
                    }
                    int n = w2;
                    numExsN[n] = numExsN[n] + 1.0;
                    int n6 = w2;
                    nSumVal[n6] = nSumVal[n6] + this.m_MeanN[v][w2];
                    int n7 = w2;
                    meanVarN[n7] = meanVarN[n7] + this.m_MeanN[v][w2] * this.m_MeanN[v][w2];
                    if (maxVarsN[w2] < this.m_VarianceN[v][w2]) {
                        maxVarsN[w2] = this.m_VarianceN[v][w2];
                    }
                    int n8 = w2;
                    varMeanN[n8] = varMeanN[n8] + this.m_VarianceN[v][w2];
                    double[] dArray = this.m_VarianceN[v];
                    int n9 = w2;
                    dArray[n9] = dArray[n9] * (this.m_SumN[v][w2] - 1.0);
                    if (this.m_VarianceN[v][w2] < 0.0) {
                        this.m_VarianceN[v][w2] = 0.0;
                    }
                }
                ++w2;
                ++t;
            }
        }
        for (int w3 = 0; w3 < this.m_Dimension; ++w3) {
            int n = w3;
            pSumVal[n] = pSumVal[n] / numExsP[w3];
            int n10 = w3;
            nSumVal[n10] = nSumVal[n10] / numExsN[w3];
            if (numExsP[w3] > 1.0) {
                meanVarP[w3] = meanVarP[w3] / (numExsP[w3] - 1.0) - pSumVal[w3] * numExsP[w3] / (numExsP[w3] - 1.0);
            }
            if (numExsN[w3] > 1.0) {
                meanVarN[w3] = meanVarN[w3] / (numExsN[w3] - 1.0) - nSumVal[w3] * numExsN[w3] / (numExsN[w3] - 1.0);
            }
            int n11 = w3;
            varMeanP[n11] = varMeanP[n11] / numExsP[w3];
            int n12 = w3;
            varMeanN[n12] = varMeanN[n12] / numExsN[w3];
        }
        double[][] bounds = new double[2][4];
        double[] pThisParam = new double[4];
        double[] nThisParam = new double[4];
        for (x = 0; x < this.m_Dimension; ++x) {
            double a;
            if (this.getDebug()) {
                System.err.println("\n\n!!!!!!!!!!!!!!!!!!!!!!???Dimension #" + x);
            }
            double d = a = maxVarsP[x] > ZERO ? maxVarsP[x] : 1.0;
            if (varMeanP[x] <= ZERO) {
                varMeanP[x] = ZERO;
            }
            double b = a / varMeanP[x] + 2.0;
            w = meanVarP[x] / varMeanP[x];
            if (w <= ZERO) {
                w = 1.0;
            }
            m = pSumVal[x];
            pThisParam[0] = a;
            pThisParam[1] = b;
            pThisParam[2] = w;
            pThisParam[3] = m;
            double d2 = a = maxVarsN[x] > ZERO ? maxVarsN[x] : 1.0;
            if (varMeanN[x] <= ZERO) {
                varMeanN[x] = ZERO;
            }
            b = a / varMeanN[x] + 2.0;
            w = meanVarN[x] / varMeanN[x];
            if (w <= ZERO) {
                w = 1.0;
            }
            m = nSumVal[x];
            nThisParam[0] = a;
            nThisParam[1] = b;
            nThisParam[2] = w;
            nThisParam[3] = m;
            bounds[0][0] = ZERO;
            bounds[0][1] = 2.0 + ZERO;
            bounds[0][2] = ZERO;
            bounds[0][3] = Double.NaN;
            for (int t2 = 0; t2 < 4; ++t2) {
                bounds[1][t2] = Double.NaN;
                this.m_ParamsP[4 * x + t2] = pThisParam[t2];
                this.m_ParamsN[4 * x + t2] = nThisParam[t2];
            }
            double pminVal = Double.MAX_VALUE;
            double nminVal = Double.MAX_VALUE;
            Random whichEx = new Random(this.m_Seed);
            TLD_Optm pOp = null;
            TLD_Optm nOp = null;
            boolean isRunValid = true;
            double[] sumP = new double[pnum];
            double[] meanP = new double[pnum];
            double[] varP = new double[pnum];
            double[] sumN = new double[nnum];
            double[] meanN = new double[nnum];
            double[] varN = new double[nnum];
            for (int p = 0; p < pnum; ++p) {
                sumP[p] = this.m_SumP[p][x];
                meanP[p] = this.m_MeanP[p][x];
                varP[p] = this.m_VarianceP[p][x];
            }
            for (int q = 0; q < nnum; ++q) {
                sumN[q] = this.m_SumN[q][x];
                meanN[q] = this.m_MeanN[q][x];
                varN[q] = this.m_VarianceN[q][x];
            }
            int y = 0;
            while (y < this.m_Run) {
                double sq;
                int z;
                if (this.getDebug()) {
                    System.err.println("\n\n!!!!!!!!!!!!!!!!!!!!!!???Run #" + y);
                }
                if (this.getDebug()) {
                    System.err.println("\nPositive exemplars");
                }
                pOp = new TLD_Optm();
                pOp.setNum(sumP);
                pOp.setSSquare(varP);
                pOp.setXBar(meanP);
                pThisParam = pOp.findArgmin(pThisParam, bounds);
                while (pThisParam == null) {
                    pThisParam = pOp.getVarbValues();
                    if (this.getDebug()) {
                        System.err.println("!!! 200 iterations finished, not enough!");
                    }
                    pThisParam = pOp.findArgmin(pThisParam, bounds);
                }
                double thisMin = pOp.getMinFunction();
                if (!Double.isNaN(thisMin) && thisMin < pminVal) {
                    pminVal = thisMin;
                    for (z = 0; z < 4; ++z) {
                        this.m_ParamsP[4 * x + z] = pThisParam[z];
                    }
                }
                if (Double.isNaN(thisMin)) {
                    pThisParam = new double[4];
                    isRunValid = false;
                }
                if (this.getDebug()) {
                    System.err.println("\nNegative exemplars");
                }
                nOp = new TLD_Optm();
                nOp.setNum(sumN);
                nOp.setSSquare(varN);
                nOp.setXBar(meanN);
                nThisParam = nOp.findArgmin(nThisParam, bounds);
                while (nThisParam == null) {
                    nThisParam = nOp.getVarbValues();
                    if (this.getDebug()) {
                        System.err.println("!!! 200 iterations finished, not enough!");
                    }
                    nThisParam = nOp.findArgmin(nThisParam, bounds);
                }
                thisMin = nOp.getMinFunction();
                if (!Double.isNaN(thisMin) && thisMin < nminVal) {
                    nminVal = thisMin;
                    for (z = 0; z < 4; ++z) {
                        this.m_ParamsN[4 * x + z] = nThisParam[z];
                    }
                }
                if (Double.isNaN(thisMin)) {
                    nThisParam = new double[4];
                    isRunValid = false;
                }
                if (!isRunValid) {
                    --y;
                    isRunValid = true;
                }
                if (++y >= this.m_Run) continue;
                int pone = whichEx.nextInt(pnum);
                int none = whichEx.nextInt(nnum);
                while (this.m_SumP[pone][x] <= 1.0 || Double.isNaN(this.m_MeanP[pone][x])) {
                    pone = whichEx.nextInt(pnum);
                }
                a = this.m_VarianceP[pone][x] / (this.m_SumP[pone][x] - 1.0);
                if (a <= ZERO) {
                    a = this.m_ParamsN[4 * x];
                }
                if ((b = a * this.m_ParamsP[4 * x + 2] / (sq = ((m = this.m_MeanP[pone][x]) - this.m_ParamsP[4 * x + 3]) * (m - this.m_ParamsP[4 * x + 3])) + 2.0) <= ZERO || Double.isNaN(b) || Double.isInfinite(b)) {
                    b = this.m_ParamsN[4 * x + 1];
                }
                if ((w = sq * (this.m_ParamsP[4 * x + 1] - 2.0) / this.m_ParamsP[4 * x]) <= ZERO || Double.isNaN(w) || Double.isInfinite(w)) {
                    w = this.m_ParamsN[4 * x + 2];
                }
                pThisParam[0] = a;
                pThisParam[1] = b;
                pThisParam[2] = w;
                pThisParam[3] = m;
                while (this.m_SumN[none][x] <= 1.0 || Double.isNaN(this.m_MeanN[none][x])) {
                    none = whichEx.nextInt(nnum);
                }
                a = this.m_VarianceN[none][x] / (this.m_SumN[none][x] - 1.0);
                if (a <= ZERO) {
                    a = this.m_ParamsP[4 * x];
                }
                if ((b = a * this.m_ParamsN[4 * x + 2] / (sq = ((m = this.m_MeanN[none][x]) - this.m_ParamsN[4 * x + 3]) * (m - this.m_ParamsN[4 * x + 3])) + 2.0) <= ZERO || Double.isNaN(b) || Double.isInfinite(b)) {
                    b = this.m_ParamsP[4 * x + 1];
                }
                if ((w = sq * (this.m_ParamsN[4 * x + 1] - 2.0) / this.m_ParamsN[4 * x]) <= ZERO || Double.isNaN(w) || Double.isInfinite(w)) {
                    w = this.m_ParamsP[4 * x + 2];
                }
                nThisParam[0] = a;
                nThisParam[1] = b;
                nThisParam[2] = w;
                nThisParam[3] = m;
            }
        }
        x = 0;
        int y = 0;
        while (x < this.m_Dimension) {
            double a = this.m_ParamsP[4 * x];
            double b = this.m_ParamsP[4 * x + 1];
            w = this.m_ParamsP[4 * x + 2];
            m = this.m_ParamsP[4 * x + 3];
            if (this.getDebug()) {
                System.err.println("\n\n???Positive: ( " + exs.attribute(1).relation().attribute(y) + "): a=" + a + ", b=" + b + ", w=" + w + ", m=" + m);
            }
            a = this.m_ParamsN[4 * x];
            b = this.m_ParamsN[4 * x + 1];
            w = this.m_ParamsN[4 * x + 2];
            m = this.m_ParamsN[4 * x + 3];
            if (this.getDebug()) {
                System.err.println("???Negative: (" + exs.attribute(1).relation().attribute(y) + "): a=" + a + ", b=" + b + ", w=" + w + ", m=" + m);
            }
            ++x;
            ++y;
        }
        if (this.m_UseEmpiricalCutOff) {
            double[] pLogOdds = new double[pnum];
            double[] nLogOdds = new double[nnum];
            for (int p = 0; p < pnum; ++p) {
                pLogOdds[p] = this.likelihoodRatio(this.m_SumP[p], this.m_MeanP[p], this.m_VarianceP[p]);
            }
            for (int q = 0; q < nnum; ++q) {
                nLogOdds[q] = this.likelihoodRatio(this.m_SumN[q], this.m_MeanN[q], this.m_VarianceN[q]);
            }
            this.findCutOff(pLogOdds, nLogOdds);
        } else {
            this.m_Cutoff = -Math.log((double)pnum / (double)nnum);
        }
        if (this.getDebug()) {
            System.err.println("???Cut-off=" + this.m_Cutoff);
        }
    }

    public double classifyInstance(Instance ex) throws Exception {
        Instances exi = ex.relationalValue(1);
        double[] n = new double[this.m_Dimension];
        double[] xBar = new double[this.m_Dimension];
        double[] sSq = new double[this.m_Dimension];
        for (int i = 0; i < exi.numAttributes(); ++i) {
            xBar[i] = exi.meanOrMode(i);
            sSq[i] = exi.variance(i);
        }
        int w = 0;
        int t = 0;
        while (w < this.m_Dimension) {
            for (int u = 0; u < exi.numInstances(); ++u) {
                if (exi.instance(u).isMissing(t)) continue;
                int n2 = w;
                n[n2] = n[n2] + exi.instance(u).weight();
            }
            sSq[w] = sSq[w] * (n[w] - 1.0);
            if (sSq[w] <= 0.0) {
                sSq[w] = 0.0;
            }
            ++w;
            ++t;
        }
        double logOdds = this.likelihoodRatio(n, xBar, sSq);
        return logOdds > this.m_Cutoff ? 1.0 : 0.0;
    }

    private double likelihoodRatio(double[] n, double[] xBar, double[] sSq) {
        double LLP = 0.0;
        double LLN = 0.0;
        for (int x = 0; x < this.m_Dimension; ++x) {
            int y;
            if (Double.isNaN(xBar[x])) continue;
            int halfN = (int)n[x] / 2;
            double a = this.m_ParamsP[4 * x];
            double b = this.m_ParamsP[4 * x + 1];
            double w = this.m_ParamsP[4 * x + 2];
            double m = this.m_ParamsP[4 * x + 3];
            LLP += 0.5 * b * Math.log(a) + 0.5 * (b + n[x] - 1.0) * Math.log(1.0 + n[x] * w) - 0.5 * (b + n[x]) * Math.log((1.0 + n[x] * w) * (a + sSq[x]) + n[x] * (xBar[x] - m) * (xBar[x] - m)) - 0.5 * n[x] * Math.log(Math.PI);
            for (y = 1; y <= halfN; ++y) {
                LLP += Math.log(b / 2.0 + n[x] / 2.0 - (double)y);
            }
            if (n[x] / 2.0 > (double)halfN) {
                LLP += TLD_Optm.diffLnGamma(b / 2.0);
            }
            a = this.m_ParamsN[4 * x];
            b = this.m_ParamsN[4 * x + 1];
            w = this.m_ParamsN[4 * x + 2];
            m = this.m_ParamsN[4 * x + 3];
            LLN += 0.5 * b * Math.log(a) + 0.5 * (b + n[x] - 1.0) * Math.log(1.0 + n[x] * w) - 0.5 * (b + n[x]) * Math.log((1.0 + n[x] * w) * (a + sSq[x]) + n[x] * (xBar[x] - m) * (xBar[x] - m)) - 0.5 * n[x] * Math.log(Math.PI);
            for (y = 1; y <= halfN; ++y) {
                LLN += Math.log(b / 2.0 + n[x] / 2.0 - (double)y);
            }
            if (!(n[x] / 2.0 > (double)halfN)) continue;
            LLN += TLD_Optm.diffLnGamma(b / 2.0);
        }
        return LLP - LLN;
    }

    private void findCutOff(double[] pos, double[] neg) {
        int[] pOrder = Utils.sort((double[])pos);
        int[] nOrder = Utils.sort((double[])neg);
        int pNum = pos.length;
        int nNum = neg.length;
        int p = 0;
        int n = 0;
        double fstAccu = 0.0;
        double sndAccu = pNum;
        double maxAccu = 0.0;
        double minDistTo0 = Double.MAX_VALUE;
        while (n < nNum && pos[pOrder[0]] >= neg[nOrder[n]]) {
            ++n;
            fstAccu += 1.0;
        }
        if (n >= nNum) {
            this.m_Cutoff = (neg[nOrder[nNum - 1]] + pos[pOrder[0]]) / 2.0;
            return;
        }
        while (p < pNum && n < nNum) {
            double split;
            if (pos[pOrder[p]] >= neg[nOrder[n]]) {
                fstAccu += 1.0;
                split = neg[nOrder[n]];
                ++n;
            } else {
                sndAccu -= 1.0;
                split = pos[pOrder[p]];
                ++p;
            }
            if (!(fstAccu + sndAccu > maxAccu) && (fstAccu + sndAccu != maxAccu || !(Math.abs(split) < minDistTo0))) continue;
            maxAccu = fstAccu + sndAccu;
            this.m_Cutoff = split;
            minDistTo0 = Math.abs(split);
        }
    }

    public Enumeration<Option> listOptions() {
        Vector<Object> result = new Vector<Object>();
        result.addElement(new Option("\tSet whether or not use empirical\n\tlog-odds cut-off instead of 0", "C", 0, "-C"));
        result.addElement(new Option("\tSet the number of multiple runs \n\tneeded for searching the MLE.", "R", 1, "-R <numOfRuns>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    public void setOptions(String[] options) throws Exception {
        this.setUsingCutOff(Utils.getFlag((char)'C', (String[])options));
        String runString = Utils.getOption((char)'R', (String[])options);
        if (runString.length() != 0) {
            this.setNumRuns(Integer.parseInt(runString));
        } else {
            this.setNumRuns(1);
        }
        super.setOptions(options);
        Utils.checkForRemainingOptions((String[])options);
    }

    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        if (this.getUsingCutOff()) {
            result.add("-C");
        }
        result.add("-R");
        result.add("" + this.getNumRuns());
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    public String numRunsTipText() {
        return "The number of runs to perform.";
    }

    public void setNumRuns(int numRuns) {
        this.m_Run = numRuns;
    }

    public int getNumRuns() {
        return this.m_Run;
    }

    public String usingCutOffTipText() {
        return "Whether to use an empirical cutoff.";
    }

    public void setUsingCutOff(boolean cutOff) {
        this.m_UseEmpiricalCutOff = cutOff;
    }

    public boolean getUsingCutOff() {
        return this.m_UseEmpiricalCutOff;
    }

    public String getRevision() {
        return RevisionUtils.extract((String)"$Revision: 10369 $");
    }

    public static void main(String[] args) {
        TLD.runClassifier((Classifier)new TLD(), (String[])args);
    }
}

