/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi.miti;

import java.io.Serializable;
import java.util.List;
import weka.core.Instance;
import weka.core.Instances;

public class Bag
implements Serializable {
    private static final long serialVersionUID = 3890971117182125677L;
    private final boolean positive;
    private final Instances instances;
    private final String id;
    private final double bagWeight;
    private double bagWeightMultiplied;
    private boolean enabled = true;

    public Bag(Instance bagInstance) {
        this.instances = bagInstance.relationalValue(1);
        this.positive = bagInstance.classValue() == 1.0;
        this.bagWeightMultiplied = this.bagWeight = 1.0 / (double)this.instances.numInstances();
        this.id = bagInstance.stringValue(0);
    }

    public Instances instances() {
        return this.instances;
    }

    public boolean isPositive() {
        return this.positive;
    }

    public double bagWeight() {
        return this.bagWeightMultiplied;
    }

    public void setBagWeightMultiplier(double multiplier) {
        this.bagWeightMultiplied = multiplier * this.bagWeight;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void disableInstances(List<String> deactivated) {
        if (this.enabled) {
            deactivated.add(this.id);
        }
        this.enabled = false;
    }

    public static void printDeactivatedInstances(List<String> deactivated) {
        System.out.print("DEACTIVATING examples [");
        System.out.print(deactivated.get(0));
        for (int i = 1; i < deactivated.size(); ++i) {
            System.out.print(", " + deactivated.get(i));
        }
        System.out.println("]");
    }
}

