/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi.miti;

import weka.classifiers.mi.miti.BEPP;
import weka.classifiers.mi.miti.IBestSplitMeasure;
import weka.classifiers.mi.miti.SufficientStatistics;

public class Gini
implements IBestSplitMeasure {
    public static double getGiniImpurity(SufficientStatistics ss, int kBEPPConstant, boolean unbiasedEstimate) {
        double leftBEPP = BEPP.GetLeftBEPP(ss, kBEPPConstant, unbiasedEstimate);
        double rightBEPP = BEPP.GetRightBEPP(ss, kBEPPConstant, unbiasedEstimate);
        return (leftBEPP * (1.0 - leftBEPP) * ss.totalCountLeft() + rightBEPP * (1.0 - rightBEPP) * ss.totalCountRight()) / (ss.totalCountLeft() + ss.totalCountRight());
    }

    public static double getGiniImpurity(double[] totalCounts, double[] positiveCounts, int kBEPPConstant, boolean unbiasedEstimate) {
        int i;
        double score = 0.0;
        double fullTotal = 0.0;
        for (i = 0; i < totalCounts.length; ++i) {
            fullTotal += totalCounts[i];
        }
        for (i = 0; i < totalCounts.length; ++i) {
            double beppScore = BEPP.GetBEPP(totalCounts[i], positiveCounts[i], kBEPPConstant, unbiasedEstimate);
            double gini = beppScore * (1.0 - beppScore);
            score += gini * totalCounts[i] / fullTotal;
        }
        return score;
    }

    @Override
    public double getScore(SufficientStatistics ss, int kBEPPConstant, boolean unbiasedEstimate) {
        return 1.0 / Gini.getGiniImpurity(ss, kBEPPConstant, unbiasedEstimate);
    }

    @Override
    public double getScore(double[] totalCounts, double[] positiveCounts, int kBEPPConstant, boolean unbiasedEstimate) {
        return 1.0 / Gini.getGiniImpurity(totalCounts, positiveCounts, kBEPPConstant, unbiasedEstimate);
    }
}

