/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi.miti;

import weka.classifiers.mi.miti.BEPP;
import weka.classifiers.mi.miti.IBestSplitMeasure;
import weka.classifiers.mi.miti.SufficientStatistics;

public class MaxBEPP
implements IBestSplitMeasure {
    public static double getMaxBEPP(SufficientStatistics ss, int kBEPPConstant, boolean unbiasedEstimate) {
        double leftBEPP = BEPP.GetLeftBEPP(ss, kBEPPConstant, unbiasedEstimate);
        double rightBEPP = BEPP.GetRightBEPP(ss, kBEPPConstant, unbiasedEstimate);
        return Math.max(leftBEPP, rightBEPP);
    }

    public static double getMaxBEPP(double[] totalCounts, double[] positiveCounts, int kBEPPConstant, boolean unbiasedEstimate) {
        double max = 0.0;
        for (int i = 0; i < totalCounts.length; ++i) {
            double bepp = BEPP.GetBEPP(totalCounts[i], positiveCounts[i], kBEPPConstant, unbiasedEstimate);
            if (!(bepp > max)) continue;
            max = bepp;
        }
        return max;
    }

    @Override
    public double getScore(SufficientStatistics ss, int kBEPPConstant, boolean unbiasedEstimate) {
        return MaxBEPP.getMaxBEPP(ss, kBEPPConstant, unbiasedEstimate);
    }

    @Override
    public double getScore(double[] totalCounts, double[] positiveCounts, int kBEPPConstant, boolean unbiasedEstimate) {
        return MaxBEPP.getMaxBEPP(totalCounts, positiveCounts, kBEPPConstant, unbiasedEstimate);
    }
}

