/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi.miti;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import weka.classifiers.mi.miti.AlgorithmConfiguration;
import weka.classifiers.mi.miti.Bag;
import weka.classifiers.mi.miti.Gini;
import weka.classifiers.mi.miti.IBestSplitMeasure;
import weka.classifiers.mi.miti.MaxBEPP;
import weka.classifiers.mi.miti.SSBEPP;
import weka.classifiers.mi.miti.SufficientBagStatistics;
import weka.classifiers.mi.miti.SufficientInstanceStatistics;
import weka.classifiers.mi.miti.SufficientStatistics;
import weka.core.Attribute;
import weka.core.Instance;

public class Split
implements Serializable {
    private static final long serialVersionUID = 147371323803237346L;
    public Attribute attribute;
    public double splitPoint;
    public double score;
    public boolean isNominal = false;

    public static Split getBestSplitPoint(final Attribute a, ArrayList<Instance> enabled, HashMap<Instance, Bag> instanceBags, AlgorithmConfiguration settings) {
        IBestSplitMeasure bsm = settings.method == 1 ? new Gini() : (settings.method == 3 ? new SSBEPP() : new MaxBEPP());
        if (a.isNominal()) {
            return Split.getBestNominalSplitPoint(a, enabled, instanceBags, settings, bsm);
        }
        Collections.sort(enabled, new Comparator<Instance>(){

            @Override
            public int compare(Instance arg0, Instance arg1) {
                return Double.compare(arg0.value(a), arg1.value(a));
            }
        });
        Split split = null;
        SufficientStatistics ss = !settings.useBagStatistics ? new SufficientInstanceStatistics(enabled, instanceBags) : new SufficientBagStatistics(enabled, instanceBags, settings.bagCountMultiplier);
        for (int i = 0; i < enabled.size() - 1; ++i) {
            ss.updateStats(enabled.get(i), instanceBags);
            if (enabled.get(i).value(a) == enabled.get(i + 1).value(a)) continue;
            double splitPoint = (enabled.get(i).value(a) + enabled.get(i + 1).value(a)) / 2.0;
            double score = bsm.getScore(ss, settings.kBEPPConstant, settings.unbiasedEstimate);
            if (split == null) {
                split = new Split();
                split.attribute = a;
                split.score = score;
                split.splitPoint = splitPoint;
                continue;
            }
            if (!(score > split.score)) continue;
            split.score = score;
            split.splitPoint = splitPoint;
        }
        return split;
    }

    private static Split getBestNominalSplitPoint(Attribute a, ArrayList<Instance> enabled, HashMap<Instance, Bag> instanceBags, AlgorithmConfiguration settings, IBestSplitMeasure bsm) {
        int i;
        Split s = new Split();
        s.isNominal = true;
        s.attribute = a;
        SufficientStatistics[] ss = new SufficientStatistics[a.numValues()];
        if (!settings.useBagStatistics) {
            for (i = 0; i < a.numValues(); ++i) {
                ss[i] = new SufficientInstanceStatistics(enabled, instanceBags);
            }
        } else {
            for (i = 0; i < a.numValues(); ++i) {
                ss[i] = new SufficientBagStatistics(enabled, instanceBags, settings.bagCountMultiplier);
            }
        }
        for (Instance i2 : enabled) {
            ss[(int)i2.value(a)].updateStats(i2, instanceBags);
        }
        double[] totals = new double[a.numValues()];
        double[] positiveCounts = new double[a.numValues()];
        for (int i3 = 0; i3 < a.numValues(); ++i3) {
            totals[i3] = ss[i3].totalCountLeft();
            positiveCounts[i3] = ss[i3].positiveCountLeft();
        }
        s.score = bsm.getScore(totals, positiveCounts, settings.kBEPPConstant, settings.unbiasedEstimate);
        return s;
    }
}

