/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi.miti;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weka.classifiers.mi.miti.Bag;
import weka.classifiers.mi.miti.SufficientStatistics;
import weka.core.Instance;

public class SufficientBagStatistics
implements SufficientStatistics {
    private HashMap<Bag, Integer> leftPositiveBags;
    private HashMap<Bag, Integer> rightPositiveBags;
    private HashMap<Bag, Integer> leftTotalBags;
    private HashMap<Bag, Integer> rightTotalBags;
    private double m_instanceConstant;
    private double positiveCountLeft;
    private double totalCountLeft;
    private double positiveCountRight;
    private double totalCountRight;

    public SufficientBagStatistics(List<Instance> allInstances, HashMap<Instance, Bag> instanceBags, double instanceConstant) {
        this.m_instanceConstant = instanceConstant;
        this.leftPositiveBags = new HashMap();
        this.rightPositiveBags = new HashMap();
        this.leftTotalBags = new HashMap();
        this.rightTotalBags = new HashMap();
        for (Instance instance : allInstances) {
            Bag bag = instanceBags.get(instance);
            if (bag.isPositive()) {
                if (this.rightPositiveBags.containsKey(bag)) {
                    this.rightPositiveBags.put(bag, this.rightPositiveBags.get(bag) + 1);
                } else {
                    this.rightPositiveBags.put(bag, 1);
                }
            }
            if (this.rightTotalBags.containsKey(bag)) {
                this.rightTotalBags.put(bag, this.rightTotalBags.get(bag) + 1);
                continue;
            }
            this.rightTotalBags.put(bag, 1);
        }
        this.totalCountRight = 0.0;
        this.positiveCountRight = 0.0;
        for (Map.Entry entry : this.rightTotalBags.entrySet()) {
            double weight = 1.0 - Math.pow(instanceConstant, ((Integer)entry.getValue()).intValue());
            if (((Bag)entry.getKey()).isPositive()) {
                this.positiveCountRight += weight;
            }
            this.totalCountRight += weight;
        }
        this.totalCountLeft = 0.0;
        this.positiveCountLeft = 0.0;
    }

    @Override
    public void updateStats(Instance i, HashMap<Instance, Bag> instanceBags) {
        Bag bag = instanceBags.get(i);
        boolean positive = bag.isPositive();
        double prob = this.m_instanceConstant;
        if (positive) {
            int countRP = this.rightPositiveBags.get(bag);
            this.positiveCountRight += Math.pow(prob, countRP - 1) * (prob - 1.0);
            this.rightPositiveBags.put(bag, countRP - 1);
            if (this.leftPositiveBags.containsKey(bag)) {
                int countLP = this.leftPositiveBags.get(bag);
                this.positiveCountLeft += Math.pow(prob, countLP) * (1.0 - prob);
                this.leftPositiveBags.put(bag, countLP + 1);
            } else {
                this.leftPositiveBags.put(bag, 1);
                this.positiveCountLeft += 1.0 - prob;
            }
        }
        int countRT = this.rightTotalBags.get(bag);
        this.totalCountRight += Math.pow(prob, countRT - 1) * (prob - 1.0);
        this.rightTotalBags.put(bag, countRT - 1);
        if (this.leftTotalBags.containsKey(bag)) {
            int countLT = this.leftTotalBags.get(bag);
            this.totalCountLeft += Math.pow(prob, countLT) * (1.0 - prob);
            this.leftTotalBags.put(bag, countLT + 1);
        } else {
            this.leftTotalBags.put(bag, 1);
            this.totalCountLeft += 1.0 - prob;
        }
    }

    @Override
    public double positiveCountLeft() {
        return this.positiveCountLeft;
    }

    @Override
    public double positiveCountRight() {
        return this.positiveCountRight;
    }

    @Override
    public double totalCountLeft() {
        return this.totalCountLeft;
    }

    @Override
    public double totalCountRight() {
        return this.totalCountRight;
    }
}

