/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi.miti;

import java.util.HashMap;
import java.util.List;
import weka.classifiers.mi.miti.Bag;
import weka.classifiers.mi.miti.SufficientStatistics;
import weka.core.Instance;

public class SufficientInstanceStatistics
implements SufficientStatistics {
    private double positiveInstancesLeft = 0.0;
    private double totalInstancesLeft = 0.0;
    private double positiveInstancesRight = 0.0;
    private double totalInstancesRight = 0.0;

    public SufficientInstanceStatistics(List<Instance> allInstances, HashMap<Instance, Bag> instanceBags) {
        for (Instance i : allInstances) {
            Bag bag = instanceBags.get(i);
            if (bag.isPositive()) {
                this.positiveInstancesRight += bag.bagWeight();
            }
            this.totalInstancesRight += bag.bagWeight();
        }
    }

    @Override
    public void updateStats(Instance i, HashMap<Instance, Bag> instanceBags) {
        Bag bag = instanceBags.get(i);
        boolean positive = bag.isPositive();
        if (positive) {
            this.positiveInstancesRight -= bag.bagWeight();
            this.positiveInstancesLeft += bag.bagWeight();
        }
        this.totalInstancesLeft += bag.bagWeight();
        this.totalInstancesRight -= bag.bagWeight();
    }

    @Override
    public double positiveCountLeft() {
        return this.positiveInstancesLeft;
    }

    @Override
    public double positiveCountRight() {
        return this.positiveInstancesRight;
    }

    @Override
    public double totalCountLeft() {
        return this.totalInstancesLeft;
    }

    @Override
    public double totalCountRight() {
        return this.totalInstancesRight;
    }
}

