/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.mi.miti;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import weka.classifiers.mi.miti.AlgorithmConfiguration;
import weka.classifiers.mi.miti.BEPP;
import weka.classifiers.mi.miti.Bag;
import weka.classifiers.mi.miti.NextSplitHeuristic;
import weka.classifiers.mi.miti.Split;
import weka.classifiers.mi.miti.SufficientBagStatistics;
import weka.classifiers.mi.miti.SufficientInstanceStatistics;
import weka.classifiers.mi.miti.SufficientStatistics;
import weka.core.Attribute;
import weka.core.Instance;

public class TreeNode
implements Serializable {
    private static final long serialVersionUID = 9050803921532593168L;
    private ArrayList<Instance> instances;
    private double nodeScore;
    private boolean leafNode;
    private boolean positiveLeaf;
    private TreeNode parent = null;
    private TreeNode left = null;
    private TreeNode right = null;
    private TreeNode[] nominalNodes = null;
    public Split split;

    public TreeNode(TreeNode parent, ArrayList<Instance> instances) {
        this.parent = parent;
        this.instances = instances;
    }

    public double nodeScore() {
        return this.nodeScore;
    }

    public void removeDeactivatedInstances(HashMap<Instance, Bag> instanceBags) {
        ArrayList<Instance> newInstances = new ArrayList<Instance>();
        for (Instance i : this.instances) {
            if (!instanceBags.get(i).isEnabled()) continue;
            newInstances.add(i);
        }
        this.instances = newInstances;
    }

    public void calculateNodeScore(HashMap<Instance, Bag> instanceBags, boolean unbiasedEstimate, int kBEPPConstant, boolean bagCount, double multiplier) {
        this.nodeScore = NextSplitHeuristic.getBepp(this.instances, instanceBags, unbiasedEstimate, kBEPPConstant, bagCount, multiplier);
    }

    public boolean isLeafNode() {
        return this.leafNode;
    }

    public boolean isPositiveLeaf() {
        return this.positiveLeaf;
    }

    public boolean isPureNegative(HashMap<Instance, Bag> instanceBags) {
        for (Instance i : this.instances) {
            Bag bag = instanceBags.get(i);
            if (!bag.isEnabled() || !bag.isPositive()) continue;
            return false;
        }
        return true;
    }

    public boolean isPurePositive(HashMap<Instance, Bag> instanceBags) {
        for (Instance i : this.instances) {
            Bag bag = instanceBags.get(i);
            if (!bag.isEnabled() || bag.isPositive()) continue;
            return false;
        }
        return true;
    }

    public void makeLeafNode(boolean positiveLeaf) {
        this.leafNode = true;
        this.positiveLeaf = positiveLeaf;
    }

    public TreeNode parent() {
        return this.parent;
    }

    public TreeNode left() {
        return this.left;
    }

    public TreeNode right() {
        return this.right;
    }

    public TreeNode[] nominals() {
        return this.nominalNodes;
    }

    public void deactivateRelatedInstances(HashMap<Instance, Bag> instanceBags, List<String> deactivated) {
        for (Instance i : this.instances) {
            Bag container = instanceBags.get(i);
            container.disableInstances(deactivated);
        }
    }

    private boolean hasSplitOnAttributePreviously(Attribute a) {
        TreeNode n = this;
        while (n != null) {
            if (n.split != null && n.split.attribute.equals((Object)a)) {
                return true;
            }
            n = n.parent;
        }
        return false;
    }

    public void splitInstances(HashMap<Instance, Bag> instanceBags, AlgorithmConfiguration settings, Random rand, boolean debug) {
        Attribute splittingAttribute;
        ArrayList<Instance> enabled = this.instances;
        int totalAttributes = this.instances.get(0).numAttributes();
        Instance template = this.instances.get(0);
        List<Object> attributes = new ArrayList<Attribute>();
        block0: for (int index = 0; index < totalAttributes; ++index) {
            double val = template.value(index);
            for (Instance i : this.instances) {
                if (i.value(index) == val) continue;
                attributes.add(template.attribute(index));
                continue block0;
            }
        }
        int attributesToSplit = settings.attributesToSplit;
        if (settings.attributesToSplit == -1) {
            attributesToSplit = totalAttributes;
        }
        if (settings.attributesToSplit == -2) {
            attributesToSplit = (int)Math.sqrt(totalAttributes) + 1;
        }
        if (attributesToSplit < attributes.size()) {
            Collections.shuffle(attributes, rand);
            attributes = attributes.subList(0, attributesToSplit);
        }
        ArrayList<Split> best = new ArrayList<Split>();
        for (Attribute a : attributes) {
            Split splitPoint;
            if (a.isNominal() && this.hasSplitOnAttributePreviously(a) || (splitPoint = Split.getBestSplitPoint(a, enabled, instanceBags, settings)) == null) continue;
            if (debug) {
                System.out.println(a.name() + " scored " + splitPoint.score);
            }
            best.add(splitPoint);
        }
        if (best.size() == 0) {
            this.makeImpureLeafNode(instanceBags, settings, debug);
            return;
        }
        Collections.sort(best, new Comparator<Split>(){

            @Override
            public int compare(Split o1, Split o2) {
                return Double.compare(o2.score, o1.score);
            }
        });
        int attributeSplitChoices = settings.attributeSplitChoices;
        if (settings.attributeSplitChoices == -1) {
            attributeSplitChoices = best.size();
        } else if (settings.attributeSplitChoices == -2) {
            attributeSplitChoices = (int)Math.sqrt(best.size()) + 1;
        }
        int pick = rand.nextInt(Math.min(attributeSplitChoices, best.size()));
        this.split = (Split)best.get(pick);
        if (debug) {
            System.out.println("Selected best is " + this.split.attribute.name());
        }
        if ((splittingAttribute = this.split.attribute).isNominal()) {
            int numNominalValues = splittingAttribute.numValues();
            this.nominalNodes = new TreeNode[numNominalValues];
            for (int i = 0; i < numNominalValues; ++i) {
                ArrayList<Instance> list = new ArrayList<Instance>();
                for (Instance instance : enabled) {
                    if (instance.value(splittingAttribute) != (double)i) continue;
                    list.add(instance);
                }
                this.nominalNodes[i] = new TreeNode(this, list);
            }
        } else {
            ArrayList<Instance> left = new ArrayList<Instance>();
            ArrayList<Instance> right = new ArrayList<Instance>();
            for (Instance instance : enabled) {
                if (instance.value(splittingAttribute) < this.split.splitPoint) {
                    left.add(instance);
                    continue;
                }
                right.add(instance);
            }
            this.left = new TreeNode(this, left);
            this.right = new TreeNode(this, right);
            if (debug) {
                System.out.println(left.size() + " went left and " + right.size() + " went right");
            }
        }
    }

    private void makeImpureLeafNode(HashMap<Instance, Bag> instanceBags, AlgorithmConfiguration settings, boolean debug) {
        SufficientStatistics ss = !settings.useBagStatistics ? new SufficientInstanceStatistics(this.instances, instanceBags) : new SufficientBagStatistics(this.instances, instanceBags, settings.bagCountMultiplier);
        double bepp = BEPP.GetBEPP(ss.totalCountRight(), ss.positiveCountRight(), settings.kBEPPConstant, settings.unbiasedEstimate);
        this.makeLeafNode(ss.positiveCountRight() / ss.totalCountRight() > 0.5);
        if (debug) {
            System.out.println(bepp > 0.5);
        }
        if (!this.isPositiveLeaf()) {
            return;
        }
        ArrayList<String> deactivated = new ArrayList<String>();
        this.deactivateRelatedInstances(instanceBags, deactivated);
        if (deactivated.size() > 0 && debug) {
            Bag.printDeactivatedInstances(deactivated);
        }
    }

    public String render(int depth, HashMap<Instance, Bag> instanceBags) {
        String s = "";
        int pos = 0;
        for (Instance i : this.instances) {
            Bag bag = instanceBags.get(i);
            if (!bag.isPositive()) continue;
            ++pos;
        }
        s = s + this.instances.size() + " [" + pos + " / " + (this.instances.size() - pos) + "]";
        if (this.isLeafNode()) {
            s = s + (this.isPositiveLeaf() ? " (+)" : " (-)");
        }
        if (!this.isLeafNode() && this.split != null) {
            if (this.split.attribute.isNominal()) {
                for (int i = 0; i < this.nominalNodes.length; ++i) {
                    if (this.nominalNodes[i] == null) continue;
                    s = s + "\n";
                    for (int t = 0; t < depth; ++t) {
                        s = s + "|\t";
                    }
                    s = s + this.split.attribute.name() + " = " + this.split.attribute.value(i) + " : ";
                    s = s + this.nominalNodes[i].render(depth + 1, instanceBags);
                }
            } else {
                if (this.left != null) {
                    s = s + "\n";
                    for (int i = 0; i < depth; ++i) {
                        s = s + "|\t";
                    }
                    s = s + this.split.attribute.name() + " <= " + String.format("%.4g", this.split.splitPoint) + " : ";
                    s = s + this.left.render(depth + 1, instanceBags);
                }
                if (this.right != null) {
                    s = s + "\n";
                    for (int i = 0; i < depth; ++i) {
                        s = s + "|\t";
                    }
                    s = s + this.split.attribute.name() + " > " + String.format("%.4g", this.split.splitPoint) + " : ";
                    s = s + this.right.render(depth + 1, instanceBags);
                }
            }
        }
        return s;
    }

    public boolean trimNegativeBranches() {
        boolean positive = false;
        if (this.nominalNodes != null) {
            for (int i = 0; i < this.nominalNodes.length; ++i) {
                TreeNode child = this.nominalNodes[i];
                if (child.isPositiveLeaf()) {
                    positive = true;
                    continue;
                }
                if (child.trimNegativeBranches()) {
                    positive = true;
                    continue;
                }
                this.nominalNodes[i] = null;
            }
        } else {
            if (this.left != null) {
                if (this.left.isPositiveLeaf()) {
                    positive = true;
                } else if (this.left.trimNegativeBranches()) {
                    positive = true;
                } else {
                    this.left = null;
                }
            }
            if (this.right != null) {
                if (this.right.isPositiveLeaf()) {
                    positive = true;
                } else if (this.right.trimNegativeBranches()) {
                    positive = true;
                } else {
                    this.right = null;
                }
            }
        }
        return positive;
    }
}

