/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 *    IterativeHMMClassifier.java
 *    Copyright (C) 2011 University of Waikato, Hamilton, NZ
 *
 */

package weka.classifiers.meta;

import weka.classifiers.Classifier;
import weka.classifiers.sequence.IterativeSequenceLearner;
import weka.core.OptionHandler;
import weka.core.Randomizable;

/**
 * Interface for iterative HMM schemes.
 *
 * @author FracPete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 10 $
 */
public interface IterativeHMMClassifier<T extends IterativeSequenceLearner>
  extends Classifier, OptionHandler, Randomizable {

	public int getActualFold();

	public void setActualFold(int actualFold);

	public int getNumberOfFolds();

	public void setNumberOfFolds(int numberOfFolds);

	public void setSequenceLearner(T hmm);

	public T getSequenceLearner();

	public String sequenceLearnerTipText();

	public boolean getReUse();

	public void setReUse(boolean flag);

	public String reUseTipText();

	public int getIterationStepSize();

	public void setIterationStepSize(int iterationStepSize);

	public boolean hmmsConverged();

	public int getIterationCount();
}
