/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 *    IterativeSequenceLearner.java
 *    Copyright (C) 2010 Stefan Mutter
 *
 */
package weka.classifiers.sequence;

import weka.core.Instances;

/**
<!-- globalinfo-start -->
* abstract class that introduces the three main methods for iterative learning that can be evaluated after each training iteration: initialise, next iteration and check for convergence.
* <p/>
<!-- globalinfo-end -->
*
*
* @author Stefan Mutter (pHMM4weka@gmail.com)
* @version $Revision: 6 $
*/
public abstract class IterativeSequenceLearner extends SequenceLearner {

  public abstract void initClassifier(Instances data) throws Exception;

  public abstract void next(int iteration) throws Exception;

  public abstract boolean fullyConverged();

}
