/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 *    Alphabet.java
 *    Copyright (C) 2010 Stefan Mutter
 *
 */
package weka.classifiers.sequence.core;

import java.io.Serializable;

/**
<!-- globalinfo-start -->
* abstract class to represent an alphabet made out of characters or strings of length one.
* Note when implementing a specific alphabet '#' is used as a special character and cannot be used in the alphabet.
<!-- globalinfo-end -->
* 
* @author Stefan Mutter (pHMM4weka@gmail.com)
* @version $Revision: 4 $
*/
public abstract class Alphabet implements Serializable{

  /**
 * @param symbol a string representing a symbol of the alphabet
 * @return the index of the symbol as an int
 * @throws IllegalSymbolException if symbol is not part of the alphabet
 */
public abstract int indexOfAlphabetSymbol(String symbol) throws IllegalSymbolException;
  
  /**
 * returns a string representing the symbol at index index of the alphabet
 * @param index the index of the symbol in the alphabet
 * @return string representing the symbol of the alphabet at the specific index
 */
public abstract String getSymbolAtIndex(int index);
  
  /**
 * @return int size of the alphabet
 */
public abstract int alphabetSize();
  
 /**
 * @return string containing all elements of the alphabet
 */
public abstract String toString();
  
}
