/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 *    BaumWelchTransition.java
 *    Copyright (C) 2010 Stefan Mutter
 *
 */
package weka.classifiers.sequence.core;

import java.io.Serializable;

/**
<!-- globalinfo-start -->
* transisitions used in PHMMs trained with the Baum-Welch learning algorithm. They can count the number of times they have been used during training.
<!-- globalinfo-end -->
* 
* @author Stefan Mutter (pHMM4weka@gmail.com)
* @version $Revision: 4 $
*/
public class BaumWelchTransition implements Serializable, Transition{

  private static final long serialVersionUID = 6451290502090237197L;

  private double probability;
  
  private double expectationLogCount;
  
  private State start;
  
  private State end;
  
  public BaumWelchTransition(State start, State end) {
    super();
    this.start = start;
    this.end = end;
    this.probability = 0.0;
    this.expectationLogCount = Double.NEGATIVE_INFINITY;
  }
  

  public BaumWelchTransition(double probability, State start, State end) {
    super();
    this.probability = probability;
    this.start = start;
    this.end = end;
    this.expectationLogCount = Double.NEGATIVE_INFINITY;
  }


  

  /* (non-Javadoc)
   * @see weka.classifiers.sequence.core.Transition#getEnd()
   */
  public State getEnd() {
    return end;
  }

  /* (non-Javadoc)
   * @see weka.classifiers.sequence.core.Transition#setEnd(weka.classifiers.sequence.core.State)
   */
  public void setEnd(State end) {
    this.end = end;
  }

  /* (non-Javadoc)
   * @see weka.classifiers.sequence.core.Transition#getProbability()
   */
  public double getProbability() {
    return probability;
  }

  /* (non-Javadoc)
   * @see weka.classifiers.sequence.core.Transition#setProbability(double)
   */
  public void setProbability(double probability) {
    this.probability = probability;
  }

  /* (non-Javadoc)
   * @see weka.classifiers.sequence.core.Transition#getStart()
   */
  public State getStart() {
    return start;
  }

  /* (non-Javadoc)
   * @see weka.classifiers.sequence.core.Transition#setStart(weka.classifiers.sequence.core.State)
   */
  public void setStart(State start) {
    this.start = start;
  }
  
  /* (non-Javadoc)
   * @see weka.classifiers.sequence.core.Transition#equals(weka.classifiers.sequence.core.HMMTransition)
   */
  public boolean equals(Transition toCompare){
    if(this.probability != toCompare.getProbability())
      return false;
    if(!this.start.equals(toCompare.getStart()))
      return false;
    if(!this.end.equals(toCompare.getEnd()))
      return false;
    return true;
  }
  
  /* (non-Javadoc)
   * @see weka.classifiers.sequence.core.Transition#toString()
   */
  public String toString(){
    return start.getFullNameId()+"-"+end.getFullNameId()+" ("+probability+")";
  }


  public double getExpectationLogCount() {
    return expectationLogCount;
  }


  public void setExpectationLogCount(double expectationLogCount) {
    this.expectationLogCount = expectationLogCount;
  }
  
}
