/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 *    DeleteState.java
 *    Copyright (C) 2010 Stefan Mutter
 *
 */

package weka.classifiers.sequence.core;

import java.util.Vector;

/**
<!-- globalinfo-start -->
* models a delete state in a PHMM. Delete states are silent i.e. have no emission
<!-- globalinfo-end -->
* 
* @author Stefan Mutter (pHMM4weka@gmail.com)
* @version $Revision: 4 $
*/
public class DeleteState extends State {

  private static final long serialVersionUID = -6569520580644186467L;

  public DeleteState(String name, int id) {
    this.name = name;
    this.id = id;
    this.incoming = new Vector<Transition>();
    this.outgoing = new Vector<Transition>();
  }
}
