/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 *    EmissionState.java
 *    Copyright (C) 2010 Stefan Mutter
 *
 */
package weka.classifiers.sequence.core;

import java.util.Vector;
/**
<!-- globalinfo-start -->
* models a standard state in a (P)HMM. EmissionStates emit symbols. In PHMMs they are match or insert states
<!-- globalinfo-end -->
* 
* @author Stefan Mutter (pHMM4weka@gmail.com)
* @version $Revision: 4 $
*/
public class EmissionState extends State {
 
  private static final long serialVersionUID = -5075868906426660915L;

  private Alphabet emissionAlphabet;
  
  private Distribution dist;
  
  /**
 * construct an emission state
 * @param name
 * @param id
 * @param alpha emission alphabet
 * @param dist emission probabilities for all alphabet's symbols
 */
public EmissionState(String name, int id, Alphabet alpha, Distribution dist) {
    this.name = name;
    this.id = id;
    this.incoming = new Vector<Transition>();
    this.outgoing = new Vector<Transition>();
    this.emissionAlphabet = alpha;
    this.dist = dist;
  }

  public double getEmissionProbability(String symbol) throws IllegalSymbolException {
    return dist.getProb(symbol);
  }
  
  public Alphabet getAlphabet(){
    return emissionAlphabet;
  }
  
  public void setDistribution(Distribution dist){
    this.dist = dist;
  }
  
  public String outputEmissionInformation(){
    StringBuffer output = new StringBuffer();
    output.append(this.getFullNameId()+" emits: ");
    output.append(dist.toString()+"\n");
    return output.toString();
  }

  public Distribution getDistribution() {
    return dist;
  }

}
