/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 *    ExtendedProteinAlphabet.java
 *    Copyright (C) 2010 Stefan Mutter
 *
 */
package weka.classifiers.sequence.core;

/**
<!-- globalinfo-start -->
* extended protein alphabet that contains the standard 20 amino acids and the symbols B,Z,U and X
<!-- globalinfo-end -->
* 
* @author Stefan Mutter (pHMM4weka@gmail.com)
* @version $Revision: 4 $
*/
public class ExtendedProteinAlphabet extends Alphabet {

  private static final long serialVersionUID = 3357731593569839979L;


  public int alphabetSize() {
    return 24;
  }


  /** 
 * @param symbolString string of length 1 containing one symbol
 * @return the index of the symbol
 * @see weka.classifiers.sequence.core.Alphabet#indexOfAlphabetSymbol(java.lang.String)
 */
public int indexOfAlphabetSymbol(String symbolString) throws IllegalSymbolException {
    //for speed reasons char is used
	char symbol = symbolString.charAt(0);
    int incorrectIndex = (symbol - '0')-17;
    //System.out.println(incorrectIndex);
    if(incorrectIndex < 0 || incorrectIndex > 25 || incorrectIndex == 9 || incorrectIndex == 14){
      throw new IllegalSymbolException("Letter not in alphabet: "+symbolString+" "+incorrectIndex);
    }
    int indexValue = this.getCorrectedIndex(incorrectIndex);
    return indexValue;
  }


  public String toString() {
    String output = "";
    for(int i = 0; i<this.alphabetSize();i++){
      if(i >0){
	output+=" ";
      }
      output+= this.getCorrectedSymbol(i)+"";
    }
    return output;
  }



  public String getSymbolAtIndex(int index) {
    return this.getCorrectedSymbol(index)+"";
  }

  private int getCorrectedIndex(int incorrectIndex){

    if(incorrectIndex < 9){
      return incorrectIndex;
    }
    else{
      if(incorrectIndex < 14){
	return incorrectIndex -1;
      }
      else{
	return incorrectIndex -2;
      }
    }
  }

  private char getCorrectedSymbol(int incorrectIndex){
    int correctIndex = (incorrectIndex+17)+'0';
    if(incorrectIndex < 9){
      return (char)correctIndex;
    }
    else{
      if(incorrectIndex < 13){
	return (char)(correctIndex+1);
      }
      else{
	return (char)(correctIndex +2);
      }
    }
  }

}