/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 *    NullModel.java
 *    Copyright (C) 2010 Stefan Mutter
 *
 */
package weka.classifiers.sequence.core;

import java.io.Serializable;

/**
<!-- globalinfo-start -->
a simple null model class that has a the same probability for each symbol in the alphabet
<!-- globalinfo-end -->
* 
* @author Stefan Mutter (pHMM4weka@gmail.com)
* @version $Revision: 4 $
*/
public class NullModel implements Serializable{

  private static final long serialVersionUID = 762092440133274882L;
  
  protected boolean useLogSpace;

  protected Distribution distribution;

  /**
 * constructs a null model with a uniform probability distribution over the alphabet's symbols
 * @param useLogSpace
 * @param alphabet
 */
public NullModel(boolean useLogSpace, Alphabet alphabet){
    this.useLogSpace = useLogSpace;
    distribution = new UniformDistribution(alphabet,useLogSpace);
  }

  public double getNullModelEmissionProbability(String s) throws IllegalSymbolException{    
   return distribution.getProb(s);
  }


  public boolean isUseLogSpace() {
    return useLogSpace;
  }


}
