/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 *    RandomDistribution.java
 *    Copyright (C) 2010 Stefan Mutter
 *
 */
package weka.classifiers.sequence.core;

import java.util.Random;

import weka.core.Utils;

/**
<!-- globalinfo-start -->
* generates random probabilities that sum up to one depending on seed (default seed = 0)
<!-- globalinfo-end -->
* 
* @author Stefan Mutter (pHMM4weka@gmail.com)
* @version $Revision: 4 $
*/
public class RandomDistribution extends StaticDistribution {

  private static final long serialVersionUID = 2030604510757664934L;
  
  private int seed;

  /**
 * Constructs a random distribution with seed = 0
 * @param alpha
 * @param useLogSpace
 */
public RandomDistribution(Alphabet alpha, boolean useLogSpace) {
    super(alpha, useLogSpace);
    this.seed = 0;
    generateRandomDistribution(useLogSpace);
  }
  
  /**
 * constructs a random distribution with user specific seed
 * @param alpha
 * @param useLogSpace
 * @param seed
 */
public RandomDistribution(Alphabet alpha, boolean useLogSpace, int seed) {
    super(alpha, useLogSpace);
    this.seed = seed;
    generateRandomDistribution(useLogSpace);
  }

  /**
 * generates and normalises randomly created probabilities for each symbol in the alphabet
 * @param useLogSpace
 */
private void generateRandomDistribution(boolean useLogSpace) {
    Random rand = new Random(seed);
    for(int i = 0 ; i < probs.length; i++){
      probs[i] = rand.nextDouble();
    }
    Utils.normalize(probs);
    if(useLogSpace){
      for(int i = 0;i < probs.length;i++){
	if(probs[i] != 0.0){
	  if(probs[i] == 1.0){
	    probs[i] = 0.0;
	  }
	  else{
	    probs[i] = Math.log(probs[i]);
	  }
	}
	else{
	  probs[i] = Double.NEGATIVE_INFINITY;
	}
      }
    }
  }
  
  
  public int getSeed(){
    return seed;
  }

}
