/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 *    SimpleDistribution.java
 *    Copyright (C) 2010 Stefan Mutter
 *
 */
package weka.classifiers.sequence.core;

/**
<!-- globalinfo-start -->
* simple distribution class that allows to re-set the probabilities for all symbols at once. 
<!-- globalinfo-end -->
* 
* @author Stefan Mutter (pHMM4weka@gmail.com)
* @version $Revision: 4 $
*/
public class SimpleDistribution extends ChangeableDistribution {

  private static final long serialVersionUID = 249106366796698048L;

  public SimpleDistribution(Alphabet alpha, boolean useLogSpace) {
    super(alpha,useLogSpace);
  }
  
  /**
 * sets probabilities for each symbol in the alphabet. Note you must know the indeces of the symbol correctly. Probabilities are normalised afterwards
 * @param probArray 
 * @throws NumericStabilityException
 */
public void setProbWithArray(double[] probArray) throws NumericStabilityException{
    probs = probArray;
    super.adjust();
  }

}
