/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 *    StateAlphabet.java
 *    Copyright (C) 2010 Stefan Mutter
 *
 */
package weka.classifiers.sequence.core;

import java.util.HashMap;

/**
 * @author Stefan Mutter (pHMM4weka@gmail.com)
 * @version $Revision: 4 $
 *
 */
public class StateAlphabet extends Alphabet {

  private static final long serialVersionUID = -206088204295687496L;
  private HashMap alphabet;

  public StateAlphabet(){
    alphabet = new HashMap();
  }

  public int alphabetSize() {
    return alphabet.size();
  }
  
  public String getSymbolAtIndex(int index){
    return null;
  }

  public void add(State state){
    if(!contains(state))
      alphabet.put(state.getFullNameId(), state);
  }

  public void remove(State state){
    if(contains(state))
      alphabet.remove(state.getFullNameId());
  }

  public boolean contains(State state){
    return alphabet.containsKey(state.getFullNameId());
  }

  @Override
  public int indexOfAlphabetSymbol(String symbol) throws IllegalSymbolException {
    // TODO Auto-generated method stub
    return 0;
  }

  @Override
  public String toString() {
    // TODO Auto-generated method stub
    return null;
  }

}
