/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 *    UniformDistribution.java
 *    Copyright (C) 2010 Stefan Mutter
 *
 */
package weka.classifiers.sequence.core;

/**
<!-- globalinfo-start -->
* distribution that initialises the probabilities (or their log scores) uniformly. They cannot be changed.
<!-- globalinfo-end -->
* 
* @author Stefan Mutter (pHMM4weka@gmail.com)
* @version $Revision: 4 $
*/
public class UniformDistribution extends StaticDistribution {

  private static final long serialVersionUID = -8254242177759282786L;

  public UniformDistribution(Alphabet alpha, boolean useLogSpace){
    super(alpha, useLogSpace);
    for(int i = 0;i < probs.length;i++){
      probs[i] = 1.0/alphabet.alphabetSize();
    }
    if(useLogSpace){
      for(int i = 0;i < probs.length;i++){
	if(probs[i] != 0.0){
	  if(probs[i] == 1.0){
	    probs[i] = 0.0;
	  }
	  else{
	    probs[i] = Math.log(probs[i]);
	  }
	}
	else{
	  probs[i] = Double.NEGATIVE_INFINITY;
	}
      }
    }
  }

}
