/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 *    ViterbiBacktrackObject.java
 *    Copyright (C) 2010 Stefan Mutter
 *
 */
package weka.classifiers.sequence.core;

import java.io.Serializable;

/**
<!-- globalinfo-start -->
* class providing objects to store pointers to trace back the Viterbi path from its calculation.
* an object has a state and a position in the sequence
<!-- globalinfo-end -->
* 
* @author Stefan Mutter (pHMM4weka@gmail.com)
* @version $Revision: 4 $
*/
public class ViterbiBacktrackObject implements Serializable{
  
  private static final long serialVersionUID = 476432864973323289L;

  private State state;
  
  private int sequencePointer;

  
  /**
 * Constructor
 * @param state the state
 * @param sequencePointer the index in the sequence
 */
public ViterbiBacktrackObject(State state, int sequencePointer) {
    super();
    this.state = state;
    this.sequencePointer = sequencePointer;
  }

  public int getSequencePointer() {
    return sequencePointer;
  }

  public State getState() {
    return state;
  }

  public String getType(){
    return state.getName();
  }
  
  public int getID(){
    return state.getId();
  }

}
