/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 *    LogPathScores2Probabilities4SingleHMM.java
 *    Copyright (C) 2010 Stefan Mutter
 *
 */
package weka.filters.supervised.attribute;

import java.io.Serializable;

import weka.core.Instances;

/**
<!-- globalinfo-start -->
* transfers log-odd scores in arff files created by one-class PHMMs in mode -M 2 or -M 3 (not -M 2-3) (logarithmic representations) into the exponential representation.
* the original arff file contains the log-odd score of the one-class PHMM and the class attribute. The resulting arff file contains an exponential value and the class attribute (no normalisation possible).
* Class attribute must be the last attribute in the original file!
* <p/>
<!-- globalinfo-end -->
*
<!-- options-start -->
* no options
*
<!-- options-end -->
*
* @author Stefan Mutter (pHMM4weka@gmail.com)
* @version $Revision: 6 $
*/
public class LogPathScores2Probabilities4SingleHMM extends
    LogPathScores2Probabilities implements Serializable{

  /**
   *
   */
  private static final long serialVersionUID = 7253180653446214648L;

  public LogPathScores2Probabilities4SingleHMM(){
    super();
  }

  public String globalInfo() {
	    return   "A batch filter that converts arff files created in Mode 2 or Mode 3 (not Mode 23) to exponential values for one-class PHMMs.";
	  }


  public boolean batchFinished() throws Exception {
    if (getInputFormat() == null)
      throw new NullPointerException("No input instance format defined");

    Instances inst = getInputFormat();


    for(int i = 0; i < inst.numInstances(); i ++){
      (inst.instance(i)).setValue(0, Math.exp((inst.instance(i)).value(0)));
      push(inst.instance(i));
    }

    flushInput();
    m_NewBatch = true;
    m_FirstBatchDone = true;
    return (numPendingOutput() != 0);
  }



  /**
   * Main method for testing this class.
   *
   * @param argv
   */
  public static void main(String [] argv) {
    runFilter(new LogPathScores2Probabilities4SingleHMM(), argv);
  }



}
