/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 *    LogStatesScores2Probabilities4SingleHMM.java
 *    Copyright (C) 2010 Stefan Mutter
 *
 */
package weka.filters.supervised.attribute;

import java.io.Serializable;

import weka.core.Instances;

/**
<!-- globalinfo-start -->
* transfers log scores for each states in a one-class PHMM (mode -M 4) stored arff files into probabilities (-M 5).
* the original arff file contains the log scores of each state (except the first and last match state as their log score is always 0 and thus their probability always 1) of the one-class PHMM and the class attribute. The resulting arff file contains the normalised probabilities and the class attribute.
* Class attribute must be the last attribute in the original file!
* <p/>
<!-- globalinfo-end -->
*
<!-- options-start -->
* no options
*
<!-- options-end -->
*
* @author Stefan Mutter (pHMM4weka@gmail.com)
* @version $Revision: 6 $
*/
public class LogStatesScores2Probabilities4SingleHMM extends
    LogStatesScores2Probabilities implements Serializable{


  private static final long serialVersionUID = 7937159091234727876L;

  public LogStatesScores2Probabilities4SingleHMM(){
    super();
  }

  //one-class PHMM so there is just 1 PHMM.
  protected int determineHMMNumber(Instances instances){
    return 1;
  }

  protected int[] determineStateNumbers(Instances instances, int hmmNumber) {
    int[] maxIndex = new int[1];
    maxIndex[0] = instances.numAttributes()-2;
    return maxIndex;
  }

  /**
   * Main method for testing this class.
   *
   * @param argv
   */
  public static void main(String [] argv) {
    runFilter(new LogStatesScores2Probabilities4SingleHMM(), argv);
  }



}
