/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 *    IterativeEvaluation.java
 *    Copyright (C) 2010 Stefan Mutter
 *    Copyright (C) 2011 University of Waikato, Hamilton, NZ
 *
 */

package weka.utils;

import weka.classifiers.meta.IterativeHMMPropositionalizer;

/**
 * Simulates a 10 fold cross-validation run for IterativeHMMPropositionalizer.
 *
 * @author Stefan Mutter (pHMM4weka@gmail.com)
 * @author FracPete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 10 $
 */
public class IterativeEvaluation
  extends AbstractIterativeEvaluation<IterativeHMMPropositionalizer> {

	public static void main(String[] args) throws Exception {
		evaluate(new IterativeEvaluation(), args);
	}
}
