/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.sequence.core;

import java.util.List;
import java.util.Vector;
import weka.classifiers.sequence.core.DeleteState;
import weka.classifiers.sequence.core.DynamicProgAlgorithms;
import weka.classifiers.sequence.core.EmissionState;
import weka.classifiers.sequence.core.IllegalSymbolException;
import weka.classifiers.sequence.core.InvalidStructureException;
import weka.classifiers.sequence.core.InvalidViterbiPathException;
import weka.classifiers.sequence.core.ProfileHMM;
import weka.classifiers.sequence.core.State;
import weka.classifiers.sequence.core.ViterbiBacktrackObject;

public class ViterbiAlgorithm
extends DynamicProgAlgorithms {
    private static final long serialVersionUID = 5491459703945080087L;
    private ViterbiBacktrackObject[][] matchBacktrackPointer;
    private ViterbiBacktrackObject[][] insertBacktrackPointer;
    private ViterbiBacktrackObject[][] deleteBacktrackPointer;
    private List<State> viterbiPath = new Vector<State>();
    private boolean verbose = false;

    public ViterbiAlgorithm(ProfileHMM net, String sequence) {
        super(net, sequence);
    }

    public String calculateViterbiPath() throws IllegalSymbolException, InvalidStructureException, InvalidViterbiPathException {
        this.matchBacktrackPointer = new ViterbiBacktrackObject[this.net.getNumberMatchStates() + 1][this.sequence.length()];
        this.insertBacktrackPointer = new ViterbiBacktrackObject[this.net.getNumberMatchStates() + 1][this.sequence.length()];
        this.deleteBacktrackPointer = new ViterbiBacktrackObject[this.net.getNumberMatchStates() + 1][this.sequence.length()];
        this.matchMatrix = new double[this.net.getNumberMatchStates() + 1][this.sequence.length()];
        this.insertMatrix = new double[this.net.getNumberMatchStates() + 1][this.sequence.length()];
        this.deleteMatrix = new double[this.net.getNumberMatchStates() + 1][this.sequence.length()];
        this.initialiseMatrices();
        this.recurse();
        this.terminate();
        return this.reconstructViterbiPath();
    }

    private String reconstructViterbiPath() throws InvalidViterbiPathException {
        State actual;
        int i;
        String alignment = "";
        Vector<State> viterbiPathReverseOrder = new Vector<State>();
        viterbiPathReverseOrder.add(this.net.getEndState());
        viterbiPathReverseOrder.add(this.net.getMatchState(this.net.getNumberMatchStates() - 1));
        int sequencePointer = this.sequence.length() - 2;
        ViterbiBacktrackObject actualVitPos = this.matchBacktrackPointer[this.net.getNumberMatchStates() - 1][sequencePointer];
        --sequencePointer;
        for (i = this.net.getNumberMatchStates() - 1; i > 0; --i) {
            String type = actualVitPos.getType();
            if (type.equals("D")) {
                actualVitPos = this.deleteBacktrackPointer[i - 2][sequencePointer];
                viterbiPathReverseOrder.add(this.net.getDeleteState(i - 2));
                continue;
            }
            if (type.equals("M")) {
                actualVitPos = this.matchBacktrackPointer[i - 1][sequencePointer];
                viterbiPathReverseOrder.add(this.net.getMatchState(i - 1));
            } else {
                actualVitPos = this.insertBacktrackPointer[i - 1][sequencePointer];
                viterbiPathReverseOrder.add(this.net.getInsertState(i - 1));
                ++i;
            }
            --sequencePointer;
        }
        if (!actualVitPos.getState().equals(this.net.getBeginState())) {
            throw new InvalidViterbiPathException("problem because of:" + actualVitPos.getState().getFullNameId() + " " + sequencePointer + ". We should be in begin state.");
        }
        viterbiPathReverseOrder.add(this.net.getBeginState());
        for (i = 0; i < viterbiPathReverseOrder.size(); ++i) {
            this.viterbiPath.add(i, (State)viterbiPathReverseOrder.get(viterbiPathReverseOrder.size() - 1 - i));
        }
        if (this.verbose) {
            for (i = 0; i < this.viterbiPath.size(); ++i) {
                actual = this.viterbiPath.get(i);
                System.out.print(actual.getFullNameId() + " ");
            }
            System.out.print("\t");
        }
        sequencePointer = 0;
        for (i = 1; i < this.viterbiPath.size() - 1; ++i) {
            actual = this.viterbiPath.get(i);
            String type = actual.getName();
            if (type.equals("M")) {
                if (this.verbose) {
                    System.out.print(("" + this.sequence.charAt(sequencePointer)).toUpperCase());
                }
                alignment = alignment + ("" + this.sequence.charAt(sequencePointer)).toUpperCase();
                ++sequencePointer;
            }
            if (type.equals("D")) {
                if (this.verbose) {
                    System.out.print("-");
                }
                alignment = alignment + "-";
            }
            if (!type.equals("I")) continue;
            if (this.verbose) {
                System.out.print(("" + this.sequence.charAt(sequencePointer)).toLowerCase());
            }
            alignment = alignment + ("" + this.sequence.charAt(sequencePointer)).toLowerCase();
            ++sequencePointer;
        }
        if (this.verbose) {
            System.out.println("\t" + Math.exp(this.score));
        }
        return alignment;
    }

    private void terminate() throws IllegalSymbolException, InvalidStructureException {
        for (int i = 0; i < this.sequence.length() - 1; ++i) {
            this.matchMatrix[this.net.getNumberMatchStates()][i] = Double.NEGATIVE_INFINITY;
        }
        EmissionState end = this.net.getEndState();
        EmissionState matchjMinus1 = this.net.getMatchState(this.net.getNumberMatchStates() - 1);
        double emissionProb = this.calculateLogEmissionProbability(end, this.sequence.length() - 1);
        double matchjMinus1ToEndTrans = this.getIncomingTransitionProbFrom(end, matchjMinus1);
        double matchScore = matchjMinus1ToEndTrans + this.matchMatrix[this.net.getNumberMatchStates() - 1][this.sequence.length() - 2];
        this.matchMatrix[this.net.getNumberMatchStates()][this.sequence.length() - 1] = emissionProb + matchScore;
        this.matchBacktrackPointer[this.net.getNumberMatchStates()][this.sequence.length() - 1] = new ViterbiBacktrackObject(this.net.getMatchState(this.net.getNumberMatchStates() - 1), this.sequence.length() - 2);
        this.score = this.matchMatrix[this.net.getNumberMatchStates()][this.sequence.length() - 1];
    }

    private void recurse() throws IllegalSymbolException, InvalidStructureException {
        for (int j = 1; j < this.net.getNumberMatchStates(); ++j) {
            for (int i = 1; i < this.sequence.length() - 1; ++i) {
                this.updateMatchMatrix(j, i);
                if (j < this.net.getNumberMatchStates() - 1 && i < this.sequence.length() - 2) {
                    this.updateInsertMatrix(j, i);
                }
                if (j >= this.net.getNumberMatchStates() - 2 || i >= this.sequence.length() - 2) continue;
                this.updateDeleteMatrix(j, i);
            }
        }
    }

    private void updateDeleteMatrix(int j, int i) throws InvalidStructureException {
        double deleteScore;
        DeleteState deletej = this.net.getDeleteState(j);
        DeleteState deletejMinus1 = this.net.getDeleteState(j - 1);
        EmissionState matchj = this.net.getMatchState(j);
        double deletejMinus1ToDeletejTrans = this.getIncomingTransitionProbFrom(deletej, deletejMinus1);
        double matchjToDeletejTrans = this.getIncomingTransitionProbFrom(deletej, matchj);
        double matchScore = matchjToDeletejTrans + this.matchMatrix[j][i];
        if (matchScore > (deleteScore = deletejMinus1ToDeletejTrans + this.deleteMatrix[j - 1][i])) {
            this.deleteMatrix[j][i] = matchScore;
            this.deleteBacktrackPointer[j][i] = new ViterbiBacktrackObject(this.net.getMatchState(j), i);
        } else {
            this.deleteMatrix[j][i] = deleteScore;
            this.deleteBacktrackPointer[j][i] = new ViterbiBacktrackObject(this.net.getDeleteState(j - 1), i);
        }
    }

    private void updateInsertMatrix(int j, int i) throws IllegalSymbolException, InvalidStructureException {
        double insertScore;
        EmissionState insertj = this.net.getInsertState(j);
        EmissionState matchj = this.net.getMatchState(j);
        double emissionProb = this.calculateLogEmissionProbability(insertj, i);
        double insertjToInsertjTrans = this.getIncomingTransitionProbFrom(insertj, insertj);
        double matchjToInsertjTrans = this.getIncomingTransitionProbFrom(insertj, matchj);
        double matchScore = matchjToInsertjTrans + this.matchMatrix[j][i - 1];
        if (matchScore > (insertScore = insertjToInsertjTrans + this.insertMatrix[j][i - 1])) {
            this.insertMatrix[j][i] = emissionProb + matchScore;
            this.insertBacktrackPointer[j][i] = new ViterbiBacktrackObject(this.net.getMatchState(j), i - 1);
        } else {
            this.insertMatrix[j][i] = emissionProb + insertScore;
            this.insertBacktrackPointer[j][i] = new ViterbiBacktrackObject(this.net.getInsertState(j), i - 1);
        }
    }

    private void updateMatchMatrix(int j, int i) throws IllegalSymbolException, InvalidStructureException {
        EmissionState matchj = this.net.getMatchState(j);
        EmissionState matchjMinus1 = this.net.getMatchState(j - 1);
        EmissionState insertjMinus1 = this.net.getInsertState(j - 1);
        double emissionProb = this.calculateLogEmissionProbability(matchj, i);
        double matchjMinus1ToMatchjTrans = this.getIncomingTransitionProbFrom(matchj, matchjMinus1);
        double insertjMinus1ToMatchjTrans = this.getIncomingTransitionProbFrom(matchj, insertjMinus1);
        double matchScore = matchjMinus1ToMatchjTrans + this.matchMatrix[j - 1][i - 1];
        double insertScore = insertjMinus1ToMatchjTrans + this.insertMatrix[j - 1][i - 1];
        double deleteScore = Double.NEGATIVE_INFINITY;
        if (j > 1) {
            DeleteState deletejMinus2 = this.net.getDeleteState(j - 2);
            double deletejMinus2ToMatchjTrans = this.getIncomingTransitionProbFrom(matchj, deletejMinus2);
            deleteScore = deletejMinus2ToMatchjTrans + this.deleteMatrix[j - 2][i - 1];
        }
        if (matchScore > insertScore) {
            if (matchScore > deleteScore || j == 1) {
                this.matchMatrix[j][i] = emissionProb + matchScore;
                this.matchBacktrackPointer[j][i] = new ViterbiBacktrackObject(this.net.getMatchState(j - 1), i - 1);
            } else {
                this.matchMatrix[j][i] = emissionProb + deleteScore;
                this.matchBacktrackPointer[j][i] = new ViterbiBacktrackObject(this.net.getDeleteState(j - 2), i - 1);
            }
        } else if (insertScore > deleteScore || j == 1) {
            this.matchMatrix[j][i] = emissionProb + insertScore;
            this.matchBacktrackPointer[j][i] = new ViterbiBacktrackObject(this.net.getInsertState(j - 1), i - 1);
        } else {
            this.matchMatrix[j][i] = emissionProb + deleteScore;
            this.matchBacktrackPointer[j][i] = new ViterbiBacktrackObject(this.net.getDeleteState(j - 2), i - 1);
        }
    }

    private void initialiseMatrices() throws IllegalSymbolException, InvalidStructureException {
        double emissionProb;
        for (int i = 0; i < this.net.getNumberMatchStates() + 1; ++i) {
            for (int j = 0; j < this.sequence.length(); ++j) {
                this.matchMatrix[i][j] = Double.NEGATIVE_INFINITY;
                this.deleteMatrix[i][j] = Double.NEGATIVE_INFINITY;
                this.insertMatrix[i][j] = Double.NEGATIVE_INFINITY;
            }
        }
        EmissionState match0 = this.net.getMatchState(0);
        this.matchMatrix[0][0] = emissionProb = this.calculateLogEmissionProbability(match0, 0);
        this.matchBacktrackPointer[0][0] = new ViterbiBacktrackObject(this.net.getBeginState(), 0);
        for (int i = 1; i < this.sequence.length(); ++i) {
            this.matchMatrix[0][i] = Double.NEGATIVE_INFINITY;
            this.matchBacktrackPointer[0][i] = new ViterbiBacktrackObject(null, 0);
        }
        for (int j = 1; j < this.net.getNumberMatchStates(); ++j) {
            this.matchMatrix[j][0] = Double.NEGATIVE_INFINITY;
            this.matchBacktrackPointer[j][0] = new ViterbiBacktrackObject(null, 0);
        }
        this.insertMatrix[0][0] = Double.NEGATIVE_INFINITY;
        this.insertBacktrackPointer[0][0] = new ViterbiBacktrackObject(null, 0);
        EmissionState insert0 = this.net.getInsertState(0);
        double matchToInsertTrans = this.getIncomingTransitionProbFrom(insert0, match0);
        double insertToInsertTrans = this.getIncomingTransitionProbFrom(insert0, insert0);
        for (int i = 1; i < this.sequence.length() - 1; ++i) {
            emissionProb = this.calculateLogEmissionProbability(insert0, i);
            double fromMatch = matchToInsertTrans + this.matchMatrix[0][i - 1];
            double fromInsert = insertToInsertTrans + this.insertMatrix[0][i - 1];
            if (i == 1) {
                this.insertMatrix[0][i] = emissionProb + fromMatch;
                this.insertBacktrackPointer[0][i] = new ViterbiBacktrackObject(match0, i - 1);
                continue;
            }
            this.insertMatrix[0][i] = emissionProb + fromInsert;
            this.insertBacktrackPointer[0][i] = new ViterbiBacktrackObject(insert0, i - 1);
        }
        this.insertMatrix[0][this.sequence.length() - 1] = Double.NEGATIVE_INFINITY;
        this.insertBacktrackPointer[0][this.sequence.length() - 1] = new ViterbiBacktrackObject(null, 0);
        for (int j = 1; j < this.net.getNumberMatchStates(); ++j) {
            this.insertMatrix[j][0] = Double.NEGATIVE_INFINITY;
            this.insertBacktrackPointer[j][0] = new ViterbiBacktrackObject(null, 0);
        }
        DeleteState delete0 = this.net.getDeleteState(0);
        double matchToDeleteTrans = this.getIncomingTransitionProbFrom(delete0, match0);
        this.deleteMatrix[0][0] = this.matchMatrix[0][0] + matchToDeleteTrans;
        this.deleteBacktrackPointer[0][0] = new ViterbiBacktrackObject(match0, 0);
        for (int i = 1; i < this.sequence.length(); ++i) {
            this.deleteMatrix[0][i] = Double.NEGATIVE_INFINITY;
            this.deleteBacktrackPointer[0][i] = new ViterbiBacktrackObject(null, 0);
        }
        for (int j = 1; j < this.net.getNumberMatchStates(); ++j) {
            this.deleteMatrix[j][0] = Double.NEGATIVE_INFINITY;
            this.deleteBacktrackPointer[j][0] = new ViterbiBacktrackObject(null, 0);
        }
    }

    @Override
    public double getScore() {
        return this.score;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public List<State> getViterbiPath() {
        return this.viterbiPath;
    }
}

