/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize.plugins;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.animate.ColorAnimator;
import prefuse.action.animate.LocationAnimator;
import prefuse.action.animate.QualityControlAnimator;
import prefuse.action.animate.VisibilityAnimator;
import prefuse.action.assignment.ColorAction;
import prefuse.action.assignment.FontAction;
import prefuse.action.filter.FisheyeTreeFilter;
import prefuse.action.layout.CollapsedSubtreeLayout;
import prefuse.action.layout.graph.NodeLinkTreeLayout;
import prefuse.activity.Pacer;
import prefuse.activity.SlowInSlowOutPacer;
import prefuse.controls.Control;
import prefuse.controls.FocusControl;
import prefuse.controls.PanControl;
import prefuse.controls.WheelZoomControl;
import prefuse.controls.ZoomControl;
import prefuse.controls.ZoomToFitControl;
import prefuse.data.Tree;
import prefuse.data.Tuple;
import prefuse.data.event.TupleSetListener;
import prefuse.data.expression.Predicate;
import prefuse.data.io.TreeMLReader;
import prefuse.data.search.PrefixSearchTupleSet;
import prefuse.data.tuple.TupleSet;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.EdgeRenderer;
import prefuse.render.LabelRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.util.ColorLib;
import prefuse.util.FontLib;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.InGroupPredicate;
import prefuse.visual.sort.ItemSorter;
import prefuse.visual.sort.TreeDepthItemSorter;
import weka.gui.treevisualizer.Edge;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.TreeBuild;
import weka.gui.visualize.plugins.TreeVisualizePlugin;

public class PrefuseTree
implements Serializable,
TreeVisualizePlugin {
    private static final long serialVersionUID = 7485599985684890717L;
    public static final String TREE = "tree";
    public static final String TREE_NODES = "tree.nodes";
    public static final String TREE_EDGES = "tree.edges";
    public static final String LABEL = "label";

    public String getMinVersion() {
        return "3.5.9";
    }

    public String getMaxVersion() {
        return "3.7.1";
    }

    public String getDesignVersion() {
        return "3.5.9";
    }

    public JMenuItem getVisualizeMenuItem(String dotty, String name) {
        final String dottyF = dotty;
        final String nameF = name;
        JMenuItem result = new JMenuItem("Prefuse tree");
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrefuseTree.this.display(dottyF, nameF);
            }
        });
        return result;
    }

    protected void displayError(String msg) {
        JOptionPane.showMessageDialog(null, msg, "Error displaying graph", 0);
    }

    protected String convert(String dotty) {
        String result;
        DottyToTree d2gml = new DottyToTree();
        try {
            result = d2gml.convert(dotty);
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
            this.displayError(e.toString());
        }
        return result;
    }

    protected Tree parse(String graphml) {
        Tree result;
        try {
            ByteArrayInputStream inStream = new ByteArrayInputStream(graphml.getBytes());
            result = (Tree)new TreeMLReader().readGraph((InputStream)inStream);
        }
        catch (Exception e) {
            result = null;
            e.printStackTrace();
            this.displayError(e.toString());
        }
        return result;
    }

    protected void display(String dotty, String name) {
        String treeml = this.convert(dotty);
        if (treeml == null) {
            return;
        }
        Tree tree = this.parse(treeml);
        if (tree == null) {
            return;
        }
        TreePanel panel = new TreePanel(tree);
        JFrame frame = new JFrame("Prefuse tree [" + name + "]");
        frame.setSize(800, 600);
        frame.setContentPane((Container)((Object)panel));
        frame.setVisible(true);
    }

    public JComponent getDisplay(String dotty) throws Exception {
        String treeml = this.convert(dotty);
        if (treeml == null) {
            throw new Exception("Problem parsing dotty.");
        }
        Tree tree = this.parse(treeml);
        if (tree == null) {
            throw new Exception("Problem constructing visualization");
        }
        TreePanel panel = new TreePanel(tree);
        return panel;
    }

    public static class TreePanel
    extends Display {
        private static final long serialVersionUID = 8262123080545898882L;
        private static final String tree = "tree";
        private static final String treeNodes = "tree.nodes";
        private static final String treeEdges = "tree.edges";
        private LabelRenderer m_nodeRenderer;
        private EdgeRenderer m_edgeRenderer;
        private String m_label = "name";
        private int m_orientation = 0;

        public TreePanel(Tree t) {
            super(new Visualization());
            this.m_vis.add("tree", (TupleSet)t);
            this.m_nodeRenderer = new LabelRenderer(this.m_label);
            this.m_nodeRenderer.setRenderType(2);
            this.m_nodeRenderer.setHorizontalAlignment(0);
            this.m_nodeRenderer.setRoundedCorner(8, 8);
            this.m_edgeRenderer = new EdgeRenderer(1);
            DefaultRendererFactory rf = new DefaultRendererFactory((Renderer)this.m_nodeRenderer);
            rf.add((Predicate)new InGroupPredicate("tree.edges"), (Renderer)this.m_edgeRenderer);
            this.m_vis.setRendererFactory((RendererFactory)rf);
            NodeColorAction nodeColor = new NodeColorAction("tree.nodes");
            ColorAction textColor = new ColorAction("tree.nodes", VisualItem.TEXTCOLOR, ColorLib.rgb((int)0, (int)0, (int)0));
            this.m_vis.putAction("textColor", (Action)textColor);
            ColorAction edgeColor = new ColorAction("tree.edges", VisualItem.STROKECOLOR, ColorLib.rgb((int)200, (int)200, (int)200));
            ActionList repaint = new ActionList();
            repaint.add((Action)nodeColor);
            repaint.add((Action)new RepaintAction());
            this.m_vis.putAction("repaint", (Action)repaint);
            ActionList fullPaint = new ActionList();
            fullPaint.add((Action)nodeColor);
            this.m_vis.putAction("fullPaint", (Action)fullPaint);
            ActionList animatePaint = new ActionList(400L);
            animatePaint.add((Action)new ColorAnimator("tree.nodes"));
            animatePaint.add((Action)new RepaintAction());
            this.m_vis.putAction("animatePaint", (Action)animatePaint);
            NodeLinkTreeLayout treeLayout = new NodeLinkTreeLayout("tree", this.m_orientation, 50.0, 0.0, 8.0);
            treeLayout.setLayoutAnchor((Point2D)new Point2D.Double(25.0, 300.0));
            this.m_vis.putAction("treeLayout", (Action)treeLayout);
            CollapsedSubtreeLayout subLayout = new CollapsedSubtreeLayout("tree", this.m_orientation);
            this.m_vis.putAction("subLayout", (Action)subLayout);
            AutoPanAction autoPan = new AutoPanAction();
            ActionList filter = new ActionList();
            filter.add((Action)new FisheyeTreeFilter("tree", 2));
            filter.add((Action)new FontAction("tree.nodes", FontLib.getFont((String)"Tahoma", (double)16.0)));
            filter.add((Action)treeLayout);
            filter.add((Action)subLayout);
            filter.add((Action)textColor);
            filter.add((Action)nodeColor);
            filter.add((Action)edgeColor);
            this.m_vis.putAction("filter", (Action)filter);
            ActionList animate = new ActionList(1000L);
            animate.setPacingFunction((Pacer)new SlowInSlowOutPacer());
            animate.add((Action)autoPan);
            animate.add((Action)new QualityControlAnimator());
            animate.add((Action)new VisibilityAnimator("tree"));
            animate.add((Action)new LocationAnimator("tree.nodes"));
            animate.add((Action)new ColorAnimator("tree.nodes"));
            animate.add((Action)new RepaintAction());
            this.m_vis.putAction("animate", (Action)animate);
            this.m_vis.alwaysRunAfter("filter", "animate");
            ActionList orient = new ActionList(2000L);
            orient.setPacingFunction((Pacer)new SlowInSlowOutPacer());
            orient.add((Action)autoPan);
            orient.add((Action)new QualityControlAnimator());
            orient.add((Action)new LocationAnimator("tree.nodes"));
            orient.add((Action)new RepaintAction());
            this.m_vis.putAction("orient", (Action)orient);
            this.setSize(700, 600);
            this.setItemSorter((ItemSorter)new TreeDepthItemSorter());
            this.addControlListener((Control)new ZoomToFitControl());
            this.addControlListener((Control)new ZoomControl());
            this.addControlListener((Control)new WheelZoomControl());
            this.addControlListener((Control)new PanControl());
            this.addControlListener((Control)new FocusControl(1, "filter"));
            this.registerKeyboardAction(new OrientAction(0), "left-to-right", KeyStroke.getKeyStroke("ctrl 1"), 0);
            this.registerKeyboardAction(new OrientAction(2), "top-to-bottom", KeyStroke.getKeyStroke("ctrl 2"), 0);
            this.registerKeyboardAction(new OrientAction(1), "right-to-left", KeyStroke.getKeyStroke("ctrl 3"), 0);
            this.registerKeyboardAction(new OrientAction(3), "bottom-to-top", KeyStroke.getKeyStroke("ctrl 4"), 0);
            this.setOrientation(this.m_orientation);
            this.m_vis.run("filter");
            PrefixSearchTupleSet search = new PrefixSearchTupleSet();
            this.m_vis.addFocusGroup(Visualization.SEARCH_ITEMS, (TupleSet)search);
            search.addTupleSetListener(new TupleSetListener(){

                public void tupleSetChanged(TupleSet t, Tuple[] add, Tuple[] rem) {
                    TreePanel.this.m_vis.cancel("animatePaint");
                    TreePanel.this.m_vis.run("fullPaint");
                    TreePanel.this.m_vis.run("animatePaint");
                }
            });
        }

        public void setOrientation(int orientation) {
            NodeLinkTreeLayout rtl = (NodeLinkTreeLayout)this.m_vis.getAction("treeLayout");
            CollapsedSubtreeLayout stl = (CollapsedSubtreeLayout)this.m_vis.getAction("subLayout");
            switch (orientation) {
                case 0: {
                    this.m_nodeRenderer.setHorizontalAlignment(0);
                    this.m_edgeRenderer.setHorizontalAlignment1(1);
                    this.m_edgeRenderer.setHorizontalAlignment2(0);
                    this.m_edgeRenderer.setVerticalAlignment1(2);
                    this.m_edgeRenderer.setVerticalAlignment2(2);
                    break;
                }
                case 1: {
                    this.m_nodeRenderer.setHorizontalAlignment(1);
                    this.m_edgeRenderer.setHorizontalAlignment1(0);
                    this.m_edgeRenderer.setHorizontalAlignment2(1);
                    this.m_edgeRenderer.setVerticalAlignment1(2);
                    this.m_edgeRenderer.setVerticalAlignment2(2);
                    break;
                }
                case 2: {
                    this.m_nodeRenderer.setHorizontalAlignment(2);
                    this.m_edgeRenderer.setHorizontalAlignment1(2);
                    this.m_edgeRenderer.setHorizontalAlignment2(2);
                    this.m_edgeRenderer.setVerticalAlignment1(3);
                    this.m_edgeRenderer.setVerticalAlignment2(4);
                    break;
                }
                case 3: {
                    this.m_nodeRenderer.setHorizontalAlignment(2);
                    this.m_edgeRenderer.setHorizontalAlignment1(2);
                    this.m_edgeRenderer.setHorizontalAlignment2(2);
                    this.m_edgeRenderer.setVerticalAlignment1(4);
                    this.m_edgeRenderer.setVerticalAlignment2(3);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized orientation value: " + orientation);
                }
            }
            this.m_orientation = orientation;
            rtl.setOrientation(orientation);
            stl.setOrientation(orientation);
        }

        public int getOrientation() {
            return this.m_orientation;
        }

        public static class NodeColorAction
        extends ColorAction {
            public NodeColorAction(String group) {
                super(group, VisualItem.FILLCOLOR);
            }

            public int getColor(VisualItem item) {
                if (this.m_vis.isInGroup(item, Visualization.SEARCH_ITEMS)) {
                    return ColorLib.rgb((int)255, (int)190, (int)190);
                }
                if (this.m_vis.isInGroup(item, Visualization.FOCUS_ITEMS)) {
                    return ColorLib.rgb((int)198, (int)229, (int)229);
                }
                if (item.getDOI() > -1.0) {
                    return ColorLib.rgb((int)164, (int)193, (int)193);
                }
                return ColorLib.rgba((int)255, (int)255, (int)255, (int)0);
            }
        }

        public class AutoPanAction
        extends Action {
            private Point2D m_start = new Point2D.Double();
            private Point2D m_end = new Point2D.Double();
            private Point2D m_cur = new Point2D.Double();
            private int m_bias = 150;

            public void run(double frac) {
                TupleSet ts = this.m_vis.getFocusGroup(Visualization.FOCUS_ITEMS);
                if (ts.getTupleCount() == 0) {
                    return;
                }
                if (frac == 0.0) {
                    int xbias = 0;
                    int ybias = 0;
                    switch (TreePanel.this.m_orientation) {
                        case 0: {
                            xbias = this.m_bias;
                            break;
                        }
                        case 1: {
                            xbias = -this.m_bias;
                            break;
                        }
                        case 2: {
                            ybias = this.m_bias;
                            break;
                        }
                        case 3: {
                            ybias = -this.m_bias;
                        }
                    }
                    VisualItem vi = (VisualItem)ts.tuples().next();
                    this.m_cur.setLocation(TreePanel.this.getWidth() / 2, TreePanel.this.getHeight() / 2);
                    TreePanel.this.getAbsoluteCoordinate(this.m_cur, this.m_start);
                    this.m_end.setLocation(vi.getX() + (double)xbias, vi.getY() + (double)ybias);
                } else {
                    this.m_cur.setLocation(this.m_start.getX() + frac * (this.m_end.getX() - this.m_start.getX()), this.m_start.getY() + frac * (this.m_end.getY() - this.m_start.getY()));
                    TreePanel.this.panToAbs(this.m_cur);
                }
            }
        }

        public class OrientAction
        extends AbstractAction {
            private int orientation;

            public OrientAction(int orientation) {
                this.orientation = orientation;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreePanel.this.setOrientation(this.orientation);
                TreePanel.this.getVisualization().cancel("orient");
                TreePanel.this.getVisualization().run("treeLayout");
                TreePanel.this.getVisualization().run("orient");
            }
        }
    }

    public static class DottyToTree {
        protected String sanitize(String s) {
            String result = s;
            result = result.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
            result = result.replaceAll("\n", "&#10;").replaceAll("\r", "&#13;").replaceAll("\t", "&#9;");
            return result;
        }

        protected void writeHeader(BufferedWriter writer) throws Exception {
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.newLine();
            writer.newLine();
            writer.write("<!-- This file was generated by Weka (http://www.cs.waikato.ac.nz/ml/weka/). -->");
            writer.newLine();
            writer.newLine();
            writer.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\" \"http://www.nomencurator.org/InfoVis2003/download/treeml.dtd\">");
            writer.newLine();
            writer.write("<tree>");
            writer.newLine();
            writer.write("<declarations>");
            writer.newLine();
            writer.write("<attributeDecl name=\"name\" type=\"String\"/>");
            writer.newLine();
            writer.write("</declarations>");
            writer.newLine();
        }

        protected void writeNode(BufferedWriter writer, Node node) throws Exception {
            boolean leaf = node.getChild(0) == null;
            String tag = leaf ? "leaf" : "branch";
            writer.write("<" + tag + ">");
            writer.newLine();
            writer.write("<attribute name=\"name\" value=\"" + this.sanitize(node.getLabel()) + "\"/>");
            writer.newLine();
            if (!leaf) {
                int i = 0;
                while (node.getChild(i) != null) {
                    this.writeEdge(writer, node.getChild(i));
                    ++i;
                }
            }
            writer.write("</" + tag + ">");
            writer.newLine();
        }

        protected void writeEdge(BufferedWriter writer, Edge edge) throws Exception {
            if (edge.getLabel().length() > 0) {
                writer.write("<branch>");
                writer.newLine();
                writer.write("<attribute name=\"name\" value=\"" + this.sanitize(edge.getLabel()) + "\"/>");
                writer.newLine();
                this.writeNode(writer, edge.getTarget());
                writer.write("</branch>");
                writer.newLine();
            } else {
                this.writeNode(writer, edge.getTarget());
            }
        }

        protected void writeFooter(BufferedWriter writer) throws Exception {
            writer.write("</tree>");
            writer.newLine();
        }

        public String convert(String dotty) throws Exception {
            TreeBuild tree = new TreeBuild();
            Node root = tree.create((Reader)new StringReader(dotty));
            StringWriter output = new StringWriter();
            BufferedWriter writer = new BufferedWriter(output);
            this.writeHeader(writer);
            this.writeNode(writer, root);
            this.writeFooter(writer);
            writer.flush();
            return output.toString();
        }
    }
}

