/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NumericToBinary;

public class NumericToBinaryTest
extends AbstractFilterTest {
    public NumericToBinaryTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        NumericToBinary f = new NumericToBinary();
        return f;
    }

    public void testTypical() {
        Instances result = this.useFilter();
        NumericToBinaryTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        NumericToBinaryTest.assertEquals((int)this.m_Instances.numInstances(), (int)result.numInstances());
        for (int j = 0; j < result.numAttributes(); ++j) {
            if (!this.m_Instances.attribute(j).isNumeric()) continue;
            NumericToBinaryTest.assertTrue((String)"Numeric attribute should now be nominal", (boolean)result.attribute(j).isNominal());
            for (int i = 0; i < result.numInstances(); ++i) {
                if (this.m_Instances.instance(i).isMissing(j)) {
                    NumericToBinaryTest.assertTrue((boolean)result.instance(i).isMissing(j));
                    continue;
                }
                if (this.m_Instances.instance(i).value(j) == 0.0) {
                    NumericToBinaryTest.assertTrue((String)"Output value should be 0", (result.instance(i).value(j) == 0.0 ? 1 : 0) != 0);
                    continue;
                }
                NumericToBinaryTest.assertTrue((String)"Output value should be 1", (result.instance(i).value(j) == 1.0 ? 1 : 0) != 0);
            }
        }
    }

    public void testSpecificIndex() {
        int att1 = this.m_Instances.attribute("NumericAtt1").index();
        int att2 = this.m_Instances.attribute("NumericAtt2").index();
        ((NumericToBinary)this.m_Filter).setAttributeIndices(String.valueOf(att1 + 1));
        Instances result = this.useFilter();
        NumericToBinaryTest.assertTrue((String)"NumericAtt1 should be nominal", (boolean)result.attribute(att1).isNominal());
        NumericToBinaryTest.assertTrue((String)"NumericAtt2 should be numeric", (boolean)result.attribute(att2).isNumeric());
    }

    public void testInvertSelection() {
        int att1 = this.m_Instances.attribute("NumericAtt1").index();
        int att2 = this.m_Instances.attribute("NumericAtt2").index();
        ((NumericToBinary)this.m_Filter).setAttributeIndices(String.valueOf(att2 + 1));
        ((NumericToBinary)this.m_Filter).setInvertSelection(true);
        Instances result = this.useFilter();
        NumericToBinaryTest.assertTrue((String)"NumericAtt1 should be nominal", (boolean)result.attribute(att1).isNominal());
        NumericToBinaryTest.assertTrue((String)"NumericAtt2 should be numeric", (boolean)result.attribute(att2).isNumeric());
    }

    public void testRange() {
        int att1 = this.m_Instances.attribute("NumericAtt1").index();
        int att2 = this.m_Instances.attribute("NumericAtt2").index();
        ((NumericToBinary)this.m_Filter).setAttributeIndices("first-last");
        ((NumericToBinary)this.m_Filter).setInvertSelection(false);
        Instances result = this.useFilter();
        NumericToBinaryTest.assertTrue((String)"NumericAtt1 should be nominal", (boolean)result.attribute(att1).isNominal());
        NumericToBinaryTest.assertTrue((String)"NumericAtt2 should be nominal", (boolean)result.attribute(att2).isNominal());
    }

    public static Test suite() {
        return new TestSuite(NumericToBinaryTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)NumericToBinaryTest.suite());
    }
}

