/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.converters.AbstractFileConverterTest;
import weka.core.converters.AbstractLoader;
import weka.core.converters.AbstractSaver;
import weka.core.converters.C45Loader;
import weka.core.converters.C45Saver;

public class C45Test
extends AbstractFileConverterTest {
    protected String m_ExportFilenameData;

    public C45Test(String name) {
        super(name);
    }

    public AbstractLoader getLoader() {
        return new C45Loader();
    }

    public AbstractSaver getSaver() {
        return new C45Saver();
    }

    protected String getExportFilenameData() {
        return this.m_ExportFilename.replaceAll("\\.names", ".data");
    }

    protected String[] getCommandlineOptions(boolean loader) {
        if (loader) {
            return super.getCommandlineOptions(loader);
        }
        return new String[]{"-i", this.m_SourceFilename, "-o", this.m_ExportFilename, "-c", "last"};
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_ExportFilenameData = this.getExportFilenameData();
        File file = new File(this.m_ExportFilenameData);
        if (file.exists()) {
            file.delete();
        }
    }

    protected void tearDown() throws Exception {
        File file = new File(this.m_ExportFilenameData);
        if (file.exists()) {
            file.delete();
        }
        this.m_ExportFilenameData = null;
        super.tearDown();
    }

    public void testLoaderWithStream() {
        System.out.println("testLoaderWithStream is ignored!");
    }

    public static Test suite() {
        return new TestSuite(C45Test.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)C45Test.suite());
    }
}

