/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.instance;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.unsupervised.instance.Resample;

public class ResampleTest
extends AbstractFilterTest {
    public ResampleTest(String name) {
        super(name);
    }

    @Override
    public Filter getFilter() {
        Resample f = new Resample();
        f.setSampleSizePercent(50.0);
        return f;
    }

    public void testSampleSizePercent() {
        Instances result = this.useFilter();
        ResampleTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        ResampleTest.assertEquals((String)"Expecting output to be 50% of input", (int)(this.m_Instances.numInstances() / 2), (int)result.numInstances());
        ((Resample)this.m_Filter).setSampleSizePercent(200.0);
        result = this.useFilter();
        ResampleTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        ResampleTest.assertEquals((String)"Expecting output to be 200% of input", (int)(this.m_Instances.numInstances() * 2), (int)result.numInstances());
    }

    public void testSampleSizePercentNoReplacement() {
        ((Resample)this.m_Filter).setSampleSizePercent(20.0);
        ((Resample)this.m_Filter).setNoReplacement(true);
        Instances result = this.useFilter();
        ResampleTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        ResampleTest.assertEquals((String)"Expecting output to be 20% of input", (int)((int)((double)this.m_Instances.numInstances() * 20.0 / 100.0)), (int)result.numInstances());
    }

    public void testSampleSizePercentNoReplacementInverted() {
        ((Resample)this.m_Filter).setSampleSizePercent(20.0);
        ((Resample)this.m_Filter).setNoReplacement(true);
        ((Resample)this.m_Filter).setInvertSelection(true);
        Instances result = this.useFilter();
        ResampleTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        ResampleTest.assertEquals((String)"Expecting output to be 80% of input (20% inverted)", (int)(this.m_Instances.numInstances() - (int)((double)this.m_Instances.numInstances() * 20.0 / 100.0)), (int)result.numInstances());
    }

    public static Test suite() {
        return new TestSuite(ResampleTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ResampleTest.suite());
    }
}

