/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.attribute;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import weka.core.Instances;
import weka.filters.AbstractFilterTest;
import weka.filters.Filter;
import weka.filters.supervised.attribute.Discretize;

public class DiscretizeTest
extends AbstractFilterTest {
    public DiscretizeTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.m_Instances.setClassIndex(1);
    }

    @Override
    public Filter getFilter() {
        Discretize f = new Discretize();
        return f;
    }

    public Filter getFilter(String rangelist) {
        try {
            Discretize f = new Discretize();
            f.setAttributeIndices(rangelist);
            return f;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            DiscretizeTest.fail((String)("Exception setting attribute range: " + rangelist + "\n" + ex.getMessage()));
            return null;
        }
    }

    public void testTypical() {
        this.m_Filter = this.getFilter("1,2");
        Instances result = this.useFilter();
        DiscretizeTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        for (int i = 0; i < result.numAttributes(); ++i) {
            DiscretizeTest.assertEquals((int)this.m_Instances.attribute(i).type(), (int)result.attribute(i).type());
            DiscretizeTest.assertEquals((String)this.m_Instances.attribute(i).name(), (String)result.attribute(i).name());
        }
    }

    public void testTypical2() {
        this.m_Filter = this.getFilter("3-4");
        Instances result = this.useFilter();
        DiscretizeTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        for (int i = 0; i < result.numAttributes(); ++i) {
            if (i != 2) {
                DiscretizeTest.assertEquals((int)this.m_Instances.attribute(i).type(), (int)result.attribute(i).type());
                DiscretizeTest.assertEquals((String)this.m_Instances.attribute(i).name(), (String)result.attribute(i).name());
                continue;
            }
            DiscretizeTest.assertEquals((int)1, (int)result.attribute(i).type());
            DiscretizeTest.assertEquals((int)1, (int)result.attribute(i).numValues());
        }
    }

    public void testInverted() {
        this.m_Filter = this.getFilter("1,2");
        ((Discretize)this.m_Filter).setInvertSelection(true);
        Instances result = this.useFilter();
        DiscretizeTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        for (int i = 0; i < result.numAttributes(); ++i) {
            if (i < 2 || !this.m_Instances.attribute(i).isNumeric()) {
                DiscretizeTest.assertEquals((int)this.m_Instances.attribute(i).type(), (int)result.attribute(i).type());
                DiscretizeTest.assertEquals((String)this.m_Instances.attribute(i).name(), (String)result.attribute(i).name());
                continue;
            }
            DiscretizeTest.assertEquals((int)1, (int)result.attribute(i).type());
            DiscretizeTest.assertEquals((int)1, (int)result.attribute(i).numValues());
        }
    }

    public void testNonInverted2() {
        this.m_Filter = this.getFilter("first-3");
        ((Discretize)this.m_Filter).setInvertSelection(true);
        Instances result = this.useFilter();
        DiscretizeTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        for (int i = 0; i < result.numAttributes(); ++i) {
            if (i < 3 || !this.m_Instances.attribute(i).isNumeric()) {
                DiscretizeTest.assertEquals((int)this.m_Instances.attribute(i).type(), (int)result.attribute(i).type());
                DiscretizeTest.assertEquals((String)this.m_Instances.attribute(i).name(), (String)result.attribute(i).name());
                continue;
            }
            DiscretizeTest.assertEquals((int)1, (int)result.attribute(i).type());
            DiscretizeTest.assertEquals((int)1, (int)result.attribute(i).numValues());
        }
    }

    public void testBetterEncoding() {
        this.m_Filter = this.getFilter("3");
        ((Discretize)this.m_Filter).setUseBetterEncoding(true);
        Instances result = this.useFilter();
        DiscretizeTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        DiscretizeTest.assertEquals((int)1, (int)result.attribute(2).type());
    }

    public void testUseKononenko() {
        this.m_Filter = this.getFilter("3");
        ((Discretize)this.m_Filter).setUseKononenko(true);
        Instances result = this.useFilter();
        DiscretizeTest.assertEquals((int)this.m_Instances.numAttributes(), (int)result.numAttributes());
        DiscretizeTest.assertEquals((int)1, (int)result.attribute(2).type());
    }

    public static Test suite() {
        return new TestSuite(DiscretizeTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DiscretizeTest.suite());
    }
}

